/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.memory.MemoryManager;

public class PingFrame
extends Http2Frame {
    private static final ThreadCache.CachedTypeIndex<PingFrame> CACHE_IDX = ThreadCache.obtainIndex(PingFrame.class, 8);
    public static final int TYPE = 6;
    public static final byte ACK_FLAG = 1;
    static final Map<Integer, String> FLAG_NAMES_MAP = new HashMap<Integer, String>(2);
    private long opaqueData;

    private PingFrame() {
    }

    static PingFrame create() {
        PingFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new PingFrame();
        }
        return frame;
    }

    public static Http2Frame fromBuffer(int flags, int streamId, Buffer frameBuffer) {
        PingFrame frame = PingFrame.create();
        frame.setFlags(flags);
        frame.setStreamId(streamId);
        frame.setFrameBuffer(frameBuffer);
        if (frameBuffer.remaining() != 8) {
            frame.length = frameBuffer.remaining();
        } else {
            frame.opaqueData = frameBuffer.getLong();
        }
        return frame;
    }

    public static PingFrameBuilder builder() {
        return new PingFrameBuilder();
    }

    public long getOpaqueData() {
        return this.opaqueData;
    }

    public boolean isAckSet() {
        return this.isFlagSet(1);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PingFrame {").append(this.headerToString()).append(", opaqueData=").append(this.opaqueData).append('}');
        return sb.toString();
    }

    @Override
    protected int calcLength() {
        return 8;
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return FLAG_NAMES_MAP;
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.opaqueData = 0L;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Object buffer = memoryManager.allocate(17);
        this.serializeFrameHeader((Buffer)buffer);
        buffer.putLong(this.opaqueData);
        buffer.trim();
        return buffer;
    }

    static {
        FLAG_NAMES_MAP.put(1, "ACK");
    }

    public static class PingFrameBuilder
    extends Http2Frame.Http2FrameBuilder<PingFrameBuilder> {
        private long opaqueData;

        protected PingFrameBuilder() {
        }

        public PingFrameBuilder opaqueData(long opaqueData) {
            this.opaqueData = opaqueData;
            return this;
        }

        public PingFrameBuilder ack(boolean isAck) {
            if (isAck) {
                this.setFlag(1);
            }
            return this;
        }

        @Override
        public PingFrame build() {
            PingFrame frame = PingFrame.create();
            this.setHeaderValuesTo(frame);
            frame.opaqueData = this.opaqueData;
            return frame;
        }

        @Override
        protected PingFrameBuilder getThis() {
            return this;
        }
    }
}

