/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;

public interface AsyncQueueIO<L> {
    public AsyncQueueReader<L> getReader();

    public AsyncQueueWriter<L> getWriter();

    public static final class MutableAsyncQueueIO<L>
    implements AsyncQueueIO<L> {
        private volatile AsyncQueueReader<L> reader;
        private volatile AsyncQueueWriter<L> writer;

        private MutableAsyncQueueIO(AsyncQueueReader<L> reader, AsyncQueueWriter<L> writer) {
            this.reader = reader;
            this.writer = writer;
        }

        @Override
        public AsyncQueueReader<L> getReader() {
            return this.reader;
        }

        public void setReader(AsyncQueueReader<L> reader) {
            this.reader = reader;
        }

        @Override
        public AsyncQueueWriter<L> getWriter() {
            return this.writer;
        }

        public void setWriter(AsyncQueueWriter<L> writer) {
            this.writer = writer;
        }
    }

    public static final class ImmutableAsyncQueueIO<L>
    implements AsyncQueueIO<L> {
        private final AsyncQueueReader<L> reader;
        private final AsyncQueueWriter<L> writer;

        private ImmutableAsyncQueueIO(AsyncQueueReader<L> reader, AsyncQueueWriter<L> writer) {
            this.reader = reader;
            this.writer = writer;
        }

        @Override
        public AsyncQueueReader<L> getReader() {
            return this.reader;
        }

        @Override
        public AsyncQueueWriter<L> getWriter() {
            return this.writer;
        }
    }

    public static class Factory {
        public static <L> AsyncQueueIO<L> createImmutable(AsyncQueueReader<L> reader, AsyncQueueWriter<L> writer) {
            return new ImmutableAsyncQueueIO(reader, writer);
        }

        public static <L> MutableAsyncQueueIO<L> createMutable(AsyncQueueReader<L> reader, AsyncQueueWriter<L> writer) {
            return new MutableAsyncQueueIO(reader, writer);
        }
    }
}

