/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClusterMessageAckInfo {
    protected Logger logger = Globals.getLogger();
    private SysMessageID[] sysids = null;
    private ConsumerUID[] intids = null;
    private int ackType;
    private Long ackackXid = null;
    private Map optionalProps = null;
    private Long transactionID = null;
    private UID txnStoreSession = null;
    private BrokerAddress msgHome;
    private Cluster c = null;
    private GPacket pkt = null;
    private DataInputStream dis = null;
    private static FaultInjection fi = FaultInjection.getInjection();
    private boolean twophase = false;
    private boolean ackackAsync = false;

    private ClusterMessageAckInfo(SysMessageID[] sysids, ConsumerUID[] intids, int ackType, Long ackackXid, boolean async, Map optionalProps, Long transactionID, UID txnStoreSession, BrokerAddress msgHome, Cluster c, boolean twophase) {
        this.sysids = sysids;
        this.intids = intids;
        this.ackType = ackType;
        this.ackackXid = ackackXid;
        this.optionalProps = optionalProps;
        this.transactionID = transactionID;
        this.txnStoreSession = txnStoreSession;
        this.msgHome = msgHome;
        this.c = c;
        this.twophase = twophase;
        this.ackackAsync = async;
    }

    private ClusterMessageAckInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    private ClusterMessageAckInfo(GPacket pkt) {
        this.pkt = pkt;
        this.c = null;
    }

    public static ClusterMessageAckInfo newInstance(SysMessageID[] sysids, ConsumerUID[] cuids, int ackType, Long ackackXid, boolean async, Map optionalProps, Long transactionID, UID txnStoreSession, BrokerAddress msgHome, Cluster c, boolean twophase) {
        return new ClusterMessageAckInfo(sysids, cuids, ackType, ackackXid, async, optionalProps, transactionID, txnStoreSession, msgHome, c, twophase);
    }

    public static ClusterMessageAckInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterMessageAckInfo(pkt, c);
    }

    public GPacket getGPacket() throws IOException {
        if (this.twophase && this.transactionID == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B3100", "transactionID required for two-phase ack"));
        }
        GPacket gp = GPacket.getInstance();
        gp.setType((short)3);
        gp.putProp("T", this.ackType);
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        if (this.msgHome.getBrokerSessionUID() != null) {
            gp.putProp("messageBrokerSession", this.msgHome.getBrokerSessionUID().longValue());
        }
        if (this.msgHome.getStoreSessionUID() != null) {
            gp.putProp("messageStoreSession", this.msgHome.getStoreSessionUID().longValue());
        }
        if (this.optionalProps != null) {
            Object pn2 = null;
            for (Object pn2 : this.optionalProps.keySet()) {
                gp.putProp(pn2, this.optionalProps.get(pn2));
            }
        }
        if (this.transactionID != null) {
            gp.putProp("transactionID", this.transactionID);
            if (this.txnStoreSession != null) {
                gp.putProp("transactionStoreSession", this.txnStoreSession.longValue());
            }
        }
        if (this.ackackXid != null) {
            gp.setBit(1, true);
            gp.putProp("X", this.ackackXid);
            if (this.ackackAsync) {
                gp.putProp("ackackAsync", true);
            }
        }
        if (this.ackType == 10) {
            gp.putProp("C", 0);
            return gp;
        }
        int cnt = this.sysids.length;
        gp.putProp("C", cnt);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        for (int i = 0; i < cnt; ++i) {
            this.sysids[i].writeID(dos);
            ClusterConsumerInfo.writeConsumerUID(this.intids[i], dos);
        }
        dos.flush();
        bos.flush();
        byte[] buf = bos.toByteArray();
        gp.setPayload(ByteBuffer.wrap(buf));
        return gp;
    }

    public int getAckType() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("T");
    }

    public Map getOptionalProps() {
        assert (this.pkt != null);
        Set keys = this.pkt.propsKeySet();
        if (keys == null || keys.size() == 0) {
            return null;
        }
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        Object key2 = null;
        for (Object key2 : keys) {
            m.put(key2, this.pkt.getProp(key2));
        }
        return m;
    }

    public UID getMessageStoreSessionUID() {
        assert (this.pkt != null);
        Long ssid = (Long)this.pkt.getProp("messageStoreSession");
        if (ssid == null) {
            return null;
        }
        return new UID(ssid);
    }

    public UID getMessageBrokerSessionUID() {
        assert (this.pkt != null);
        Long bsid = (Long)this.pkt.getProp("messageBrokerSession");
        if (bsid == null) {
            return null;
        }
        return new UID(bsid);
    }

    public Long getTransactionID() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("transactionID");
    }

    public UID getTransactionStoreSessionUID() {
        assert (this.pkt != null);
        Long ssid = (Long)this.pkt.getProp("transactionStoreSession");
        if (ssid == null) {
            return null;
        }
        return new UID(ssid);
    }

    public Integer getCount() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("C");
    }

    public void initPayloadRead() {
        assert (this.pkt != null);
        byte[] buf = this.pkt.getPayload().array();
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        this.dis = new DataInputStream(bis);
    }

    public SysMessageID readPayloadSysMessageID() throws IOException {
        assert (this.dis != null);
        SysMessageID sysid = new SysMessageID();
        sysid.readID(this.dis);
        return sysid;
    }

    public ConsumerUID readPayloadConsumerUID() throws Exception {
        BrokerAddress ba;
        assert (this.dis != null);
        ConsumerUID intid = ClusterConsumerInfo.readConsumerUID(this.dis);
        if (this.c != null && (ba = this.c.unmarshalBrokerAddress(this.pkt)) != null) {
            intid.setBrokerAddress(ba);
        }
        return intid;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int status, String reason, ArrayList[] aes) {
        assert (this.pkt != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)4);
        gp.putProp("X", this.pkt.getProp("X"));
        gp.putProp("T", this.getAckType());
        if (this.pkt.getProp("C") != null) {
            gp.putProp("C", this.pkt.getProp("C"));
        }
        if (this.pkt.getProp("messageBrokerSession") != null) {
            gp.putProp("messageBrokerSession", this.pkt.getProp("messageBrokerSession"));
        }
        if (this.pkt.getProp("messageStoreSession") != null) {
            gp.putProp("messageStoreSession", this.pkt.getProp("messageStoreSession"));
        }
        if (this.pkt.getProp("transactionID") != null) {
            gp.putProp("transactionID", this.pkt.getProp("transactionID"));
        }
        if (this.pkt.getProp("ackackAsync") != null) {
            gp.putProp("ackackAsync", this.pkt.getProp("ackackAsync"));
        }
        gp.putProp("S", status);
        if (reason != null) {
            gp.putProp("reason", reason);
        }
        if (aes == null) {
            if (this.pkt.getPayload() != null) {
                gp.setPayload(ByteBuffer.wrap(this.pkt.getPayload().array()));
            }
            return gp;
        }
        gp.putProp("notfound", aes[0].size());
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (int i = 0; i < aes[0].size(); ++i) {
                ((SysMessageID)aes[0].get(i)).writeID(dos);
                ClusterConsumerInfo.writeConsumerUID((ConsumerUID)aes[1].get(i), dos);
            }
            dos.flush();
            bos.flush();
            byte[] buf = bos.toByteArray();
            gp.setPayload(ByteBuffer.wrap(buf));
        }
        catch (Exception e) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.logStack(16, e.getMessage(), e);
        }
        return gp;
    }

    public static AckEntryNotFoundException getAckEntryNotFoundException(GPacket ackack) {
        Integer notfound = (Integer)ackack.getProp("notfound");
        if (notfound == null) {
            return null;
        }
        int cnt = notfound;
        String reason = (String)ackack.getProp("reason");
        AckEntryNotFoundException aee = new AckEntryNotFoundException(reason);
        byte[] buf = ackack.getPayload().array();
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        SysMessageID sysid = null;
        ConsumerUID intid = null;
        try {
            for (int i = 0; i < cnt; ++i) {
                sysid = new SysMessageID();
                sysid.readID(dis);
                intid = ClusterConsumerInfo.readConsumerUID(dis);
                aee.addAckEntry(sysid, intid);
            }
        }
        catch (Exception e) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.logStack(16, e.getMessage(), e);
        }
        return aee;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n\tAckType = ").append(ClusterGlobals.getAckTypeString(this.ackType));
        if (this.msgHome.getBrokerSessionUID() != null) {
            buf.append("\n\tMessageBrokerSession = ").append(this.msgHome.getBrokerSessionUID().longValue());
        }
        if (this.msgHome.getHAEnabled()) {
            buf.append("\n\tMessageStoreSession = ").append(this.msgHome.getStoreSessionUID().longValue());
        }
        if (this.transactionID != null) {
            buf.append("\n\tTransactionID = ").append(this.transactionID);
        }
        if (this.ackackXid != null) {
            buf.append("\n\tAckAck = ").append("true");
            buf.append("\n\tXID = ").append(this.ackackXid);
        }
        buf.append("\n\tMessage Home = ").append(this.msgHome);
        if (this.sysids != null) {
            buf.append("\n\tC=").append((Object)this.sysids.length);
            for (int i = 0; i < this.sysids.length; ++i) {
                buf.append("\n\t\tSysMessageID = ").append(this.sysids[i]);
                buf.append("\n\t\tConsumerUID = ").append(this.intids[i]);
            }
        }
        if (this.optionalProps != null) {
            buf.append("\n\tOptional Props = ").append("" + this.optionalProps);
        }
        buf.append("\n");
        return buf.toString();
    }

    public String toString(SysMessageID[] sysids, ConsumerUID[] cuids) {
        assert (this.pkt != null);
        StringBuffer buf = new StringBuffer();
        buf.append("\n\tAckType = ").append(ClusterGlobals.getAckTypeString(this.getAckType()));
        if (this.getMessageBrokerSessionUID() != null) {
            buf.append("\n\tMessageBrokerSession = ").append(this.getMessageBrokerSessionUID().longValue());
        }
        if (this.getMessageStoreSessionUID() != null) {
            buf.append("\n\tMessageStoreSession = ").append(this.getMessageStoreSessionUID().longValue());
        }
        if (this.getTransactionID() != null) {
            buf.append("\n\tTransactionID = ").append(this.getTransactionID());
        }
        if (this.pkt.getProp("X") != null) {
            buf.append("\n\tXID = ").append(this.pkt.getProp("X"));
        }
        if (this.getCount() != null) {
            buf.append("\n\tCount = ").append(this.getCount());
        }
        if (sysids != null) {
            buf.append("\n\tC=").append(sysids.length);
            for (int i = 0; i < sysids.length; ++i) {
                buf.append("\n\t\tSysMessageID = ").append(sysids[i]);
                buf.append("\n\t\tConsumerUID = ").append(cuids[i]);
                buf.append("\n");
            }
        }
        buf.append("\n");
        return buf.toString();
    }

    public static Long getAckAckXid(GPacket ackack) {
        return (Long)ackack.getProp("X");
    }

    public static Integer getAckAckType(GPacket ackack) {
        return (Integer)ackack.getProp("T");
    }

    public static boolean isAckAckAsync(GPacket ackack) {
        Boolean b = (Boolean)ackack.getProp("ackackAsync");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static Long getAckAckTransactionID(GPacket ackack) {
        return (Long)ackack.getProp("transactionID");
    }

    public static int getAckAckStatus(GPacket ackack) {
        return (Integer)ackack.getProp("S");
    }

    public static String getAckAckStatusReason(GPacket ackack) {
        return (String)ackack.getProp("reason");
    }

    public static UID getAckAckStoreSessionUID(GPacket ackack) {
        Long v = (Long)ackack.getProp("messageBrokerSession");
        if (v == null) {
            return null;
        }
        return new UID(v);
    }

    public static String toString(GPacket ackack) {
        int acktyp = -1;
        if (ClusterMessageAckInfo.getAckAckType(ackack) != null) {
            acktyp = ClusterMessageAckInfo.getAckAckType(ackack);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\n\tackStatus = ").append(Status.getString(ClusterMessageAckInfo.getAckAckStatus(ackack)));
        if (ackack.getProp("reason") != null) {
            buf.append("\n\tReason = ").append(ClusterMessageAckInfo.getAckAckStatusReason(ackack));
        }
        buf.append("\n\tAckType = ").append(ClusterGlobals.getAckTypeString(acktyp));
        if (ackack.getProp("messageBrokerSession") != null) {
            buf.append("\n\tMessageBrokerSession = ").append(ackack.getProp("messageBrokerSession"));
        }
        if (ackack.getProp("messageStoreSession") != null) {
            buf.append("\n\tMessageStoreSession = ").append(ackack.getProp("messageStoreSession"));
        }
        if (ackack.getProp("transactionID") != null) {
            buf.append("\n\tTransactionID = ").append(ackack.getProp("transactionID"));
        }
        if (ackack.getProp("notfound") != null) {
            buf.append("\n\tnotfound = ").append(ackack.getProp("notfound"));
        }
        if (ackack.getPayload() != null) {
            Integer notfound = (Integer)ackack.getProp("notfound");
            ClusterMessageAckInfo cai = new ClusterMessageAckInfo(ackack);
            try {
                int cnt;
                int n = cnt = cai.getCount() == null ? 1 : cai.getCount();
                if (notfound != null) {
                    cnt = notfound;
                }
                cai.initPayloadRead();
                for (int i = 0; i < cnt; ++i) {
                    buf.append("\n\t\tSysMessageID = ").append(cai.readPayloadSysMessageID());
                    buf.append("\n\t\tConsumerUID = ").append(cai.readPayloadConsumerUID().longValue());
                    buf.append("\n");
                }
            }
            catch (Exception e) {
                Globals.getLogger().logStack(16, e.getMessage(), e);
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CHECKFAULT(HashMap ackCounts, int ackType, Long txnID, String fprefix, String fstage) {
        int ackCount = 0;
        HashMap<String, Integer> fips = new HashMap<String, Integer>();
        Integer ak = ackType;
        HashMap hashMap = ackCounts;
        synchronized (hashMap) {
            Integer v = (Integer)ackCounts.get(ak);
            if (v != null) {
                ackCount = v;
            }
            if (fstage.equals("1")) {
                ackCounts.put(ak, ++ackCount);
            }
        }
        fips.put("mqAckCount", ackCount);
        String faultstr = null;
        switch (ackType) {
            case 3: {
                faultstr = txnID == null ? "" : "txncommit.";
                break;
            }
            case 9: {
                faultstr = "txnprepare.";
                break;
            }
            case 10: {
                faultstr = "txnrollback.";
            }
        }
        fi.checkFaultAndExit(fprefix + faultstr + fstage, fips, 2, false);
    }
}

