/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Hashtable;

public class TransactionState
implements Externalizable,
Serializable {
    static final long serialVersionUID = 8746365555417644726L;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    public static final int COMMITTED = 6;
    public static final int ROLLEDBACK = 7;
    public static final int TIMED_OUT = 8;
    public static final int LAST = 8;
    public static final int NULL = -1;
    private static final String[] names = new String[]{"CREATED", "STARTED", "FAILED", "INCOMPLETE", "COMPLETE", "PREPARED", "COMMITED", "ROLLEDBACK", "TIMED_OUT"};
    private JMQXid xid = null;
    private long createTime = 0L;
    private long lifetime = 0L;
    private long expireTime = 0L;
    private long lastAccessTime = 0L;
    AutoRollbackType type = AutoRollbackType.ALL;
    boolean sessionLess = false;
    private transient String creator = null;
    private int state = 0;
    private String user = null;
    private String clientID = null;
    private String connectionString = null;
    private boolean onephasePrepare = false;
    private transient ConnectionUID connectionUID = null;
    private transient boolean detached = false;
    private transient long detachedTime = 0L;
    private transient int failToState = -1;
    private transient int failFromState = -1;
    private static final JMQXid EMPTY_JMQXID = new JMQXid();

    public TransactionState() {
    }

    public TransactionState(AutoRollbackType type, long lifetime, boolean sessionLess) {
        this.state = 0;
        this.type = type == null ? AutoRollbackType.ALL : type;
        this.createTime = System.currentTimeMillis();
        this.lifetime = lifetime;
        this.expireTime = this.createTime + lifetime;
        this.lastAccessTime = this.createTime;
        this.sessionLess = sessionLess;
    }

    public TransactionState(TransactionState ts) {
        this.xid = new JMQXid(ts.xid);
        this.state = ts.state;
        this.user = ts.user;
        this.clientID = ts.clientID;
        this.createTime = ts.createTime;
        this.lifetime = ts.lifetime;
        this.expireTime = ts.expireTime;
        this.lastAccessTime = ts.lastAccessTime;
        this.connectionString = ts.connectionString;
        this.sessionLess = ts.sessionLess;
        this.type = ts.type == null ? (ts.xid == null ? AutoRollbackType.ALL : AutoRollbackType.NOT_PREPARED) : ts.type;
        this.connectionUID = ts.connectionUID;
        this.detached = ts.detached;
        this.detachedTime = ts.detachedTime;
        this.onephasePrepare = ts.onephasePrepare;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("xid", this.xid == null ? "none" : this.xid.toString());
        ht.put("state", names[this.state]);
        ht.put("failToState", TransactionState.toString(this.failToState));
        ht.put("failFromState", TransactionState.toString(this.failFromState));
        ht.put("user", this.user == null ? "none" : this.user);
        ht.put("connectionString", this.connectionString == null ? "none" : this.connectionString);
        ht.put("clientID", this.clientID == null ? "none" : this.clientID);
        ht.put("type", this.getType().toString());
        ht.put("createTime", String.valueOf(this.createTime));
        ht.put("lifetime", Long.valueOf(this.lifetime).toString());
        ht.put("expireTime", Long.valueOf(this.expireTime).toString());
        ht.put("lastAccessTime", Long.valueOf(this.lastAccessTime).toString());
        ht.put("sessionLess", Boolean.valueOf(this.sessionLess).toString());
        ht.put("detached", String.valueOf(this.detached));
        ht.put("detachedTime", String.valueOf(this.detachedTime));
        if (this.state >= 5) {
            ht.put("onephasePrepare", this.onephasePrepare);
        }
        return ht;
    }

    public AutoRollbackType getType() {
        return this.type;
    }

    public long getCreationTime() {
        return this.createTime;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public long getExpirationTime() {
        return this.expireTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void updateAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean isSessionLess() {
        return this.sessionLess;
    }

    public void setState(int state) throws BrokerException {
        if (state < 0 || state > 8) {
            throw new BrokerException("Illegal state " + state + ". Should be between " + 0 + " and " + 8 + " inclusive.");
        }
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setXid(JMQXid xid) {
        this.xid = xid;
    }

    public JMQXid getXid() {
        return this.xid;
    }

    public boolean isXA() {
        return this.xid != null && !this.xid.isNullXid();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setClientID(String id) {
        this.clientID = id;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setConnectionString(String s) {
        this.connectionString = s;
    }

    public String getConnectionString() {
        return this.connectionString == null ? "none" : this.connectionString;
    }

    public void setConnectionUID(ConnectionUID cuid) {
        this.connectionUID = cuid;
    }

    public ConnectionUID getConnectionUID() {
        return this.connectionUID;
    }

    public void detachedFromConnection() {
        this.detached = true;
        this.detachedTime = System.currentTimeMillis();
    }

    public boolean isDetachedFromConnection() {
        return this.detached;
    }

    public long getDetachedTime() {
        return this.detachedTime;
    }

    public void setOnephasePrepare(boolean b) {
        this.onephasePrepare = b;
    }

    public void setFailToState(int fs) {
        this.failToState = fs;
    }

    public void setFailFromState(int fs) {
        this.failFromState = fs;
    }

    public boolean getOnephasePrepare() {
        return this.onephasePrepare;
    }

    public int nextState(int pktType, Integer xaFlag) throws BrokerException {
        switch (pktType) {
            case 44: {
                if (!(TransactionState.isFlagSet(0, xaFlag) ? this.state == 0 || this.state == 4 || this.state == 1 : (TransactionState.isFlagSet(0x200000, xaFlag) ? this.state == 1 || this.state == 4 : TransactionState.isFlagSet(0x8000000, xaFlag) && (this.state == 3 || this.state == 1)))) break;
                return 1;
            }
            case 58: {
                if (TransactionState.isFlagSet(0x2000000, xaFlag)) {
                    if (this.state != 1 && this.state != 3) break;
                    return 3;
                }
                if (TransactionState.isFlagSet(0x20000000, xaFlag)) {
                    if (this.state != 1 && this.state != 3 && this.state != 2) break;
                    return 2;
                }
                if (!TransactionState.isFlagSet(0x4000000, xaFlag) && !TransactionState.isFlagSet(0x40000000, xaFlag) || this.state != 1 && this.state != 3 && this.state != 4) break;
                return 4;
            }
            case 56: {
                if (this.state != 4 && this.state != 5) break;
                return 5;
            }
            case 46: {
                if (!(TransactionState.isFlagSet(0x40000000, xaFlag) ? this.state == 4 || this.state == 6 : this.state == 5 || this.state == 6)) break;
                return 6;
            }
            case 48: {
                if (this.state == 4 || this.state == 3) {
                    return 7;
                }
                if (this.state == 5) {
                    return 7;
                }
                if (this.state != 2 && this.state != 7) break;
                return 7;
            }
        }
        if (this.state == 2 && this.failToState != -1) {
            Object[] args = new Object[]{PacketType.getString(pktType), TransactionState.xaFlagToString(xaFlag), this.xid == null ? "null" : this.xid.toString(), TransactionState.toString(this.failToState), TransactionState.toString(this.failFromState)};
            throw new BrokerException(Globals.getBrokerResources().getString("B4291", args));
        }
        if (this.state == 2) {
            Object[] args = new Object[]{PacketType.getString(pktType), TransactionState.xaFlagToString(xaFlag), this.xid == null ? "null" : this.xid.toString(), TransactionState.toString(this.failFromState)};
            int status = 500;
            if (this.failFromState == 1 && pktType == 58) {
                status = 304;
                throw new BrokerException(Globals.getBrokerResources().getKString("B4307", args), status);
            }
            throw new BrokerException(Globals.getBrokerResources().getString("B4292", args), status);
        }
        Object[] args = new Object[]{PacketType.getString(pktType), TransactionState.xaFlagToString(xaFlag), TransactionState.toString(this.state)};
        throw new BrokerException(Globals.getBrokerResources().getString("B4132", args));
    }

    public static int remoteTransactionNextState(TransactionState ts, int nextState) throws BrokerException {
        int currState = ts.getState();
        switch (nextState) {
            case 6: {
                if (currState != 5 && currState != 6) break;
                return 6;
            }
            case 7: {
                if (currState != 5 && currState != 7) break;
                return 7;
            }
        }
        throw new BrokerException("Transaction state " + TransactionState.toString(currState) + " can not transit to state " + TransactionState.toString(nextState));
    }

    public static boolean isFlagSet(int flag, Integer xaFlags) {
        if (xaFlags == null) {
            return flag == 0;
        }
        if (flag == 0 || xaFlags == 0) {
            return flag == xaFlags;
        }
        return (xaFlags & flag) == flag;
    }

    public static String toString(int state) {
        if (state < 0 || state > 7) {
            return "UNKNOWN(" + state + ")";
        }
        return names[state] + "(" + state + ")";
    }

    public static String xaFlagToString(Integer flags) {
        StringBuffer sb = new StringBuffer("");
        boolean found = false;
        if (flags == null) {
            return "null";
        }
        sb.append("0x" + Integer.toHexString(flags) + ":");
        if (TransactionState.isFlagSet(0, flags)) {
            sb.append("TMNOFLAGS");
            return sb.toString();
        }
        if (TransactionState.isFlagSet(0x800000, flags)) {
            sb.append("TMENDRSCAN");
            found = true;
        }
        if (TransactionState.isFlagSet(0x20000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMFAIL");
            found = true;
        }
        if (TransactionState.isFlagSet(0x200000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMJOIN");
            found = true;
        }
        if (TransactionState.isFlagSet(0x40000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMONEPHASE");
            found = true;
        }
        if (TransactionState.isFlagSet(0x8000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMRESUME");
            found = true;
        }
        if (TransactionState.isFlagSet(0x1000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMSTARTSCAN");
            found = true;
        }
        if (TransactionState.isFlagSet(0x4000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMSUCCESS");
            found = true;
        }
        if (TransactionState.isFlagSet(0x2000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMSUSPEND");
            found = true;
        }
        if (!found) {
            sb.append("???");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.xid == null) {
            return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state) + (this.onephasePrepare ? "[onephase=true]" : "");
        }
        return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state) + ":xid=" + this.xid.toString() + (this.onephasePrepare ? "[onephase=true]" : "");
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String id) {
        this.creator = id;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.connectionUID = null;
        this.creator = null;
        this.detached = false;
        this.detachedTime = 0L;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.xid = JMQXid.read(in);
        if (this.xid.isNullXid()) {
            this.xid = null;
        }
        this.state = in.readInt();
        this.user = (String)in.readObject();
        this.clientID = (String)in.readObject();
        this.connectionString = (String)in.readObject();
        this.connectionUID = null;
        this.onephasePrepare = false;
        try {
            if (in.available() > 0) {
                this.sessionLess = in.readBoolean();
                this.type = AutoRollbackType.getType(in.readInt());
                this.createTime = in.readLong();
                this.lifetime = in.readLong();
                this.lastAccessTime = in.readLong();
                this.expireTime = this.createTime + this.lifetime;
            }
            if (in.available() > 0) {
                this.onephasePrepare = in.readBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.detached = false;
        this.detachedTime = 0L;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.xid == null) {
            EMPTY_JMQXID.write(out);
        } else {
            this.xid.write(out);
        }
        out.writeInt(this.state);
        out.writeObject(this.user);
        out.writeObject(this.clientID);
        out.writeObject(this.connectionString);
        out.writeBoolean(this.sessionLess);
        out.writeInt(this.type.intValue());
        out.writeLong(this.createTime);
        out.writeLong(this.lifetime);
        out.writeLong(this.lastAccessTime);
        out.writeBoolean(this.onephasePrepare);
    }
}

