/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.common.handlers.GoodbyeTask;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Hashtable;

public class GoodbyeHandler
extends PacketHandler {
    private static long timeout = Globals.getConfig().getLongProperty("imq.goodbye.timeout", 0L);

    public GoodbyeHandler(ConnectionManager mgr) {
        timeout = Globals.getConfig().getLongProperty("imq.goodbye.timeout", 0L);
        GoodbyeTask.initialize(timeout);
    }

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        boolean destroy;
        block14: {
            block11: {
                Hashtable<String, Object> hash;
                Packet pkt;
                block13: {
                    block12: {
                        boolean notAuthenticated;
                        Hashtable props = null;
                        try {
                            props = msg.getProperties();
                        }
                        catch (Exception ex) {
                            this.logger.logStack(16, "GOODBY Packet.getProperties()", ex);
                            props = new Hashtable();
                        }
                        boolean bl = notAuthenticated = !con.isAuthenticated();
                        if (con.isValid() && notAuthenticated) {
                            this.logger.log(16, Globals.getBrokerResources().getKString("B2207", con.getConnectionUID().longValue() + "[" + con.getRemoteConnectionString() + "]"));
                        }
                        Boolean blockprop = props != null ? (Boolean)props.get("JMQBlock") : null;
                        boolean block = blockprop != null && blockprop != false;
                        con.stopConnection();
                        if (block) {
                            con.cleanupConnection();
                        }
                        destroy = false;
                        if (!msg.getSendAcknowledge()) break block11;
                        pkt = new Packet(con.useDirectBuffers());
                        pkt.setPacketType(29);
                        pkt.setConsumerID(msg.getConsumerID());
                        hash = new Hashtable<String, Object>();
                        hash.put("JMQStatus", 200);
                        IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                        if (IMQBasicConnection.getDumpPacket()) break block12;
                        IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                        if (!IMQBasicConnection.getDumpOutPacket()) break block13;
                    }
                    hash.put("JMQReqID", msg.getSysMessageID().toString());
                }
                pkt.setProperties(hash);
                con.sendControlMessage(pkt);
                if (con.isBlocking()) {
                    if (con instanceof IMQBasicConnection) {
                        IMQBasicConnection ipCon = (IMQBasicConnection)con;
                        ipCon.flushControl(timeout);
                    }
                    destroy = true;
                } else {
                    con.setDestroyReason(Globals.getBrokerResources().getKString("B0059"));
                    GoodbyeTask.addConnection(con.getConnectionUID(), Globals.getBrokerResources().getKString("B0059"));
                }
                break block14;
            }
            destroy = true;
        }
        if (destroy) {
            con.destroyConnection(false, 5, Globals.getBrokerResources().getKString("B0059"));
        }
        return true;
    }
}

