/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.HostAndPort;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_change-master-password-das")
@PerLookup
public class ChangeMasterPasswordCommandDAS
extends LocalDomainCommand {
    @Param(name="domain", primary=true, optional=true)
    protected String domainName0;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    protected boolean savemp;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeMasterPasswordCommandDAS.class);

    @Override
    protected void validate() throws CommandException {
        String dName = this.domainName0 != null ? this.domainName0 : this.getDomainName();
        this.setDomainName(dName);
        super.validate();
    }

    public int execute(String ... argv) throws CommandException {
        return super.execute(argv);
    }

    protected int executeCommand() throws CommandException {
        try {
            String nmp;
            HostAndPort adminAddress = this.getAdminAddress();
            if (this.isRunning(adminAddress.getHost(), adminAddress.getPort())) {
                throw new CommandException(strings.get("domain.is.running", new Object[]{this.getDomainName(), this.getDomainRootDir()}));
            }
            DomainConfig domainConfig = new DomainConfig(this.getDomainName(), this.getDomainsDir().getAbsolutePath());
            PEDomainsManager manager = new PEDomainsManager();
            String mp = super.readFromMasterPasswordFile();
            if (mp == null && (mp = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD")) == null) {
                char[] mpCharArr = super.readPassword(strings.get("current.mp"));
                String string = mp = mpCharArr != null ? new String(mpCharArr) : null;
            }
            if (mp == null) {
                throw new CommandException(strings.get("no.console"));
            }
            if (!super.verifyMasterPassword(mp)) {
                throw new CommandException(strings.get("incorrect.mp"));
            }
            char[] nmpCharArr = this.getPassword("newmasterpassword", strings.get("new.mp"), strings.get("new.mp.again"), true);
            String string = nmp = nmpCharArr != null ? new String(nmpCharArr) : null;
            if (nmp == null) {
                throw new CommandException(strings.get("no.console"));
            }
            if (nmp.trim().length() < 6) {
                throw new CommandException(strings.get("incorrect.password.length"));
            }
            domainConfig.put("domain.masterPassword", mp);
            domainConfig.put("domain.newMasterPassword", nmp);
            domainConfig.put("domain.saveMasterPassword", this.savemp);
            manager.changeMasterPassword(domainConfig);
            return 0;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }
}

