/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.gmf.service;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gendoc.bundle.acceleo.gmf.impl.GMFEditPartUtils;
import org.eclipse.gendoc.bundle.acceleo.gmf.service.IDiagramRenderer;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.diagram.ui.util.DiagramEditorUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Shell;

public class GMFDiagramRenderer
extends CopyToImageUtil
implements IDiagramRenderer {
    private String id;

    public void clear() {
    }

    public String getServiceId() {
        return this.id;
    }

    public void setServiceId(String serviceId) {
        this.id = serviceId;
    }

    @Override
    public List<EditPart> renderDiagram(Diagram diagram, List<EObject> visibleElements, IPath path, IDiagramRenderer.FileFormat extension, NullProgressMonitor monitor) throws CoreException {
        if (visibleElements == null || visibleElements.isEmpty()) {
            return this.copyToImage(diagram, path, this.getImageFileFormat(extension), new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
        }
        return this.copyToImage(diagram, path, visibleElements, this.getImageFileFormat(extension), new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
    }

    public List<EditPart> copyToImage(Diagram diagram, IPath destination, ImageFileFormat format, NullProgressMonitor monitor, PreferencesHint preferencesHint) throws CoreException {
        List partInfo = Collections.EMPTY_LIST;
        DiagramEditor openedDiagramEditor = this.findOpenedDiagramEditor(diagram);
        if (openedDiagramEditor != null) {
            DiagramGenerator generator = this.copyToImage(openedDiagramEditor.getDiagramEditPart(), destination, format, (IProgressMonitor)monitor);
            partInfo = generator.getDiagramPartInfo(openedDiagramEditor.getDiagramEditPart());
        } else {
            Shell shell = new Shell();
            try {
                DiagramEditPart diagramEditPart = this.createDiagramEditPart(diagram, shell, preferencesHint);
                Assert.isNotNull((Object)diagramEditPart);
                DiagramGenerator generator = super.copyToImage(diagramEditPart, destination, format, (IProgressMonitor)monitor);
                partInfo = generator.getDiagramPartInfo(diagramEditPart);
            }
            finally {
                shell.dispose();
            }
        }
        return partInfo;
    }

    private DiagramEditor findOpenedDiagramEditor(Diagram diagram) {
        DiagramEditor result = DiagramEditorUtil.findOpenedDiagramEditorForID((String)ViewUtil.getIdStr((View)diagram));
        if (result != null) {
            IPath iPathDiagEditor = this.getIPath(result.getDiagram());
            IPath iPathDiag = this.getIPath(diagram);
            if (iPathDiagEditor == null || iPathDiag == null || !iPathDiag.equals((Object)iPathDiagEditor)) {
                ((ILogger)GendocServices.getDefault().getService(ILogger.class)).log("Two diagrams in separate files " + iPathDiagEditor + " and " + iPathDiag + " have the same identifier", 2);
                return null;
            }
        }
        return result;
    }

    private IPath getIPath(Diagram diagram) {
        IFile file;
        Resource resource;
        if (diagram != null && (resource = diagram.eResource()) != null && (file = WorkspaceSynchronizer.getUnderlyingFile((Resource)resource)) != null) {
            return file.getFullPath();
        }
        return null;
    }

    public List<EditPart> copyToImage(Diagram diagram, IPath destination, List<EObject> visibleElements, ImageFileFormat format, NullProgressMonitor monitor, PreferencesHint preferencesHint) throws CoreException {
        Shell shell = null;
        try {
            List partInfo = Collections.EMPTY_LIST;
            DiagramEditor openedDiagramEditor = this.findOpenedDiagramEditor(diagram);
            DiagramEditPart diagramEditPart = null;
            if (openedDiagramEditor != null) {
                diagramEditPart = openedDiagramEditor.getDiagramEditPart();
            } else {
                shell = new Shell();
                diagramEditPart = this.createDiagramEditPart(diagram, shell, preferencesHint);
            }
            Assert.isNotNull((Object)diagramEditPart);
            this.copyToImage(diagramEditPart, GMFEditPartUtils.getEditParts(visibleElements, diagramEditPart), destination, format, (IProgressMonitor)monitor);
            List list = partInfo;
            return list;
        }
        finally {
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
        }
    }

    private ImageFileFormat getImageFileFormat(IDiagramRenderer.FileFormat format) {
        return ImageFileFormat.resolveImageFormat((String)format.name());
    }
}

