/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gendoc.preferences.internal.PreferenceGendocTemplate;
import org.eclipse.gendoc.wizard.IGendocTemplate;
import org.eclipse.jface.databinding.dialog.TitleAreaDialogSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GendocTemplateFileDialog
extends TitleAreaDialog {
    private IGendocTemplate input;
    private DataBindingContext bindingCtx = new DataBindingContext();

    public GendocTemplateFileDialog(Shell parentShell) {
        super(parentShell);
    }

    public IGendocTemplate getInput() {
        return this.input;
    }

    public void setInput(IGendocTemplate input) {
        this.input = input;
        this.bindingCtx.updateTargets();
    }

    protected Control createDialogArea(Composite parent) {
        IConfigurationElement[] elements;
        super.setTitle("Configure the GenDoc template.");
        Composite c = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(c, 0);
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label l = new Label(composite, 4);
        l.setText("&Template File URL:");
        l.setLayoutData((Object)new GridData(4, 4, false, false));
        Text file = new Text(composite, 2048);
        file.setLayoutData((Object)new GridData(4, 4, true, false));
        Button browseButton = new Button(composite, 8);
        browseButton.setText("File...");
        browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String res;
                FileDialog dialog = new FileDialog(GendocTemplateFileDialog.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*." + GendocTemplateFileDialog.this.input.getOutPutExtension(), "*.*"});
                dialog.setText(String.format("Select the GenDoc template file (*.%s).", GendocTemplateFileDialog.this.input.getOutPutExtension()));
                URL current = GendocTemplateFileDialog.this.input.getTemplate();
                if (current != null && current.getProtocol().equals("file")) {
                    File f = new File(current.getPath().replace("/", File.separator));
                    dialog.setFileName(f.getName());
                    dialog.setFilterPath(f.getParent());
                }
                if ((res = dialog.open()) != null) {
                    try {
                        ((PreferenceGendocTemplate)GendocTemplateFileDialog.this.input).setTemplate(URIUtil.toURI((String)res).toURL());
                        GendocTemplateFileDialog.this.bindingCtx.updateTargets();
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
        });
        Button browse2Button = new Button(composite, 8);
        browse2Button.setText("Workspace...");
        browse2Button.setLayoutData((Object)new GridData(4, 4, false, false));
        browse2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int res;
                String path;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(GendocTemplateFileDialog.this.getShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                PatternFilter filter = new PatternFilter(){

                    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
                        if (viewer == null) {
                            return elements;
                        }
                        return super.filter(viewer, parent, elements);
                    }
                };
                filter.setPattern("*." + GendocTemplateFileDialog.this.input.getOutPutExtension());
                dialog.addFilter((ViewerFilter)filter);
                dialog.setMessage(String.format("Select the GenDoc template file (*.%s).", GendocTemplateFileDialog.this.input.getOutPutExtension()));
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection == null || selection.length != 1) {
                            return ValidationStatus.error((String)String.format("A template file (*.%s) must be selected", GendocTemplateFileDialog.this.input.getOutPutExtension()));
                        }
                        if (!(selection[0] instanceof IFile)) {
                            return ValidationStatus.error((String)String.format("A template file (*.%s) must be selected", GendocTemplateFileDialog.this.input.getOutPutExtension()));
                        }
                        IFile file = (IFile)selection[0];
                        if (!file.exists()) {
                            return ValidationStatus.error((String)String.format("The selected template file '%s' does not exists", file.getFullPath().toString()));
                        }
                        return Status.OK_STATUS;
                    }
                });
                URL current = GendocTemplateFileDialog.this.input.getTemplate();
                if (current != null && current.getProtocol().equals("platform") && (path = current.getPath()).startsWith("/resource")) {
                    path = path.substring("/resource".length());
                    dialog.setInitialSelection((Object)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path)));
                }
                if ((res = dialog.open()) == 0) {
                    IFile result = (IFile)dialog.getResult()[0];
                    try {
                        ((PreferenceGendocTemplate)GendocTemplateFileDialog.this.input).setTemplate(new URL("platform:/resource/" + URIUtil.toURI((IPath)result.getFullPath().makeRelative())));
                        GendocTemplateFileDialog.this.bindingCtx.updateTargets();
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
        });
        l = new Label(composite, 4);
        l.setText("&Output Format:");
        l.setLayoutData((Object)new GridData(4, 4, false, false));
        ComboViewer outputFormatViewer = new ComboViewer(composite, 2056);
        outputFormatViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        outputFormatViewer.getCombo().setLayoutData((Object)new GridData(4, 4, true, true, 3, 0));
        ArrayList<String> formats = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gendoc.document.parser.factory");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            formats.add(element.getAttribute("extension"));
            ++n2;
        }
        outputFormatViewer.setInput(formats);
        l = new Label(composite, 4);
        l.setText("&Output parameter :");
        l.setLayoutData((Object)new GridData(4, 4, false, false));
        Text outputParameter = new Text(composite, 2048);
        outputParameter.setLayoutData((Object)new GridData(4, 4, true, true, 3, 0));
        l = new Label(composite, 4);
        l.setText("&Model parameter :");
        l.setLayoutData((Object)new GridData(4, 4, false, false));
        Text modelParameter = new Text(composite, 2048);
        modelParameter.setLayoutData((Object)new GridData(4, 4, true, true, 3, 0));
        l = new Label(composite, 4);
        l.setText("&Description:");
        l.setLayoutData((Object)new GridData(4, 4, false, false));
        Text description = new Text(composite, 2626);
        description.setLayoutData((Object)new GridData(4, 4, true, true, 3, 0));
        ((GridData)description.getLayoutData()).minimumHeight = 80;
        IValidator templateValidator = new IValidator(){

            public IStatus validate(Object value) {
                if (value == null) {
                    return ValidationStatus.error((String)"A GenDoc template must specify a template file.");
                }
                URL url = (URL)value;
                if (url.getProtocol().equals("file")) {
                    if (!new File(url.getFile()).exists()) {
                        return ValidationStatus.error((String)"The GenDoc template file does not exists.");
                    }
                } else if (url.getProtocol().equals("platform")) {
                    IResource file;
                    String uri = url.getFile();
                    if (uri.startsWith("/resource")) {
                        uri = uri.substring(9);
                    }
                    if ((file = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(uri))) == null) {
                        return ValidationStatus.error((String)"The GenDoc template file does not exists.");
                    }
                } else {
                    return ValidationStatus.error((String)"The URL schema for the GenDoc template file is not supported.");
                }
                return Status.OK_STATUS;
            }
        };
        this.bindingCtx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)file), PojoProperties.value((String)"template").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, URL.class){

            public Object convert(Object fromObject) {
                if (fromObject == null || "".equals(fromObject)) {
                    return null;
                }
                try {
                    return new URL(fromObject.toString());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }).setAfterConvertValidator(templateValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST).setConverter((IConverter)new Converter(URL.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return "";
                }
                return ((URL)fromObject).toExternalForm();
            }
        }));
        this.bindingCtx.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)outputFormatViewer), PojoProperties.value((String)"outPutExtension").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.bindingCtx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)outputParameter), PojoProperties.value((String)"outputKey").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.bindingCtx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)modelParameter), PojoProperties.value((String)"modelKey").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        IValidator descriptionValidator = new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || "".equals(value)) {
                    return ValidationStatus.warning((String)"GenDoc Template Parameters Set should have a description.");
                }
                return Status.OK_STATUS;
            }
        };
        this.bindingCtx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)description), PojoProperties.value((String)"description").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator(descriptionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        TitleAreaDialogSupport.create((TitleAreaDialog)this, (DataBindingContext)this.bindingCtx);
        this.bindingCtx.updateTargets();
        this.bindingCtx.updateModels();
        return composite;
    }
}

