/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.papyrus.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gendoc.wizard.ISelectionConverter;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;

public class OneFileUMLSelectionConverter
implements ISelectionConverter {
    public boolean matches(Object selectedObject) {
        return this.getFile(selectedObject) != null;
    }

    public IFile getFile(Object selectedObject) {
        IFile selectedFile = null;
        if (selectedObject != null) {
            if (selectedObject instanceof IPapyrusFile) {
                IResource[] iResourceArray = ((IPapyrusFile)selectedObject).getAssociatedResources();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile && this.isUMLFile((IFile)resource)) {
                        selectedFile = (IFile)resource;
                        break;
                    }
                    ++n2;
                }
            } else if (selectedObject instanceof EObject) {
                EObject eobject = (EObject)selectedObject;
                selectedFile = WorkspaceSynchronizer.getFile((Resource)eobject.eResource());
            } else if (selectedObject instanceof IAdaptable) {
                EObject eobject;
                selectedFile = (IFile)((IAdaptable)selectedObject).getAdapter(IFile.class);
                if (selectedFile == null && (eobject = (EObject)((IAdaptable)selectedObject).getAdapter(EObject.class)) != null) {
                    selectedFile = WorkspaceSynchronizer.getFile((Resource)eobject.eResource());
                }
            } else if (selectedObject instanceof IFile) {
                selectedFile = (IFile)selectedObject;
            }
        }
        return selectedFile;
    }

    private boolean isUMLFile(IFile file) {
        return "uml".equals(file.getFileExtension());
    }
}

