/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.odt;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.gendoc.document.parser.documents.AbstractZipDocument;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.eclipse.gendoc.document.parser.documents.odt.ODTNamespaceContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ODTDocument
extends AbstractZipDocument {
    private static final String ODT_TEXT = "text:";
    private static final String ODT_STYLE_H = "h";
    private static final String ODT_STYLE_P = "p";
    private static final String ODT_P_TEXT = "text:p";
    private static final String ODT_H_TEXT = "text:h";
    private static String contentsFileName = "content.xml";
    private static String styles = "styles.xml";
    private static final String ODT_STYLE_ATTRIBUTE = "text:style-name";
    private static final String ODT_STYLE_ATTRIBUTE_PARENT_NAME = "style:parent-style-name";
    private static final String ODT_STYLE_ATTRIBUTE_DISPLAY_NAME = "style:display-name";
    private static final String ODT_STYLE_ATTRIBUTE_NAME_2 = "style:name";
    private static final String ODT_STYLE_HEADER = "style:header";
    private static final String ODT_STYLE_FOOTER = "style:footer";
    private static final String ODT_STYLE_MASTER_STYLE = "office:master-styles";
    private static final String XPATH_STYLE_GENERIC = "//style:style";
    private XMLParser xmlStylesParser = null;

    public ODTDocument(File document) throws IOException {
        this(document, null);
    }

    public ODTDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) throws IOException {
        this(documentFile.toURI().toURL(), configuration);
    }

    public ODTDocument(URL url, Map<Document.CONFIGURATION, Boolean> configuration) {
        super(url, configuration);
    }

    public String getStyle() {
        Node nAttribute;
        String nodeName = this.getXMLParser().getCurrentNode().getNodeName();
        String tagValue = nodeName.substring(nodeName.indexOf(":") + 1, nodeName.length());
        String result = null;
        if ((ODT_STYLE_H.equals(tagValue) || ODT_STYLE_P.equals(tagValue)) && (nAttribute = this.getXMLParser().getCurrentNode().getAttributes().getNamedItem(ODT_STYLE_ATTRIBUTE)) != null) {
            Node n;
            String value = nAttribute.getNodeValue();
            File xmlStyles = this.getUnzipper().getFile(styles);
            if (this.xmlStylesParser == null) {
                this.xmlStylesParser = new XMLParser(xmlStyles);
            }
            if ((n = this.getXMLParser().evaluateXPathExpression(XPATH_STYLE_GENERIC, ODT_STYLE_ATTRIBUTE_NAME_2, value, new ODTNamespaceContext())) != null) {
                NamedNodeMap map = n.getAttributes();
                if (this.exists(map, ODT_STYLE_ATTRIBUTE_DISPLAY_NAME)) {
                    result = n.getAttributes().getNamedItem(ODT_STYLE_ATTRIBUTE_DISPLAY_NAME).getNodeValue();
                } else if (this.exists(map, ODT_STYLE_ATTRIBUTE_PARENT_NAME)) {
                    result = n.getAttributes().getNamedItem(ODT_STYLE_ATTRIBUTE_PARENT_NAME).getNodeValue();
                    String tmp = this.checkStyleInDocumentXML(result);
                    if (tmp != null) {
                        result = tmp;
                    }
                } else {
                    result = null;
                }
            }
            if (n == null || result == null) {
                result = this.checkStyleInDocumentXML(value);
            }
        }
        return result;
    }

    private boolean exists(NamedNodeMap map, String name) {
        boolean result = false;
        int i = 0;
        while (i < map.getLength()) {
            if (name.equals(map.item(i).getNodeName())) {
                return true;
            }
            ++i;
        }
        return result;
    }

    private String checkStyleInDocumentXML(String value) {
        String result = null;
        Node n2 = this.xmlStylesParser.evaluateXPathExpression(XPATH_STYLE_GENERIC, ODT_STYLE_ATTRIBUTE_NAME_2, value, new ODTNamespaceContext());
        if (n2 != null) {
            Node namedItem = n2.getAttributes().getNamedItem(ODT_STYLE_ATTRIBUTE_PARENT_NAME);
            Node nTmp = n2.getAttributes().getNamedItem(ODT_STYLE_ATTRIBUTE_DISPLAY_NAME);
            if (namedItem != null && nTmp == null) {
                String parent = namedItem.getNodeValue();
                if (parent != null) {
                    Node n3 = this.xmlStylesParser.evaluateXPathExpression(XPATH_STYLE_GENERIC, ODT_STYLE_ATTRIBUTE_NAME_2, parent, new ODTNamespaceContext());
                    if (n3 != null) {
                        result = this.getDisplayName(n3);
                    }
                } else {
                    result = this.getName(n2);
                }
            } else if (nTmp != null) {
                result = nTmp.getNodeValue();
            }
        }
        return result;
    }

    private String getName(Node n) {
        String result = null;
        int i = 0;
        while (i < n.getAttributes().getLength()) {
            Node tmp = n.getAttributes().item(i);
            if (ODT_STYLE_ATTRIBUTE_NAME_2.equals(tmp.getNodeName())) {
                result = tmp.getNodeValue();
            }
            ++i;
        }
        return result;
    }

    private String getDisplayName(Node n) {
        String result = null;
        int i = 0;
        while (i < n.getAttributes().getLength()) {
            Node tmp = n.getAttributes().item(i);
            if (ODT_STYLE_ATTRIBUTE_DISPLAY_NAME.equals(tmp.getNodeName())) {
                result = tmp.getNodeValue();
            }
            ++i;
        }
        if (result == null) {
            result = this.getName(n);
        }
        return result;
    }

    @Override
    public String getTextCorrespondingToCurrentStyle() {
        String result = null;
        if (this.getStyle() != null) {
            return this.getText();
        }
        return result;
    }

    public String getText() {
        if ((ODT_P_TEXT.equals(this.getXMLParser().getCurrentNode().getNodeName()) || ODT_H_TEXT.equals(this.getXMLParser().getCurrentNode().getNodeName())) && !XMLHelper.containsInHierarchy(this.getXMLParser().getCurrentNode(), "office:annotation")) {
            switch (this.getXMLParser().getCurrentNode().getNodeType()) {
                case 1: {
                    return this.getXMLParser().getCurrentNode().getTextContent();
                }
                case 3: {
                    return this.getXMLParser().getCurrentNode().getNodeValue();
                }
            }
            return this.getXMLParser().getCurrentNode().getNodeValue();
        }
        return "";
    }

    private void fillCollection(Collection<XMLParser> parsers, String odtStyle, Document.CONFIGURATION idForDocument) {
        XMLParser parser = new XMLParser(this.getUnzipper().getFile(styles));
        boolean result = false;
        do {
            if (!(result = parser.next())) continue;
            Node sibling = XMLHelper.getSibling(parser.getCurrentNode());
            if (!ODT_STYLE_MASTER_STYLE.equals(parser.getCurrentNode().getNodeName())) continue;
            do {
                if (!(result = parser.next()) || !odtStyle.equals(parser.getCurrentNode().getNodeName())) continue;
                XMLParser tmp = new XMLParser(this.getUnzipper().getFile(styles), idForDocument);
                tmp.setCurrentNode(parser.getCurrentNode());
                tmp.setEndNode(XMLHelper.getSibling(parser.getCurrentNode()));
                parsers.add(tmp);
            } while (result && parser.getCurrentNode() != sibling);
        } while (result);
    }

    @Override
    public Collection<XMLParser> getXmlParsers(Document.CONFIGURATION idForDocument) {
        LinkedList<XMLParser> parsers = new LinkedList<XMLParser>();
        switch (idForDocument) {
            case content: {
                XMLParser parser = new XMLParser(this.getUnzipper().getFile(contentsFileName), idForDocument);
                parsers.add(parser);
                break;
            }
            case footer: {
                this.fillCollection(parsers, ODT_STYLE_FOOTER, idForDocument);
                break;
            }
            case header: {
                this.fillCollection(parsers, ODT_STYLE_HEADER, idForDocument);
            }
        }
        return parsers;
    }

    @Override
    public Object get(Document.PROPERTY property) {
        switch (property) {
            case text: {
                return this.getText();
            }
            case style: {
                return this.getStyle();
            }
        }
        return null;
    }
}

