/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.exception;

import org.eclipse.gendoc.services.exception.GenDocException;

public class IncompleteTagException
extends GenDocException {
    private static final long serialVersionUID = -2688330129075336697L;

    public IncompleteTagException(String tagLabel) {
        super("A tag \"" + tagLabel + "\" is incomplete");
    }

    public IncompleteTagException(String tagLabel, String tagId) {
        super("A tag \"" + tagLabel + "\" with id = '" + tagId + "' is incomplete.");
    }

    public IncompleteTagException(String tagLabel, int tagIndex) {
        super("The " + IncompleteTagException.displayTagIndex(tagIndex) + " tag \"" + tagLabel + "\" is incomplete");
    }

    public IncompleteTagException(String tagLabel, int tagIndex, String comment) {
        super("The " + IncompleteTagException.displayTagIndex(tagIndex) + " tag \"" + tagLabel + "\" is incomplete : " + comment);
    }

    public IncompleteTagException(String tagLabel, String tagId, String comment) {
        super("Tag \"" + tagLabel + "\" with id '" + tagId + "' is incomplete : " + comment);
    }

    private static String displayTagIndex(int tagIndex) {
        switch (tagIndex) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
        }
        return String.valueOf(tagIndex) + "th";
    }
}

