/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.tags.parsers.TagParserConfig;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLDocumentService
implements IDocumentService {
    public static String XML_TAG_START = "<";
    public static String XML_TAG_END = ">";
    public static String XML_AUTOCLOSING_TAG_END = "/>";
    private Transformer trans;
    private final TransformerFactory transFactory = TransformerFactory.newInstance();
    private final Pattern pattern = Pattern.compile("<?.*?>");
    private Document document;
    private final Pattern patternTag = Pattern.compile("<[^<>]+>");
    private final Pattern patternTagClose = Pattern.compile("</[^<>]+>");
    private final Pattern patternTagSingle = Pattern.compile("<[^<>]+/>");
    public static final String LINE_FEED = "&#xA;";
    public static final String CARRIAGE_RETURN = "&#xD;";
    public static final String TABULATION = "&#x9;";

    public XMLDocumentService() {
        this.init();
    }

    public XMLDocumentService(Document document) {
        this.init();
        this.document = document;
    }

    private void init() {
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        try {
            this.trans = this.transFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            logger.log(e.getMessageAndLocation(), 4);
        }
    }

    @Override
    public abstract NamespaceContext getNameSpaceContext();

    public abstract String getNamingSpaceURL();

    public void clear() {
    }

    @Override
    public Node asNode(String text) throws InvalidContentException {
        DOMResult outputTarget = null;
        try {
            outputTarget = new DOMResult();
            this.trans.transform(new StreamSource(new StringReader(text)), outputTarget);
        }
        catch (TransformerException e) {
            throw new InvalidContentException(text, (Throwable)e);
        }
        return outputTarget.getNode();
    }

    @Override
    public String asText(Node nodeBegin) throws InvalidContentException {
        StringWriter stringOut = new StringWriter();
        BufferedWriter writer = new BufferedWriter(stringOut);
        String xml = "";
        try {
            try {
                this.trans.transform(new DOMSource(nodeBegin), new StreamResult(writer));
                xml = this.pattern.matcher(stringOut.toString()).replaceFirst("");
                xml = Pattern.compile(" " + this.getNamingSpaceURL()).matcher(xml).replaceAll("");
            }
            catch (TransformerException e) {
                throw new InvalidContentException("Node " + nodeBegin.getLocalName() + " can not be transform", (Throwable)e);
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return xml;
    }

    public abstract String getTextStyle();

    @Override
    public abstract boolean isPara(String var1);

    @Override
    public String addNamingSpaces(String nodes) {
        String firstNodeName = null;
        String newNodes = nodes;
        Matcher m = Pattern.compile("<[^ >]*( |>)").matcher(nodes);
        if (m.find()) {
            firstNodeName = m.group().replaceAll("<| |>", "");
            newNodes = newNodes.replaceAll("<" + firstNodeName + " ", "<" + firstNodeName + " " + this.getNamingSpaceURL() + " ");
            newNodes = newNodes.replaceAll("<" + firstNodeName + ">", "<" + firstNodeName + " " + this.getNamingSpaceURL() + ">");
        }
        String[] stringArray = this.getTextTagLabels();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String textNode = stringArray[n2];
            if (firstNodeName != null && !firstNodeName.equals(textNode)) {
                newNodes = newNodes.replaceAll("<" + textNode + " ", "<" + textNode + " " + this.getNamingSpaceURL() + " ");
                newNodes = newNodes.replaceAll("<" + textNode + ">", "<" + textNode + " " + this.getNamingSpaceURL() + ">");
            }
            ++n2;
        }
        return newNodes;
    }

    @Override
    public String addNamingSpaces(String nodes, String label) {
        String newNodes = nodes;
        newNodes = newNodes.replaceAll("<" + label + " ", "<" + label + " " + this.getNamingSpaceURL() + " ");
        newNodes = newNodes.replaceAll("<" + label + ">", "<" + label + " " + this.getNamingSpaceURL() + ">");
        return newNodes;
    }

    public abstract String[] getTextTagLabels();

    @Override
    public Node injectNode(Node nodeToBeReplaced, String nodeContent) throws InvalidContentException {
        ILogger cfr_ignored_0 = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        nodeContent = this.addNamingSpaces(nodeContent, "document");
        StringBuffer newNodeContentBuf = new StringBuffer();
        newNodeContentBuf.append("<document " + this.getNamingSpaceURL() + ">");
        newNodeContentBuf.append(nodeContent);
        newNodeContentBuf.append("</document>");
        newNodeContentBuf = this.cleanTextTag(newNodeContentBuf.toString());
        DOMResult outputTarget = null;
        try {
            outputTarget = new DOMResult(nodeToBeReplaced);
            this.trans.transform(new StreamSource(new StringReader(newNodeContentBuf.toString())), outputTarget);
        }
        catch (TransformerException e) {
            throw new InvalidContentException("Your text seems to contain special characters. Try using method 'clean' from external bundle 'commons' for the different model elements found", (Throwable)e);
        }
        NodeList nodes = nodeToBeReplaced.getLastChild().getChildNodes();
        ArrayList<Node> inserted = new ArrayList<Node>();
        int i = 0;
        while (i < nodes.getLength()) {
            inserted.add(nodeToBeReplaced.getParentNode().insertBefore(nodes.item(i), nodeToBeReplaced));
        }
        return (Node)inserted.get(inserted.size() - 1);
    }

    @Override
    public abstract IAdditionalResourceService getAdditionalResourceService();

    @Override
    public Node cleanTags(Node currentNode, List<String> tagLabels) throws InvalidContentException {
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        Node firstNode = this.findNodeWithOneTag(currentNode);
        Node next = this.cleanTags(currentNode, tagLabels, firstNode);
        if (currentNode == null || currentNode.getParentNode() == null) {
            logger.log("XMLDocumentService.cleanTags : currentNode has been replaced.", 16);
            currentNode = next;
        }
        while (next != null) {
            Node nextStartNode = this.findNodeWithStartTag(next, currentNode);
            next = this.cleanTags(currentNode, tagLabels, nextStartNode);
            if (currentNode != null && currentNode.getParentNode() != null) continue;
            logger.log("XMLDocumentService.cleanTags : currentNode has been replaced.", 16);
            currentNode = next;
        }
        return currentNode;
    }

    @Override
    public String cleanTagContent(String text, List<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return text;
        }
        ArrayList<Pattern> patternsToClean = new ArrayList<Pattern>(labels.size() * 2);
        ArrayList<Pattern> patternsToMatch = new ArrayList<Pattern>(labels.size() * 2);
        for (String label : labels) {
            patternsToClean.add(Pattern.compile("(&lt;" + label + "[^&;]*&gt;[^&]&lt;/" + label + "[^&;]*&gt;)"));
            patternsToClean.add(Pattern.compile("&lt;" + label + "[^&;]*/&gt;"));
            patternsToMatch.add(Pattern.compile("(&lt;" + label + "[^&;]*&gt;|&lt;/" + label + "[^&;]*&gt;)"));
            patternsToMatch.add(Pattern.compile("&lt;" + label + "[^&;]*/&gt;"));
        }
        String patternToMatch = "";
        for (Pattern p : patternsToMatch) {
            patternToMatch = String.valueOf(patternToMatch) + "(" + p + ")|";
        }
        patternToMatch = patternToMatch.substring(0, patternToMatch.length() - 1);
        Pattern globalTagPattern = Pattern.compile("&lt;[^&;]*&gt;");
        StringBuffer resultBuffer = new StringBuffer();
        Matcher m = globalTagPattern.matcher(text);
        int index = 0;
        while (m.find()) {
            resultBuffer.append(text.substring(index, m.start()));
            String originalText = text.substring(m.start(), m.end());
            String cleanedTag = this.removeXMLTag(originalText);
            if (!cleanedTag.toString().matches(patternToMatch)) {
                cleanedTag = originalText;
            }
            resultBuffer.append(cleanedTag);
            index = m.end();
        }
        resultBuffer.append(text.substring(index));
        String result = this.cleanContent(resultBuffer.toString(), patternsToClean);
        result = this.cleanXMLContent(result);
        return result;
    }

    protected String cleanXMLContent(String content) {
        StringBuffer result = new StringBuffer();
        HashSet<String> invalidQuotes = new HashSet<String>(Arrays.asList(TagParserConfig.INVALID_QUOTES));
        HashSet<Character> invalidDoubleQuotes = new HashSet<Character>();
        char[] cArray = TagParserConfig.INVALID_DOUBLE_QUOTES;
        int n = TagParserConfig.INVALID_DOUBLE_QUOTES.length;
        int n2 = 0;
        while (n2 < n) {
            Character aChar = Character.valueOf(cArray[n2]);
            invalidDoubleQuotes.add(aChar);
            ++n2;
        }
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            if (invalidQuotes.contains(String.valueOf(c))) {
                result.append("'");
            } else if (invalidDoubleQuotes.contains(Character.valueOf(c))) {
                result.append('\"');
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public String cleanContent(String text, List<Pattern> patternsToClean) {
        Pattern p2;
        StringBuffer result = new StringBuffer();
        String patterns = "";
        for (Pattern p2 : patternsToClean) {
            patterns = String.valueOf(patterns) + "(" + p2 + ")|";
        }
        patterns = patterns.substring(0, patterns.length() - 1);
        p2 = Pattern.compile(patterns);
        Matcher m = p2.matcher(text);
        int index = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            result.append(text.substring(index, start));
            result.append(this.removeXMLTag(text.substring(start, end)));
            index = end;
        }
        result.append(text.substring(index));
        return result.toString();
    }

    private String removeXMLTag(String text) {
        StringBuffer result = new StringBuffer();
        Matcher m = this.patternTag.matcher(text);
        int index = 0;
        while (m.find()) {
            result.append(text.substring(index, m.start()));
            index = m.end();
        }
        if (index < text.length()) {
            result.append(text.substring(index));
        }
        return result.toString();
    }

    protected abstract Node cleanTags(Node var1, List<String> var2, Node var3) throws InvalidContentException;

    public boolean containsFullTags(String toCheck, List<String> tagLabels) {
        String quote;
        if (toCheck == null) {
            return false;
        }
        int index = toCheck.lastIndexOf("&gt;");
        if (index > -1 && this.containsOneOf(tagLabels, toCheck.substring(index))) {
            return false;
        }
        ArrayList<String> labelsToFind = new ArrayList<String>();
        boolean result = false;
        for (String tagLabel : tagLabels) {
            if (toCheck.matches(".*&lt;(/|)" + tagLabel + ".*")) {
                labelsToFind.add(tagLabel);
                continue;
            }
            if (!tagLabel.startsWith(toCheck.replace("&lt;", ""))) continue;
            labelsToFind.add(tagLabel);
        }
        if (!labelsToFind.isEmpty()) {
            result = true;
        }
        String invalidQuoteRegex = "(";
        String[] stringArray = TagParserConfig.INVALID_QUOTES;
        int n = TagParserConfig.INVALID_QUOTES.length;
        int n2 = 0;
        while (n2 < n) {
            quote = stringArray[n2];
            invalidQuoteRegex = String.valueOf(invalidQuoteRegex) + "\\" + quote + "|";
            ++n2;
        }
        invalidQuoteRegex = invalidQuoteRegex.substring(0, invalidQuoteRegex.length() - 1);
        invalidQuoteRegex = String.valueOf(invalidQuoteRegex) + ")";
        toCheck = toCheck.replaceAll(invalidQuoteRegex, "'");
        quote = "\\'";
        String limited = toCheck.replaceAll("=" + quote + "[^=" + quote + "]*" + quote, "");
        String unfinishedAttributeValue = "[^=]*=" + quote + "([^" + quote + "]*|([^" + quote + "]*" + quote + "[^" + quote + "]*" + quote + "[^" + quote + "]*)*)";
        for (String tagLabel : labelsToFind) {
            boolean unfinishedAttribute = limited.matches(unfinishedAttributeValue);
            boolean finishedTag = limited.matches(".*&lt;(/|)" + tagLabel + ".*(/|)" + "&gt;" + "[^" + "&gt;" + "]*");
            boolean bl = result = result && !unfinishedAttribute && finishedTag;
        }
        return result;
    }

    protected boolean containsOneOf(List<String> labels, String toCheck) {
        if (toCheck == null) {
            return false;
        }
        if (toCheck.endsWith("&lt;") || toCheck.endsWith("&lt;/")) {
            return true;
        }
        String stringToCheck = toCheck.substring(toCheck.indexOf("&lt;") + "&lt;".length());
        if (stringToCheck.startsWith(String.valueOf("/"))) {
            stringToCheck = stringToCheck.substring(String.valueOf("/").length(), stringToCheck.length() - 1);
        }
        for (String label : labels) {
            if (!label.startsWith(stringToCheck) && !stringToCheck.startsWith(label) && !("/" + label).startsWith(stringToCheck)) continue;
            return true;
        }
        return false;
    }

    public String extractNodeTextValue(Node node) throws InvalidContentException {
        if (node == null) {
            return null;
        }
        String result = null;
        String nodeValue = this.asText(node);
        if (nodeValue.endsWith(XML_AUTOCLOSING_TAG_END)) {
            result = "";
        } else {
            int endOfStartingTag = nodeValue.indexOf(XML_TAG_END);
            int startOfEndingTag = nodeValue.lastIndexOf(XML_TAG_START);
            result = endOfStartingTag == -1 || startOfEndingTag == -1 || endOfStartingTag > startOfEndingTag ? nodeValue : nodeValue.substring(endOfStartingTag + 1, startOfEndingTag);
        }
        return result;
    }

    public Node findNodeWithOneTag(Node currentNode) throws InvalidContentException {
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        Node node = currentNode;
        String currentNodeInternalContent = "";
        String nodeContent = null;
        StringBuffer tagContent = new StringBuffer();
        Node startNode = null;
        if (startNode == null && node != null) {
            currentNodeInternalContent = this.extractNodeTextValue(node = XMLHelper.next((Node)node));
            boolean nullOrContainsStartTag = currentNodeInternalContent == null || currentNodeInternalContent.indexOf("&lt;") != -1 && !currentNodeInternalContent.substring(0, currentNodeInternalContent.indexOf("&lt;")).contains(XML_TAG_START);
            while (node != null && !nullOrContainsStartTag) {
                currentNodeInternalContent = this.extractNodeTextValue(node = XMLHelper.next((Node)node));
                boolean bl = nullOrContainsStartTag = currentNodeInternalContent == null || currentNodeInternalContent.indexOf("&lt;") != -1 && !currentNodeInternalContent.substring(0, currentNodeInternalContent.indexOf("&lt;")).contains(XML_TAG_START);
            }
            if (node == null) {
                return null;
            }
            nodeContent = this.asText(node);
            tagContent.append(nodeContent.substring(0, nodeContent.indexOf("&lt;")));
            tagContent.append(currentNodeInternalContent);
            startNode = node;
            if (3 == startNode.getNodeType()) {
                logger.log("XMLDocumentService.findNodeWithOneTag returned a text node :" + startNode.getNodeValue(), 16);
                startNode = node.getParentNode();
            }
            return startNode;
        }
        return null;
    }

    protected Node findNodeWithStartTag(Node currentNode, Node ancestorNode) {
        Node result;
        String label = currentNode.getNodeName();
        String path = this.getRelativePath(ancestorNode, currentNode);
        if (path == null) {
            return null;
        }
        if (!"".equals(path)) {
            path = String.valueOf(path) + "/";
        }
        if (this.getRelativePath(ancestorNode, result = this.getNodeFromXPath(ancestorNode, path = String.valueOf(path) + "following::" + label + "[contains(.,'" + XML_TAG_START + "')]")) == null) {
            return null;
        }
        if (currentNode.equals(result)) {
            return null;
        }
        return result;
    }

    public NodeList getNextNodes(Node startNode, String nodeLabel) {
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(this.getNameSpaceContext());
            XPathExpression expr = xpath.compile("following::" + nodeLabel);
            Object result = expr.evaluate(startNode, XPathConstants.NODESET);
            if (result != null && result instanceof NodeList) {
                return (NodeList)result;
            }
        }
        catch (XPathExpressionException e) {
            logger.log(e.getStackTrace().toString(), 4);
        }
        return null;
    }

    protected Node getBestAscendantUntil(Node higherAscendant, Node baseNode) {
        Node parent = baseNode.getParentNode();
        if (parent == null) {
            return null;
        }
        if (parent.equals(higherAscendant)) {
            return baseNode;
        }
        return this.getBestAscendantUntil(higherAscendant, parent);
    }

    private String getRelativePath(Node ancestorNode, Node currentNode) {
        if (currentNode == null) {
            return null;
        }
        if (currentNode.equals(ancestorNode)) {
            return "";
        }
        StringBuffer path = new StringBuffer(currentNode.getNodeName());
        Node parent = currentNode.getParentNode();
        Node node = currentNode;
        if (node.getPreviousSibling() != null) {
            int index = 1;
            while (node != null) {
                String label = node.getNodeName();
                if ((node = node.getPreviousSibling()) == null || !label.equals(node.getNodeName())) continue;
                ++index;
            }
            if (index > 0) {
                path.append("[" + index + "]");
            }
        }
        while (parent != null && !parent.equals(ancestorNode)) {
            path.insert(0, "/");
            currentNode = parent;
            parent = currentNode.getParentNode();
            String label = currentNode.getNodeName();
            if (currentNode.getPreviousSibling() != null) {
                int index = 1;
                while (currentNode != null) {
                    if ((currentNode = currentNode.getPreviousSibling()) == null || !label.equals(currentNode.getNodeName())) continue;
                    ++index;
                }
                if (index > 0) {
                    path.insert(0, "[" + index + "]");
                }
            }
            path.insert(0, label);
        }
        if (parent == null) {
            return null;
        }
        return path.toString();
    }

    public NodeList getNodeListFromXPath(Node start, String expression) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(this.getNameSpaceContext());
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(start, XPathConstants.NODESET);
            if (result != null && result instanceof NodeList) {
                return (NodeList)result;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Node getNodeFromXPath(Node start, String expression) {
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(this.getNameSpaceContext());
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(start, XPathConstants.NODE);
            if (result != null && result instanceof Node) {
                return (Node)result;
            }
        }
        catch (XPathExpressionException e) {
            logger.log("Invalid XPath expression : " + expression + "\n" + e.getStackTrace().toString(), 4);
        }
        return null;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public StringBuffer cleanTextTag(String textTag) {
        StringBuffer cleaned = new StringBuffer("");
        int index = 0;
        Stack<String> tagStack = new Stack<String>();
        Matcher m = this.patternTag.matcher(textTag);
        while (m.find()) {
            String matchedTag = textTag.substring(m.start(), m.end());
            String tagName = this.getTagName(matchedTag);
            if (this.isCloseTag(matchedTag)) {
                if (!tagStack.empty() && tagName.equals(tagStack.peek())) {
                    tagStack.pop();
                    cleaned.append(textTag.substring(index, m.end()));
                } else if (!tagStack.empty() && this.areSimilarTags(tagName, (String)tagStack.peek())) {
                    String toAppend = matchedTag.replace(tagName, tagStack.peek());
                    tagStack.pop();
                    cleaned.append(toAppend);
                } else if (tagStack.contains(tagName)) {
                    cleaned.append(textTag.substring(index, m.start()));
                    while (!tagStack.peek().equals(tagName)) {
                        cleaned.append("</" + tagStack.pop() + ">");
                    }
                    tagStack.pop();
                    cleaned.append(matchedTag);
                } else {
                    String similarTag = this.containsSimilarTag(tagStack, tagName);
                    if (similarTag != null) {
                        cleaned.append(textTag.substring(index, m.start()));
                        while (!tagStack.peek().equals(similarTag)) {
                            cleaned.append("</" + tagStack.pop() + ">");
                        }
                        tagStack.pop();
                        cleaned.append(matchedTag.replace(tagName, similarTag));
                    } else {
                        cleaned.append(textTag.substring(index, m.start()));
                    }
                }
            } else if (!this.isSingleTag(matchedTag)) {
                tagStack.push(tagName);
                cleaned.append(textTag.substring(index, m.end()));
            } else {
                cleaned.append(textTag.substring(index, m.end()));
            }
            index = m.end();
        }
        while (!tagStack.empty()) {
            cleaned.append("</" + (String)tagStack.pop() + ">");
        }
        return cleaned;
    }

    protected String getTagName(String tag) {
        int begin = tag.indexOf(60) + 1;
        if ('/' == tag.charAt(begin)) {
            ++begin;
        }
        int end = tag.contains(" ") ? tag.indexOf(32) : tag.indexOf(62);
        return tag.substring(begin, end);
    }

    protected boolean isCloseTag(String matchedTag) {
        return this.patternTagClose.matcher(matchedTag).matches();
    }

    protected boolean isSingleTag(String matchedTag) {
        return this.patternTagSingle.matcher(matchedTag).matches();
    }

    protected Pattern getPatternTag() {
        return this.patternTag;
    }

    protected abstract boolean areSimilarTags(String var1, String var2);

    protected abstract String containsSimilarTag(Stack<String> var1, String var2);

    protected Pattern getPatternTagClose() {
        return this.patternTagClose;
    }

    protected Pattern getPatternTagSingle() {
        return this.patternTagSingle;
    }

    @Override
    public void clean(File f) {
        if (f != null) {
            File[] thefiles = f.listFiles();
            if (thefiles != null) {
                File[] fileArray = thefiles;
                int n = thefiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File f2 = fileArray[n2];
                    if (f2.isDirectory()) {
                        this.clean(f2);
                    } else {
                        f2.deleteOnExit();
                    }
                    ++n2;
                }
            }
            f.deleteOnExit();
        }
    }
}

