/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.palette;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.tool.ToolFilterDescriptionListener;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.palette.PaletteManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription;

public class PaletteToolFilterDescriptionListenersManager
implements Runnable {
    private PaletteManager paletteManager;
    private Diagram diagram;
    private TransactionalEditingDomain domain;
    private Collection<ToolFilterDescriptionListener> listeners;

    PaletteToolFilterDescriptionListenersManager(PaletteManager paletteManager) {
        this.paletteManager = paletteManager;
    }

    public void init(Diagram gmfDiagram) {
        this.removeListeners();
        this.diagram = gmfDiagram;
        this.domain = TransactionUtil.getEditingDomain((EObject)this.diagram);
        this.listeners = new LinkedHashSet<ToolFilterDescriptionListener>();
    }

    public void addListenersForFilters(IInterpreter interpreter, Collection<ToolFilterDescription> filters) {
        if (this.listeners != null && this.domain != null) {
            for (ToolFilterDescription filter : filters) {
                ToolFilterDescriptionListener listener = new ToolFilterDescriptionListener(interpreter, filter, (DRepresentation)((DDiagram)this.diagram.getElement()));
                listener.setUpdateRunnable((Runnable)this);
                this.domain.addResourceSetListener((ResourceSetListener)listener);
                this.listeners.add(listener);
            }
        }
    }

    public void dispose() {
        this.removeListeners();
        this.diagram = null;
        this.domain = null;
    }

    private void removeListeners() {
        if (this.listeners != null & this.domain != null) {
            for (ToolFilterDescriptionListener listener : this.listeners) {
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
            this.listeners = null;
        }
    }

    @Override
    public void run() {
        this.paletteManager.update(this.diagram);
    }
}

