/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.FeatureURLElement;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class URLSection
extends TableSection {
    private TableViewer fUrlViewer;
    private Action fNewAction;
    private Action fDeleteAction;
    private Image fUrlImage;

    public URLSection(PDEFormPage page, Composite parent) {
        super(page, parent, 4224, false, new String[]{PDEUIMessages.FeatureEditor_URLSection_new});
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.fUrlImage = provider.get(PDEPluginImages.DESC_LINK_OBJ);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_URLSection_desc);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        GridLayout layout = (GridLayout)container.getLayout();
        layout.verticalSpacing = 5;
        this.createViewerPartControl(container, 4, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fUrlViewer = tablePart.getTableViewer();
        this.fUrlViewer.setContentProvider((IContentProvider)new URLContentProvider());
        this.fUrlViewer.setLabelProvider((IBaseLabelProvider)new URLLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        this.initialize();
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        IModel model = (IModel)this.getPage().getModel();
        IStructuredSelection selection = this.fUrlViewer.getStructuredSelection();
        Object object = selection.getFirstElement();
        manager.add((IAction)this.fNewAction);
        this.fNewAction.setEnabled(model.isEditable());
        if (object != null && object instanceof IFeatureURLElement) {
            manager.add((IAction)this.fDeleteAction);
            this.fDeleteAction.setEnabled(model.isEditable());
        }
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleNew() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureURL url = feature.getURL();
        if (url == null) {
            url = model.getFactory().createURL();
            try {
                feature.setURL(url);
            }
            catch (CoreException coreException) {
                return;
            }
        }
        try {
            IFeatureURLElement element = model.getFactory().createURLElement(url, 2);
            element.setLabel(PDEUIMessages.FeatureEditor_URLSection_newDiscoverySite);
            element.setURL(new URL(PDEUIMessages.FeatureEditor_URLSection_newURL));
            url.addDiscovery(element);
            this.fUrlViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        catch (MalformedURLException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleDelete() {
        IStructuredSelection ssel = this.fUrlViewer.getStructuredSelection();
        if (ssel.isEmpty()) {
            return;
        }
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        IFeature feature = model.getFeature();
        IFeatureURL url = feature.getURL();
        if (url == null) {
            return;
        }
        for (IFeatureURLElement urlElement : ssel) {
            try {
                url.removeDiscovery(urlElement);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.fUrlViewer.getTable().getDisplay(), () -> this.handleDelete());
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.fUrlViewer.getTable().getDisplay(), () -> this.handleSelectAll());
            return true;
        }
        return false;
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object obj = e.getChangedObjects()[0];
        if (obj instanceof IFeatureURL) {
            this.markStale();
            return;
        }
        if (obj instanceof IFeatureURLElement) {
            this.markStale();
            return;
        }
    }

    private void makeActions() {
        IModel model = (IModel)this.getPage().getModel();
        this.fNewAction = new Action(){

            public void run() {
                URLSection.this.handleNew();
            }
        };
        this.fNewAction.setText(PDEUIMessages.Menus_new_label);
        this.fNewAction.setEnabled(model.isEditable());
        this.fDeleteAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)URLSection.this.fUrlViewer.getTable().getDisplay(), () -> URLSection.this.handleDelete());
            }
        };
        this.fDeleteAction.setText(PDEUIMessages.Actions_delete_label);
        this.fDeleteAction.setEnabled(model.isEditable());
    }

    @Override
    public void setFocus() {
        if (this.fUrlViewer != null) {
            this.fUrlViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.fUrlViewer.setInput((Object)feature);
        super.refresh();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        ModelDataTransfer modelTransfer = ModelDataTransfer.getInstance();
        Object[] objects = (Object[])clipboard.getContents((Transfer)modelTransfer);
        if (objects != null && objects.length > 0) {
            return this.canPaste(null, objects);
        }
        return false;
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof FeatureURLElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void doPaste() {
        ModelDataTransfer modelTransfer;
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(modelTransfer = ModelDataTransfer.getInstance()));
        if (objects != null) {
            this.doPaste(null, objects);
        }
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        IFeature feature = model.getFeature();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof FeatureURLElement) {
                FeatureURLElement element = (FeatureURLElement)object;
                element.setModel(model);
                element.setParent((IFeatureObject)feature);
                try {
                    feature.getURL().addDiscovery((IFeatureURLElement)element);
                }
                catch (CoreException e) {
                    PDECore.logException((Throwable)e);
                }
            }
            ++n2;
        }
    }

    void fireSelection() {
        this.fUrlViewer.setSelection((ISelection)this.fUrlViewer.getStructuredSelection());
    }

    class URLContentProvider
    implements IStructuredContentProvider {
        URLContentProvider() {
        }

        public Object[] getElements(Object input) {
            IFeature feature = (IFeature)input;
            IFeatureURL featureUrl = feature.getURL();
            if (featureUrl != null) {
                return featureUrl.getDiscoveries();
            }
            return new Object[0];
        }
    }

    class URLLabelProvider
    extends LabelProvider {
        URLLabelProvider() {
        }

        public Image getImage(Object obj) {
            if (obj instanceof IFeatureURLElement) {
                return URLSection.this.fUrlImage;
            }
            return null;
        }
    }
}

