/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.internal.values.SequenceValueImpl;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SequenceValue;

public class SparseSequenceValueImpl
extends SequenceValueImpl {
    public static @NonNull List<Object> createSequenceOfEach(@Nullable Object @NonNull [] boxedValues) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            result.add(boxedValue);
            ++n2;
        }
        return result;
    }

    public static @NonNull List<?> createSequenceOfEach(@NonNull Collection<? extends Object> elements) {
        List<Object> list = elements instanceof List ? (List<Object>)elements : new ArrayList<Object>(elements);
        return list;
    }

    public SparseSequenceValueImpl(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> boxedValues) {
        super(typeId, boxedValues);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SparseSequenceValueImpl) {
            return this.elements.equals(((SparseSequenceValueImpl)obj).elements);
        }
        return super.equals(obj);
    }

    public static class Accumulator
    extends SparseSequenceValueImpl
    implements SequenceValue.Accumulator {
        public Accumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new ArrayList());
        }

        public Accumulator(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> values) {
            super(typeId, values);
        }

        @Override
        public boolean add(@Nullable Object value) {
            return this.elements.add(value);
        }

        @Override
        public @NonNull SequenceValue append(@Nullable Object value) {
            assert (!(value instanceof InvalidValueException));
            this.add(value);
            return this;
        }
    }
}

