/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.SpecializedCollectionTypeIdImpl;

public class GeneralizedCollectionTypeIdImpl
extends GeneralizedTypeIdImpl<CollectionTypeId>
implements CollectionTypeId {
    public GeneralizedCollectionTypeIdImpl(@NonNull IdManager idManager, @NonNull String name) {
        super(IdHash.createGlobalHash(CollectionTypeId.class, name), 1, name);
        assert (!"Map".equals(name));
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitCollectionTypeId(this);
    }

    @Override
    protected @NonNull CollectionTypeId createSpecializedId(@NonNull BindingsId templateBindings) {
        return new SpecializedCollectionTypeIdImpl(this, templateBindings);
    }

    @Override
    public @NonNull String getDisplayName() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        s.append(IdManager.getParametersId(CollectionTypeId.T_1));
        return s.toString();
    }

    @Override
    public @NonNull TemplateParameterId getElementTypeId() {
        return TypeId.T_1;
    }

    @Override
    public @NonNull CollectionTypeId getGeneralizedId() {
        return this;
    }

    @Override
    public @Nullable String getLiteralName() {
        if (this == TypeId.BAG) {
            return "BAG";
        }
        if (this == TypeId.COLLECTION) {
            return "COLLECTION";
        }
        if (this == TypeId.ORDERED_SET) {
            return "ORDERED_SET";
        }
        if (this == TypeId.SEQUENCE) {
            return "SEQUENCE";
        }
        if (this == TypeId.SET) {
            return "SET";
        }
        if (this == TypeId.UNIQUE_COLLECTION) {
            return "UNIQUE_COLLECTION";
        }
        return null;
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return String.valueOf(this.name) + "Type";
    }

    @Override
    public @NonNull CollectionTypeId specialize(@NonNull BindingsId templateBindings) {
        return (CollectionTypeId)this.getSpecializedId(templateBindings);
    }
}

