/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.dynamic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExplicitClassLoader
extends ClassLoader {
    protected final @NonNull File explicitClassPath;
    protected final @NonNull List<@NonNull String> qualifiedPackageNames;
    protected final @Nullable ClassLoader fallBackClassLoader;
    private final @NonNull Map<String, Class<?>> hitsAndMisses = new HashMap();

    public ExplicitClassLoader(@NonNull File explicitClassPath, @NonNull String qualifiedPackageName) {
        this(explicitClassPath, qualifiedPackageName, null);
    }

    public ExplicitClassLoader(@NonNull File explicitClassPath, @NonNull String qualifiedPackageName, @Nullable ClassLoader fallBackClassLoader) {
        this(explicitClassPath, Collections.singletonList(qualifiedPackageName), fallBackClassLoader);
    }

    public ExplicitClassLoader(@NonNull File explicitClassPath, @NonNull List<@NonNull String> qualifiedPackageNames, @Nullable ClassLoader fallBackClassLoader) {
        this.explicitClassPath = explicitClassPath;
        this.qualifiedPackageNames = qualifiedPackageNames;
        this.fallBackClassLoader = fallBackClassLoader;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String packageName;
        int index = name.lastIndexOf(".");
        String string = packageName = index >= 0 ? name.substring(0, index) : "";
        if (this.qualifiedPackageNames.contains(packageName)) {
            Class<?> hitOrMiss = this.hitsAndMisses.get(name);
            if (hitOrMiss != null) {
                if (hitOrMiss == ExplicitClassLoader.class) {
                    throw new ClassNotFoundException("Attempted reload of '" + name + "' failed");
                }
                return hitOrMiss;
            }
            try {
                hitOrMiss = this.loadExplicitClass(name, resolve);
                this.hitsAndMisses.put(name, hitOrMiss);
                return hitOrMiss;
            }
            catch (IOException e) {
                this.hitsAndMisses.put(name, ExplicitClassLoader.class);
                throw new ClassNotFoundException(e.getMessage(), e);
            }
        }
        if (this.fallBackClassLoader != null) {
            return this.fallBackClassLoader.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    private @Nullable Class<?> loadExplicitClass(@NonNull String qualifiedClassName, boolean resolve) throws ClassNotFoundException, IOException {
        String filePath = String.valueOf(qualifiedClassName.replaceAll("\\.", "/")) + ".class";
        File classFile = new File(this.explicitClassPath, filePath);
        FileInputStream inputStream = new FileInputStream(classFile);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            int bytes;
            byte[] byteArray = new byte[16384];
            while ((bytes = inputStream.read(byteArray)) >= 0) {
                byteStream.write(byteArray, 0, bytes);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        byte[] classBytes = byteStream.toByteArray();
        Class<?> theClass = this.defineClass(qualifiedClassName, classBytes, 0, classBytes.length);
        if (theClass == null) {
            return null;
        }
        Package thePackage = theClass.getPackage();
        if (thePackage == null) {
            String packageName = qualifiedClassName.replaceAll("\\.\\w+$", "");
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        if (resolve) {
            this.resolveClass(theClass);
        }
        return theClass;
    }
}

