/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.FieldModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.ModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NewObjectModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NonCollectionFieldModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.PotentialCollectionFieldModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.RemovedObjectModelChange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BatchModelChangeListener {
    private final EContentAdapter adapter;
    private final Map<Object, List<Notification>> changes = new HashMap<Object, List<Notification>>();
    private final Set<Object> registeredObservers = new HashSet<Object>();
    private final Set<Resource> observedResources = new HashSet<Resource>();

    public BatchModelChangeListener(Set<Resource> resources) {
        this.adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                for (Object obs : BatchModelChangeListener.this.registeredObservers) {
                    ((List)BatchModelChangeListener.this.changes.get(obs)).add(notification);
                }
            }
        };
        this.observedResources.addAll(resources);
        Consumer<Resource> _function = new Consumer<Resource>(){

            @Override
            public void accept(Resource r) {
                if (r != null) {
                    r.eAdapters().add((Object)BatchModelChangeListener.this.adapter);
                }
            }
        };
        this.observedResources.forEach(_function);
    }

    public List<ModelChange> getChanges(Object addon) {
        ArrayList<ModelChange> result = new ArrayList<ModelChange>();
        List<Notification> allNotifs = this.changes.get(addon);
        boolean _contains = this.registeredObservers.contains(addon);
        if (_contains) {
            ArrayList _arrayList = new ArrayList();
            this.changes.put(addon, _arrayList);
        }
        HashMap sortedNotifications = new HashMap();
        HashMap resourcesNotifications = new HashMap();
        for (Notification notification : allNotifs) {
            boolean _not_2;
            int eventType = notification.getEventType();
            if (eventType >= 10 || notification.isTouch()) continue;
            if (notification.getNotifier() instanceof EObject && notification.getFeature() instanceof EStructuralFeature) {
                Map objectsNotifications;
                boolean _containsKey_1;
                boolean _not_1;
                boolean _not;
                Object _feature = notification.getFeature();
                EStructuralFeature feature = (EStructuralFeature)_feature;
                Object _notifier = notification.getNotifier();
                EObject changedObject = (EObject)_notifier;
                boolean _containsKey = sortedNotifications.containsKey(changedObject);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    HashMap _hashMap = new HashMap();
                    sortedNotifications.put(changedObject, _hashMap);
                }
                boolean bl2 = _not_1 = !(_containsKey_1 = (objectsNotifications = (Map)sortedNotifications.get(changedObject)).containsKey(feature));
                if (_not_1) {
                    ArrayList _arrayList_1 = new ArrayList();
                    objectsNotifications.put(feature, _arrayList_1);
                }
                List fieldNotifications = (List)objectsNotifications.get(feature);
                BatchModelChangeListener.addUnique(fieldNotifications, notification);
                continue;
            }
            Object _notifier_1 = notification.getNotifier();
            if (!(_notifier_1 instanceof Resource)) continue;
            Object _notifier_2 = notification.getNotifier();
            Resource resource = (Resource)_notifier_2;
            boolean _containsKey_2 = resourcesNotifications.containsKey(resource);
            boolean bl = _not_2 = !_containsKey_2;
            if (_not_2) {
                ArrayList _arrayList_2 = new ArrayList();
                resourcesNotifications.put(resource, _arrayList_2);
            }
            List resourceNotifications = (List)resourcesNotifications.get(resource);
            BatchModelChangeListener.addUnique(resourceNotifications, notification);
        }
        final HashSet<EObject> newObjects = new HashSet<EObject>();
        final HashSet<EObject> removedObjects = new HashSet<EObject>();
        final HashSet<EObject> eventuallyRemoved = new HashSet<EObject>();
        Set _keySet = resourcesNotifications.keySet();
        for (Resource resource : _keySet) {
            List resourceNotifications = (List)resourcesNotifications.get(resource);
            for (Notification notif : resourceNotifications) {
                BatchModelChangeListener.manageCollectionContainmentNotification(eventuallyRemoved, removedObjects, newObjects, notif);
            }
        }
        Set _keySet_1 = sortedNotifications.keySet();
        for (EObject object : _keySet_1) {
            Map featureMap = (Map)sortedNotifications.get(object);
            Set _keySet_2 = featureMap.keySet();
            for (EStructuralFeature feature : _keySet_2) {
                boolean _not;
                List notifs = (List)featureMap.get(feature);
                boolean _isMany = feature.isMany();
                boolean bl = _not = !_isMany;
                if (_not) {
                    Object previousValue = ((Notification)IterableExtensions.head((Iterable)notifs)).getOldValue();
                    Object newValue = ((Notification)IterableExtensions.last((Iterable)notifs)).getNewValue();
                    if (feature instanceof EReference) {
                        boolean _notEquals;
                        boolean bl3 = _notEquals = !Objects.equal((Object)previousValue, (Object)newValue);
                        if (!_notEquals) continue;
                        NonCollectionFieldModelChange _nonCollectionFieldModelChange = new NonCollectionFieldModelChange(object, feature);
                        result.add(_nonCollectionFieldModelChange);
                        boolean _isContainment = ((EReference)feature).isContainment();
                        if (!_isContainment) continue;
                        if (previousValue != null && previousValue instanceof EObject) {
                            BatchModelChangeListener.addToRemovedObjects(eventuallyRemoved, removedObjects, newObjects, (EObject)previousValue);
                        }
                        if (newValue == null || !(newValue instanceof EObject)) continue;
                        BatchModelChangeListener.addToNewObjects(eventuallyRemoved, removedObjects, newObjects, (EObject)newValue);
                        continue;
                    }
                    boolean _xifexpression = false;
                    if (previousValue == null) {
                        _xifexpression = newValue != null;
                    } else {
                        boolean _equals = previousValue.equals(newValue);
                        boolean bl4 = _xifexpression = !_equals;
                    }
                    if (!_xifexpression) continue;
                    NonCollectionFieldModelChange _nonCollectionFieldModelChange_1 = new NonCollectionFieldModelChange(object, feature);
                    result.add(_nonCollectionFieldModelChange_1);
                    continue;
                }
                PotentialCollectionFieldModelChange _potentialCollectionFieldModelChange = new PotentialCollectionFieldModelChange(object, feature, notifs);
                result.add(_potentialCollectionFieldModelChange);
                for (Notification notif : notifs) {
                    if (!(feature instanceof EReference) || !((EReference)feature).isContainment()) continue;
                    BatchModelChangeListener.manageCollectionContainmentNotification(eventuallyRemoved, removedObjects, newObjects, notif);
                }
            }
        }
        for (EObject newObject : newObjects) {
            NewObjectModelChange _newObjectModelChange = new NewObjectModelChange(newObject);
            result.add(0, _newObjectModelChange);
        }
        for (EObject removedObject : removedObjects) {
            RemovedObjectModelChange _removedObjectModelChange = new RemovedObjectModelChange(removedObject);
            result.add(0, _removedObjectModelChange);
        }
        Predicate<ModelChange> _function = new Predicate<ModelChange>(){

            @Override
            public boolean test(ModelChange c) {
                return c instanceof FieldModelChange && (newObjects.contains(c.getChangedObject()) || removedObjects.contains(c.getChangedObject()) || eventuallyRemoved.contains(c.getChangedObject()));
            }
        };
        result.removeIf(_function);
        return result;
    }

    public boolean registerObserver(Object observer) {
        boolean res = this.registeredObservers.add(observer);
        if (res) {
            ArrayList _arrayList = new ArrayList();
            this.changes.put(observer, _arrayList);
        }
        return res;
    }

    public void removeObserver(Object observer) {
        this.changes.remove(observer);
        this.registeredObservers.remove(observer);
    }

    private static void addToNewObjects(Collection<EObject> eventuallyRemoved, Collection<EObject> removedObjects, Collection<EObject> newObjects, EObject object) {
        boolean hasMoved;
        eventuallyRemoved.remove(object);
        if (object != null && !(hasMoved = removedObjects.remove(object))) {
            newObjects.add(object);
        }
    }

    private static void addToRemovedObjects(Collection<EObject> eventuallyRemoved, Collection<EObject> removedObjects, Collection<EObject> newObjects, EObject object) {
        boolean hasMoved;
        eventuallyRemoved.add(object);
        if (object != null && !(hasMoved = newObjects.remove(object))) {
            removedObjects.add(object);
        }
    }

    private static void manageCollectionContainmentNotification(Collection<EObject> eventuallyRemoved, Collection<EObject> removedObjects, Collection<EObject> newObjects, Notification notif) {
        int _eventType = notif.getEventType();
        switch (_eventType) {
            case 3: {
                Object _newValue = notif.getNewValue();
                BatchModelChangeListener.addToNewObjects(eventuallyRemoved, removedObjects, newObjects, (EObject)_newValue);
                break;
            }
            case 5: {
                Object _newValue_1 = notif.getNewValue();
                for (EObject add : (List)_newValue_1) {
                    BatchModelChangeListener.addToNewObjects(eventuallyRemoved, removedObjects, newObjects, add);
                }
                break;
            }
            case 4: {
                Object _oldValue = notif.getOldValue();
                BatchModelChangeListener.addToRemovedObjects(eventuallyRemoved, removedObjects, newObjects, (EObject)_oldValue);
                break;
            }
            case 6: {
                Object _oldValue_1 = notif.getOldValue();
                for (EObject remove : (List)_oldValue_1) {
                    BatchModelChangeListener.addToNewObjects(eventuallyRemoved, removedObjects, newObjects, remove);
                }
                break;
            }
        }
    }

    public void cleanUp() {
        Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

            public Boolean apply(Resource r) {
                return r != null;
            }
        };
        Iterable _filter = IterableExtensions.filter(this.observedResources, (Functions.Function1)_function);
        for (Resource r : _filter) {
            r.eAdapters().remove((Object)this.adapter);
        }
    }

    private static <T> boolean addUnique(List<T> list, T o) {
        boolean _not;
        boolean _xifexpression = false;
        boolean _contains = list.contains(o);
        boolean bl = _not = !_contains;
        if (_not) {
            _xifexpression = list.add(o);
        }
        return _xifexpression;
    }
}

