/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.opsemanticsview.gen.k3;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.OpsemanticsviewFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.opsemanticsview.gen.OperationalSemanticsViewGenerator;
import org.eclipse.gemoc.opsemanticsview.gen.k3.K3DynamicElementsFinder;
import org.eclipse.gemoc.opsemanticsview.gen.k3.K3StepExtractor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class K3OperationalSemanticsViewGenerator implements OperationalSemanticsViewGenerator {
  @Override
  public OperationalSemanticsView generate(final Dsl language, final IProject melangeProject) {
    final Set<IType> aspectClasses = K3OperationalSemanticsViewGenerator.findAspects(language, melangeProject);
    final OperationalSemanticsView result = OpsemanticsviewFactory.eINSTANCE.createOperationalSemanticsView();
    final String selectedLanguage = language.getName();
    final Function1<Entry, Boolean> _function = new Function1<Entry, Boolean>() {
      @Override
      public Boolean apply(final Entry entry) {
        String _key = entry.getKey();
        return Boolean.valueOf(Objects.equal(_key, "ecore"));
      }
    };
    final Function1<Entry, String> _function_1 = new Function1<Entry, String>() {
      @Override
      public String apply(final Entry entry) {
        return IterableExtensions.<String>head(((Iterable<String>)Conversions.doWrapArray(entry.getValue().split(","))));
      }
    };
    final String ecoreUri = IterableExtensions.<String>head(IterableExtensions.<Entry, String>map(IterableExtensions.<Entry>filter(language.getEntries(), _function), _function_1));
    final ResourceSetImpl rs = new ResourceSetImpl();
    final Resource executionMetamodelResource = rs.getResource(URI.createURI(ecoreUri), true);
    final EPackage executionMetamodel = IterableExtensions.<EPackage>head(Iterables.<EPackage>filter(executionMetamodelResource.getContents(), EPackage.class));
    final Object abstractSyntax = null;
    final K3DynamicElementsFinder dynFinder = new K3DynamicElementsFinder(((EPackage)abstractSyntax), executionMetamodel, result);
    dynFinder.find();
    final K3StepExtractor eventsgen = new K3StepExtractor(aspectClasses, selectedLanguage, executionMetamodel, result);
    eventsgen.generate();
    result.setAbstractSyntax(((EPackage)abstractSyntax));
    result.setExecutionMetamodel(executionMetamodel);
    return result;
  }
  
  private static Set<IType> findAspects(final Dsl language, final IProject melangeProject) {
    final Function1<Entry, Boolean> _function = new Function1<Entry, Boolean>() {
      @Override
      public Boolean apply(final Entry entry) {
        String _key = entry.getKey();
        return Boolean.valueOf(Objects.equal(_key, "k3"));
      }
    };
    final Entry semantics = IterableExtensions.<Entry>head(IterableExtensions.<Entry>filter(language.getEntries(), _function));
    if ((semantics != null)) {
      final Function1<String, String> _function_1 = new Function1<String, String>() {
        @Override
        public String apply(final String asp) {
          return asp.trim();
        }
      };
      final List<String> aspectNames = ListExtensions.<String, String>map(((List<String>)Conversions.doWrapArray(semantics.getValue().split(","))), _function_1);
      final IJavaProject javaProject = JavaCore.create(melangeProject);
      final Function1<String, IType> _function_2 = new Function1<String, IType>() {
        @Override
        public IType apply(final String it) {
          try {
            return javaProject.findType(it);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      };
      final Set<IType> aspectClasses = IterableExtensions.<IType>toSet(ListExtensions.<String, IType>map(aspectNames, _function_2));
      return aspectClasses;
    }
    return CollectionLiterals.<IType>newHashSet();
  }
  
  @Override
  public boolean canHandle(final Dsl language, final IProject melangeProject) {
    final Function1<Entry, Boolean> _function = new Function1<Entry, Boolean>() {
      @Override
      public Boolean apply(final Entry entry) {
        String _key = entry.getKey();
        return Boolean.valueOf(Objects.equal(_key, "k3"));
      }
    };
    final Entry semantics = IterableExtensions.<Entry>head(IterableExtensions.<Entry>filter(language.getEntries(), _function));
    return ((semantics != null) && (!semantics.getValue().isEmpty()));
  }
}
