/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.gexpressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GNegationOperator implements Enumerator
{
    NEGATION(0, "NEGATION", "not"),
    MINUS(1, "MINUS", "~");

    public static final int NEGATION_VALUE = 0;
    public static final int MINUS_VALUE = 1;
    private static final GNegationOperator[] VALUES_ARRAY;
    public static final List<GNegationOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GNegationOperator[]{NEGATION, MINUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GNegationOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GNegationOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GNegationOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GNegationOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GNegationOperator get(int value) {
        switch (value) {
            case 0: {
                return NEGATION;
            }
            case 1: {
                return MINUS;
            }
        }
        return null;
    }

    private GNegationOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

