/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaengine.ui.launcher.tabs;

import fr.inria.diverse.k3.al.annotationprocessor.InitializeModel;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.commons.eclipse.emf.URIHelper;
import org.eclipse.gemoc.commons.eclipse.ui.dialogs.SelectAnyIFileDialog;
import org.eclipse.gemoc.execution.sequential.javaengine.K3RunConfiguration;
import org.eclipse.gemoc.execution.sequential.javaengine.PlainK3ExecutionEngine;
import org.eclipse.gemoc.execution.sequential.javaengine.ui.Activator;
import org.eclipse.gemoc.execution.sequential.javaengine.ui.launcher.LauncherMessages;
import org.eclipse.gemoc.execution.sequential.javaengine.ui.launcher.tabs.LaunchConfigurationTab;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.executionframework.engine.commons.K3DslHelper;
import org.eclipse.gemoc.executionframework.engine.commons.MelangeHelper;
import org.eclipse.gemoc.executionframework.ui.utils.ENamedElementQualifiedNameLabelProvider;
import org.eclipse.gemoc.xdsmlframework.ui.utils.dialogs.SelectAIRDIFileDialog;
import org.eclipse.gemoc.xdsmlframework.ui.utils.dialogs.SelectAnyEObjectDialog;
import org.eclipse.gemoc.xdsmlframework.ui.utils.dialogs.SelectMainMethodDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.osgi.framework.Bundle;

public class LaunchConfigurationMainTab
extends LaunchConfigurationTab {
    protected Composite _parent;
    protected Text _modelLocationText;
    protected Text _modelInitializationMethodText;
    protected Text _modelInitializationArgumentsText;
    protected Text _siriusRepresentationLocationText;
    protected Button _animateButton;
    protected Text _delayText;
    protected Text _melangeQueryText;
    protected Button _animationFirstBreak;
    protected Group _k3Area;
    protected Text _entryPointModelElementText;
    protected Label _entryPointModelElementLabel;
    protected Text _entryPointMethodText;
    protected Combo _languageCombo;
    protected Text modelofexecutionglml_LocationText;
    public int gridDefaultWidth = 200;
    protected IProject _modelProject;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    private Resource currentModelResource;

    public void createControl(Composite parent) {
        this._parent = parent;
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        area.setLayout((Layout)gl);
        area.layout();
        this.setControl((Control)area);
        Group modelArea = this.createGroup(area, "Model:");
        this.createModelLayout((Composite)modelArea, null);
        Group languageArea = this.createGroup(area, "Language:");
        this.createLanguageLayout((Composite)languageArea, null);
        Group debugArea = this.createGroup(area, "Animation:");
        this.createAnimationLayout((Composite)debugArea, null);
        this._k3Area = this.createGroup(area, "Sequential DSA execution:");
        this.createK3Layout((Composite)this._k3Area, null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("GEMOC_ANIMATE_DELAY", 1000);
        configuration.setAttribute("LAUNCH_MODEL_ENTRY_POINT", "");
        configuration.setAttribute("LAUNCH_METHOD_ENTRY_POINT", "");
        configuration.setAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            K3RunConfiguration runConfiguration = new K3RunConfiguration(configuration);
            this._modelLocationText.setText(URIHelper.removePlatformScheme((URI)runConfiguration.getExecutedModelURI()));
            if (runConfiguration.getAnimatorURI() != null) {
                this._siriusRepresentationLocationText.setText(URIHelper.removePlatformScheme((URI)runConfiguration.getAnimatorURI()));
            } else {
                this._siriusRepresentationLocationText.setText("");
            }
            this._delayText.setText(Integer.toString(runConfiguration.getAnimationDelay()));
            this._animationFirstBreak.setSelection(runConfiguration.getBreakStart());
            this._entryPointModelElementText.setText(runConfiguration.getModelEntryPoint());
            this._entryPointMethodText.setText(runConfiguration.getExecutionEntryPoint());
            this._languageCombo.setText(runConfiguration.getLanguageName());
            this._modelInitializationArgumentsText.setText(runConfiguration.getModelInitializationArguments());
            this._entryPointModelElementLabel.setText("");
            this.updateMainElementName();
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Resource", this._modelLocationText.getText());
        configuration.setAttribute("airdResource", this._siriusRepresentationLocationText.getText());
        configuration.setAttribute("GEMOC_ANIMATE_DELAY", Integer.parseInt(this._delayText.getText()));
        configuration.setAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", this._languageCombo.getText());
        configuration.setAttribute("GEMOC_LAUNCH_MELANGE_QUERY", this._melangeQueryText.getText());
        configuration.setAttribute("LAUNCH_MODEL_ENTRY_POINT", this._entryPointModelElementText.getText());
        configuration.setAttribute("LAUNCH_METHOD_ENTRY_POINT", this._entryPointMethodText.getText());
        configuration.setAttribute("GEMOC_LAUNCH_INITIALIZATION_METHOD", this._modelInitializationMethodText.getText());
        configuration.setAttribute("GEMOC_LAUNCH_INITIALIZATION_ARGUMENTS", this._modelInitializationArgumentsText.getText());
        configuration.setAttribute("GEMOC_LAUNCH_BREAK_START", this._animationFirstBreak.getSelection());
        configuration.setAttribute("GEMOC_DEBUG_MODEL_ID", "org.eclipse.gemoc.execution.sequential.javaengine.ui.debugModel");
    }

    public String getName() {
        return "Main";
    }

    public Composite createModelLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Model to execute");
        this._modelLocationText = new Text(parent, 2052);
        this._modelLocationText.setLayoutData((Object)this.createStandardLayout());
        this._modelLocationText.setFont(font);
        this._modelLocationText.addModifyListener(this.fBasicModifyListener);
        Button modelLocationButton = this.createPushButton(parent, "Browse", null);
        modelLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectAnyIFileDialog dialog = new SelectAnyIFileDialog();
                if (dialog.open() == 0) {
                    String modelPath = ((IResource)dialog.getResult()[0]).getFullPath().toPortableString();
                    LaunchConfigurationMainTab.this._modelLocationText.setText(modelPath);
                    LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
                    LaunchConfigurationMainTab.this._modelProject = ((IResource)dialog.getResult()[0]).getProject();
                }
            }
        });
        this.createTextLabelLayout(parent, "Model initialization method");
        this._modelInitializationMethodText = new Text(parent, 2052);
        this._modelInitializationMethodText.setLayoutData((Object)this.createStandardLayout());
        this._modelInitializationMethodText.setFont(font);
        this._modelInitializationMethodText.setEditable(false);
        this.createTextLabelLayout(parent, "");
        this.createTextLabelLayout(parent, "Model initialization arguments");
        this._modelInitializationArgumentsText = new Text(parent, 2626);
        this._modelInitializationArgumentsText.setToolTipText("one argument per line");
        GridData gridData = new GridData(1808);
        gridData.heightHint = 40;
        this._modelInitializationArgumentsText.setLayoutData((Object)gridData);
        this._modelInitializationArgumentsText.setFont(font);
        this._modelInitializationArgumentsText.setEditable(true);
        this._modelInitializationArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "");
        return parent;
    }

    private Composite createAnimationLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Animator");
        this._siriusRepresentationLocationText = new Text(parent, 2052);
        this._siriusRepresentationLocationText.setLayoutData((Object)this.createStandardLayout());
        this._siriusRepresentationLocationText.setFont(font);
        this._siriusRepresentationLocationText.addModifyListener(this.fBasicModifyListener);
        Button siriusRepresentationLocationButton = this.createPushButton(parent, "Browse", null);
        siriusRepresentationLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectAIRDIFileDialog dialog = new SelectAIRDIFileDialog();
                if (dialog.open() == 0) {
                    String modelPath = ((IResource)dialog.getResult()[0]).getFullPath().toPortableString();
                    LaunchConfigurationMainTab.this._siriusRepresentationLocationText.setText(modelPath);
                    LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.createTextLabelLayout(parent, "Delay");
        this._delayText = new Text(parent, 2052);
        this._delayText.setLayoutData((Object)this.createStandardLayout());
        this._delayText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "(in milliseconds)");
        new Label(parent, 0).setText("");
        this._animationFirstBreak = new Button(parent, 32);
        this._animationFirstBreak.setText("Break at start");
        this._animationFirstBreak.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        return parent;
    }

    private GridData createStandardLayout() {
        return new GridData(4, 0x1000000, true, false);
    }

    public Composite createLanguageLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Languages");
        this._languageCombo = new Combo(parent, 0);
        this._languageCombo.setLayoutData((Object)this.createStandardLayout());
        List languagesNames = DslHelper.getAllLanguages();
        String[] empty = new String[]{};
        this._languageCombo.setItems(languagesNames.toArray(empty));
        this._languageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "");
        this.createTextLabelLayout(parent, "Melange resource adapter query");
        this._melangeQueryText = new Text(parent, 2052);
        this._melangeQueryText.setLayoutData((Object)this.createStandardLayout());
        this._melangeQueryText.setFont(font);
        this._melangeQueryText.setEditable(false);
        this.createTextLabelLayout(parent, "");
        return parent;
    }

    private Composite createK3Layout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Main method");
        this._entryPointMethodText = new Text(parent, 2052);
        this._entryPointMethodText.setLayoutData((Object)this.createStandardLayout());
        this._entryPointMethodText.setFont(font);
        this._entryPointMethodText.setEditable(false);
        this._entryPointMethodText.addModifyListener(this.fBasicModifyListener);
        Button mainMethodBrowseButton = this.createPushButton(parent, "Browse", null);
        mainMethodBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LaunchConfigurationMainTab.this._languageCombo.getText() == null) {
                    LaunchConfigurationMainTab.this.setErrorMessage("Please select a language.");
                } else {
                    Set candidateAspects = K3DslHelper.getAspects((String)LaunchConfigurationMainTab.this._languageCombo.getText());
                    SelectMainMethodDialog dialog = new SelectMainMethodDialog(candidateAspects, (ILabelProvider)new ENamedElementQualifiedNameLabelProvider());
                    int res = dialog.open();
                    if (res == 0) {
                        Method selection = (Method)dialog.getFirstResult();
                        LaunchConfigurationMainTab.this._entryPointMethodText.setText(selection.toString());
                    }
                }
            }
        });
        this.createTextLabelLayout(parent, "Main model element path");
        this._entryPointModelElementText = new Text(parent, 2052);
        this._entryPointModelElementText.setLayoutData((Object)this.createStandardLayout());
        this._entryPointModelElementText.setFont(font);
        this._entryPointModelElementText.setEditable(false);
        this._entryPointModelElementText.addModifyListener(event -> this.updateMainElementName());
        this._entryPointModelElementText.addModifyListener(this.fBasicModifyListener);
        Button mainModelElemBrowseButton = this.createPushButton(parent, "Browse", null);
        mainModelElemBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Resource model = LaunchConfigurationMainTab.this.getModel();
                if (model == null) {
                    LaunchConfigurationMainTab.this.setErrorMessage("Please select a model to execute.");
                } else if (LaunchConfigurationMainTab.this._entryPointMethodText.getText() == null || LaunchConfigurationMainTab.this._entryPointMethodText.getText().equals("")) {
                    LaunchConfigurationMainTab.this.setErrorMessage("Please select a main method.");
                } else {
                    SelectAnyEObjectDialog dialog = new SelectAnyEObjectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), model.getResourceSet(), (ILabelProvider)new ENamedElementQualifiedNameLabelProvider()){

                        protected boolean select(EObject obj) {
                            String methodSignature = (this).LaunchConfigurationMainTab.this._entryPointMethodText.getText();
                            String firstParamType = K3DslHelper.getParametersTypeFromMethodSignature((String)methodSignature)[0];
                            String simpleParamType = DslHelper.lastSegment((String)firstParamType);
                            return obj.eClass().getName().equals(simpleParamType);
                        }
                    };
                    int res = dialog.open();
                    if (res == 0) {
                        EObject selection = (EObject)dialog.getFirstResult();
                        String uriFragment = selection.eResource().getURIFragment(selection);
                        LaunchConfigurationMainTab.this._entryPointModelElementText.setText(uriFragment);
                    }
                }
            }
        });
        this.createTextLabelLayout(parent, "Main model element name");
        this._entryPointModelElementLabel = new Label(parent, 256);
        this._entryPointModelElementLabel.setText("");
        return parent;
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this._k3Area.setVisible(true);
        this._modelInitializationMethodText.setText(this.getModelInitializationMethodName());
        this._modelInitializationArgumentsText.setEnabled(!this._modelInitializationMethodText.getText().isEmpty());
        this._melangeQueryText.setText(this.computeMelangeQuery());
    }

    protected String computeMelangeQuery() {
        Resource model;
        List modelNativeLanguages;
        String result = "";
        String languageName = this._languageCombo.getText();
        if (!(this._modelLocationText.getText().isEmpty() || languageName.isEmpty() || (modelNativeLanguages = MelangeHelper.getNativeLanguagesUsedByResource((Resource)(model = this.getModel()))).isEmpty() || ((String)modelNativeLanguages.get(0)).equals(languageName))) {
            String languageMT = MelangeHelper.getModelType((String)languageName);
            if (languageMT == null) {
                languageMT = String.valueOf(languageName) + "MT";
            }
            result = "?lang=" + languageName;
        }
        return result;
    }

    protected String getModelInitializationMethodName() {
        String entryPointClassName = null;
        int startName = "public static void ".length();
        int endName = this._entryPointMethodText.getText().lastIndexOf("(");
        if (endName == -1) {
            return "";
        }
        String entryMethod = this._entryPointMethodText.getText().substring(startName, endName);
        int lastDot = entryMethod.lastIndexOf(".");
        if (lastDot != -1) {
            entryPointClassName = entryMethod.substring(0, lastDot);
        }
        Bundle bundle = DslHelper.getDslBundle((String)this._languageCombo.getText());
        if (entryPointClassName != null && bundle != null) {
            try {
                Class entryPointClass = bundle.loadClass(entryPointClassName);
                Method[] methodArray = entryPointClass.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.isAnnotationPresent(InitializeModel.class)) {
                        return String.valueOf(entryPointClassName) + "." + m.getName();
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return "";
    }

    private Resource getModel() {
        URI modelURI = URI.createPlatformResourceURI((String)this._modelLocationText.getText(), (boolean)true);
        if (this.currentModelResource == null || !this.currentModelResource.getURI().equals(modelURI)) {
            this.currentModelResource = PlainK3ExecutionEngine.loadModel((URI)modelURI);
        }
        return this.currentModelResource;
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String modelName = this._modelLocationText.getText().trim();
        if (modelName.length() > 0) {
            IResource modelIResource = workspace.getRoot().findMember(modelName);
            if (modelIResource == null || !modelIResource.exists()) {
                this.setErrorMessage(NLS.bind((String)LauncherMessages.SequentialMainTab_model_doesnt_exist, (Object[])new String[]{modelName}));
                return false;
            }
            if (modelName.equals("/")) {
                this.setErrorMessage(LauncherMessages.SequentialMainTab_Model_not_specified);
                return false;
            }
            if (!(modelIResource instanceof IFile)) {
                this.setErrorMessage(NLS.bind((String)LauncherMessages.SequentialMainTab_invalid_model_file, (Object[])new String[]{modelName}));
                return false;
            }
        }
        if (modelName.length() == 0) {
            this.setErrorMessage(LauncherMessages.SequentialMainTab_Model_not_specified);
            return false;
        }
        String languageName = this._languageCombo.getText().trim();
        if (languageName.length() == 0) {
            this.setErrorMessage(LauncherMessages.SequentialMainTab_Language_not_specified);
            return false;
        }
        if (K3DslHelper.getEntryPoints((String)languageName).isEmpty()) {
            this.setErrorMessage(LauncherMessages.SequentialMainTab_Language_main_methods_dont_exist);
            return false;
        }
        String mainMethod = this._entryPointMethodText.getText().trim();
        if (mainMethod.length() == 0) {
            this.setErrorMessage(LauncherMessages.SequentialMainTab_Language_main_method_not_selected);
            return false;
        }
        String rootElement = this._entryPointModelElementText.getText().trim();
        if (rootElement.length() == 0) {
            this.setErrorMessage(LauncherMessages.SequentialMainTab_Language_root_element_not_selected);
            return false;
        }
        String[] params = K3DslHelper.getParametersTypeFromMethodSignature((String)mainMethod);
        String firstParam = DslHelper.lastSegment((String)params[0]);
        String rootEClass = this.getModel().getEObject(rootElement).eClass().getName();
        if (params.length != 1 || !firstParam.equals(rootEClass)) {
            this.setErrorMessage(LauncherMessages.SequentialMainTab_Language_incompatible_root_and_main);
            return false;
        }
        return true;
    }

    private void updateMainElementName() {
        try {
            Resource model = this.getModel();
            EObject mainElement = null;
            if (model != null) {
                mainElement = model.getEObject(this._entryPointModelElementText.getText());
            }
            if (mainElement != null) {
                DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
                QualifiedName qname = nameprovider.getFullyQualifiedName(mainElement);
                String objectName = qname != null ? qname.toString() : mainElement.toString();
                String prettyName = String.valueOf(objectName) + " : " + mainElement.eClass().getName();
                this._entryPointModelElementLabel.setText(prettyName);
            }
        }
        catch (Exception exception) {}
    }
}

