/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.AbstractCollectionType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.EvalEnvironment;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExpressionStatement;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.While;
import org.eclipse.emf.ecoretools.ale.implementation.util.ImplementationSwitch;

public class BaseValidator
extends ImplementationSwitch<Object> {
    List<IValidationMessage> msgs;
    List<ParseResult<ModelUnit>> allModels;
    ParseResult<ModelUnit> currentModel;
    Stack<Map<String, Set<IType>>> variableTypesStack;
    Map<Expression, IValidationResult> validations;
    Map<Expression, Map<String, Set<IType>>> validationContexts;
    Map<Block, Map<String, Set<IType>>> blockContexts;
    AstValidator expValidator;
    IQueryEnvironment qryEnv;
    List<IValidator> validators;

    public BaseValidator(IQueryEnvironment qryEnv, List<IValidator> validators) {
        this.qryEnv = qryEnv;
        this.expValidator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)qryEnv));
        this.validators = new ArrayList<IValidator>();
        validators.forEach(validator -> {
            this.validators.add((IValidator)validator);
            validator.setBase(this);
        });
    }

    public List<IValidationMessage> validate(List<ParseResult<ModelUnit>> roots) {
        this.msgs = new ArrayList<IValidationMessage>();
        this.validations = new HashMap<Expression, IValidationResult>();
        this.validationContexts = new HashMap<Expression, Map<String, Set<IType>>>();
        this.blockContexts = new HashMap<Block, Map<String, Set<IType>>>();
        this.allModels = roots;
        List<ModelUnit> allUnits = roots.stream().map(p -> (ModelUnit)p.getRoot()).filter(u -> u != null).collect(Collectors.toList());
        new EvalEnvironment(this.qryEnv, allUnits, null, null);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateModelBehavior(allUnits));
        });
        roots.forEach(root -> {
            this.currentModel = root;
            this.variableTypesStack = new Stack();
            this.doSwitch((EObject)this.currentModel.getRoot());
        });
        return this.msgs;
    }

    @Override
    public Object caseModelUnit(ModelUnit root) {
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateModelUnit(root));
        });
        for (BehavioredClass xtdClass : root.getClassExtensions()) {
            this.doSwitch((EObject)xtdClass);
        }
        for (BehavioredClass xtdClass : root.getClassDefinitions()) {
            this.doSwitch((EObject)xtdClass);
        }
        return null;
    }

    @Override
    public Object caseExtendedClass(ExtendedClass xtdClass) {
        HashMap classScope = new HashMap();
        for (Attribute attrib : xtdClass.getAttributes()) {
            if (attrib.getInitialValue() == null) continue;
            this.validateAndStore(attrib.getInitialValue(), new HashMap<String, Set<IType>>());
        }
        HashSet<EClassifierType> selfTypeSet = new HashSet<EClassifierType>();
        EClassifierType selfType = new EClassifierType((IReadOnlyQueryEnvironment)this.qryEnv, (EClassifier)xtdClass.getBaseClass());
        selfTypeSet.add(selfType);
        classScope.put("self", selfTypeSet);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateExtendedClass(xtdClass));
        });
        this.variableTypesStack.push(classScope);
        for (Method operation : xtdClass.getMethods()) {
            this.doSwitch(operation);
        }
        this.variableTypesStack.pop();
        return null;
    }

    @Override
    public Object caseRuntimeClass(RuntimeClass runtimeCls) {
        Collection registered;
        HashMap classScope = new HashMap();
        for (Attribute attrib : runtimeCls.getAttributes()) {
            if (attrib.getInitialValue() == null) continue;
            this.validateAndStore(attrib.getInitialValue(), new HashMap<String, Set<IType>>());
        }
        String pkgName = ((ModelUnit)runtimeCls.eContainer()).getName();
        if (pkgName.lastIndexOf(".") != -1 && pkgName.lastIndexOf(".") != pkgName.length() - 1) {
            pkgName = pkgName.substring(pkgName.lastIndexOf(".") + 1);
        }
        if (!(registered = this.qryEnv.getEPackageProvider().getTypes(pkgName, runtimeCls.getName())).isEmpty()) {
            EClassifier runtimeEClass = (EClassifier)registered.iterator().next();
            HashSet<EClassifierType> selfTypeSet = new HashSet<EClassifierType>();
            EClassifierType selfType = new EClassifierType((IReadOnlyQueryEnvironment)this.qryEnv, runtimeEClass);
            selfTypeSet.add(selfType);
            classScope.put("self", selfTypeSet);
        }
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateRuntimeClass(runtimeCls));
        });
        this.variableTypesStack.push(classScope);
        for (Method operation : runtimeCls.getMethods()) {
            this.doSwitch(operation);
        }
        this.variableTypesStack.pop();
        return null;
    }

    @Override
    public Object caseMethod(Method mtd) {
        HashMap<String, Set<IType>> methodScope = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        if (mtd.getOperationRef() != null) {
            for (EParameter param : mtd.getOperationRef().getEParameters()) {
                Set previousDeclaration = (Set)methodScope.get(param.getName());
                if (previousDeclaration != null) continue;
                EClassifierType type = new EClassifierType((IReadOnlyQueryEnvironment)this.qryEnv, param.getEType());
                methodScope.put(param.getName(), Sets.newHashSet((Object[])new IType[]{type}));
            }
        }
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateMethod(mtd));
        });
        this.variableTypesStack.push(methodScope);
        this.doSwitch(mtd.getBody());
        this.variableTypesStack.pop();
        return null;
    }

    @Override
    public Object caseBlock(Block block) {
        HashMap<String, Set<IType>> blockScope = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        this.variableTypesStack.push(blockScope);
        this.blockContexts.put(block, blockScope);
        for (Statement stmt : block.getStatements()) {
            this.doSwitch(stmt);
        }
        this.variableTypesStack.pop();
        return null;
    }

    @Override
    public Object caseExpressionStatement(ExpressionStatement expStmt) {
        this.validateAndStore(expStmt.getExpression(), this.getCurrentScope());
        return null;
    }

    @Override
    public Object caseFeatureAssignment(FeatureAssignment featAssign) {
        Map<String, Set<IType>> scope = this.getCurrentScope();
        this.validateAndStore(featAssign.getTarget(), scope);
        this.validateAndStore(featAssign.getValue(), scope);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateFeatureAssignment(featAssign));
        });
        return null;
    }

    @Override
    public Object caseFeatureInsert(FeatureInsert featInsert) {
        Map<String, Set<IType>> scope = this.getCurrentScope();
        this.validateAndStore(featInsert.getTarget(), scope);
        this.validateAndStore(featInsert.getValue(), scope);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateFeatureInsert(featInsert));
        });
        return null;
    }

    @Override
    public Object caseFeatureRemove(FeatureRemove featRemove) {
        Map<String, Set<IType>> scope = this.getCurrentScope();
        this.validateAndStore(featRemove.getTarget(), scope);
        this.validateAndStore(featRemove.getValue(), scope);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateFeatureRemove(featRemove));
        });
        return null;
    }

    @Override
    public Object caseForEach(ForEach loop) {
        HashMap<String, Set<IType>> loopScope = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        this.validateAndStore(loop.getCollectionExpression(), this.getCurrentScope());
        loopScope.put(loop.getVariable(), this.getPossibleCollectionTypes(loop.getCollectionExpression()));
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateForEach(loop));
        });
        this.variableTypesStack.push(loopScope);
        this.doSwitch(loop.getBody());
        this.variableTypesStack.pop();
        return null;
    }

    @Override
    public Object caseIf(If ifStmt) {
        for (ConditionalBlock cBlock : ifStmt.getBlocks()) {
            this.validateAndStore(cBlock.getCondition(), this.getCurrentScope());
        }
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateIf(ifStmt));
        });
        for (ConditionalBlock cBlock : ifStmt.getBlocks()) {
            HashMap<String, Set<IType>> blockScope = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
            IValidationResult validRes = this.validations.get(cBlock.getCondition());
            if (validRes != null) {
                Map vartypes = validRes.getInferredVariableTypes(cBlock.getCondition(), Boolean.valueOf(true));
                blockScope.putAll(vartypes);
            }
            this.variableTypesStack.push(blockScope);
            this.doSwitch(cBlock.getBlock());
            this.variableTypesStack.pop();
        }
        if (ifStmt.getElse() != null) {
            HashMap<String, Set<IType>> elseScope = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
            HashMap<String, Set> vartypes = new HashMap<String, Set>();
            for (ConditionalBlock cBlock : ifStmt.getBlocks()) {
                IValidationResult validRes = this.validations.get(cBlock.getCondition());
                if (validRes == null) continue;
                Map previousVartypes = validRes.getInferredVariableTypes(cBlock.getCondition(), Boolean.valueOf(false));
                for (String varName : previousVartypes.keySet()) {
                    Set types = (Set)vartypes.get(varName);
                    if (types == null) {
                        vartypes.put(varName, (Set)previousVartypes.get(varName));
                        continue;
                    }
                    types.addAll((Collection)previousVartypes.get(varName));
                }
            }
            elseScope.putAll(vartypes);
            this.variableTypesStack.push(elseScope);
            this.doSwitch(ifStmt.getElse());
            this.variableTypesStack.pop();
        }
        return null;
    }

    @Override
    public Object caseVariableAssignment(VariableAssignment varAssign) {
        this.validateAndStore(varAssign.getValue(), this.getCurrentScope());
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateVariableAssignment(varAssign));
        });
        return null;
    }

    @Override
    public Object caseVariableDeclaration(VariableDeclaration varDecl) {
        if (varDecl.getInitialValue() != null) {
            this.validateAndStore(varDecl.getInitialValue(), this.getCurrentScope());
        }
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateVariableDeclaration(varDecl));
        });
        Map<String, Set<IType>> lastScope = this.variableTypesStack.peek();
        if (varDecl.getInitialValue() != null) {
            lastScope.put(varDecl.getName(), this.getPossibleTypes(varDecl.getInitialValue()));
        } else {
            EClassifierType declaredType = new EClassifierType((IReadOnlyQueryEnvironment)this.qryEnv, varDecl.getType());
            lastScope.put(varDecl.getName(), Sets.newHashSet((Object[])new IType[]{declaredType}));
        }
        return null;
    }

    @Override
    public Object caseWhile(While loop) {
        this.validateAndStore(loop.getCondition(), this.getCurrentScope());
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateWhile(loop));
        });
        HashMap<String, Set<IType>> loopScope = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        IValidationResult validRes = this.validations.get(loop.getCondition());
        if (validRes != null) {
            Map vartypes = validRes.getInferredVariableTypes(loop.getCondition(), Boolean.valueOf(true));
            loopScope.putAll(vartypes);
        }
        this.variableTypesStack.push(loopScope);
        this.doSwitch(loop.getBody());
        this.variableTypesStack.pop();
        return null;
    }

    public Map<String, Set<IType>> getCurrentScope() {
        return this.variableTypesStack.peek();
    }

    private IValidationResult validateExpression(Expression exp, Map<String, Set<IType>> variableTypes) {
        IQueryBuilderEngine.AstResult fakeAst = new IQueryBuilderEngine.AstResult(exp, this.currentModel.getStartPositions(), this.currentModel.getEndPositions(), new ArrayList(), (Diagnostic)new BasicDiagnostic());
        try {
            return this.expValidator.validate(variableTypes, fakeAst);
        }
        catch (AcceleoQueryValidationException e) {
            System.out.println((Object)e);
            return new ValidationResult(fakeAst);
        }
    }

    public int getStartOffset(Object obj) {
        return this.currentModel.getStartPositions().get(obj);
    }

    public int getEndOffset(Object obj) {
        return this.currentModel.getEndPositions().get(obj);
    }

    private void validateAndStore(Expression exp, Map<String, Set<IType>> context) {
        IValidationResult expValidation = this.validateExpression(exp, context);
        this.msgs.addAll(expValidation.getMessages());
        this.validations.put(exp, expValidation);
        this.validationContexts.put(exp, context);
    }

    public Set<IType> getPossibleTypes(Expression exp) {
        IValidationResult validRes = this.validations.get(exp);
        if (validRes != null) {
            return validRes.getPossibleTypes(exp);
        }
        EObject parent = exp.eContainer();
        while (parent instanceof Expression) {
            if (this.validations.get(parent) != null) {
                return this.validations.get(parent).getPossibleTypes(exp);
            }
            parent = parent.eContainer();
        }
        return new HashSet<IType>();
    }

    public Set<IType> getPossibleCollectionTypes(Expression exp) {
        HashSet<IType> res = new HashSet<IType>();
        IValidationResult validRes = this.validations.get(exp);
        if (validRes != null) {
            Set types = validRes.getPossibleTypes(exp);
            for (IType type : types) {
                if (type instanceof AbstractCollectionType) {
                    res.add(((AbstractCollectionType)type).getCollectionType());
                    continue;
                }
                res.add(type);
            }
        }
        return res;
    }

    public List<ExtendedClass> findExtensions(EClass realType) {
        return this.allModels.stream().flatMap(m -> ((ModelUnit)m.getRoot()).getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass().isSuperTypeOf(realType)).collect(Collectors.toList());
    }

    public IQueryEnvironment getQryEnv() {
        return this.qryEnv;
    }

    public Method getContainingOperation(VariableAssignment varAssign) {
        EObject parent = varAssign.eContainer();
        while (parent != null && !(parent instanceof Method)) {
            parent = parent.eContainer();
        }
        return (Method)parent;
    }

    public Map<String, Set<IType>> getValidationContext(Expression exp) {
        Map<String, Set<IType>> res = this.validationContexts.get(exp);
        if (res != null) {
            return res;
        }
        return new HashMap<String, Set<IType>>();
    }

    public Map<String, Set<IType>> getValidationContext(Block block) {
        Map<String, Set<IType>> res = this.blockContexts.get(block);
        if (res != null) {
            return res;
        }
        return new HashMap<String, Set<IType>>();
    }
}

