/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.simple;

import fr.kairos.timesquare.ccsl.IDefinition;
import java.util.Arrays;
import java.util.HashMap;

public final class Definition
implements IDefinition {
    private String expressionName;
    private HashMap<String, Integer> intParams;
    private HashMap<String, String> stringParams;
    private String[] refClocks;
    private String definedClock;

    public Definition(String definedClockName, String expressionName, String ... clocks) {
        this.expressionName = expressionName;
        this.refClocks = clocks;
        this.definedClock = definedClockName;
    }

    public Definition set(String name, int value) {
        if (this.intParams == null) {
            this.intParams = new HashMap();
        }
        this.intParams.put(name, value);
        return this;
    }

    public Definition set(String name, String value) {
        if (this.stringParams == null) {
            this.stringParams = new HashMap();
        }
        this.stringParams.put(name, value);
        return this;
    }

    @Override
    public int getIntParam(String name, int defaut) {
        if (this.intParams != null && this.intParams.containsKey(name)) {
            return this.intParams.get(name);
        }
        return defaut;
    }

    @Override
    public String getStringParam(String name) {
        if (this.stringParams != null && this.stringParams.containsKey(name)) {
            return this.stringParams.get(name);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.definedClock) + " = " + this.expressionName + "(" + Arrays.deepToString(this.refClocks) + ")";
    }

    @Override
    public String getDefinedClock() {
        return this.definedClock;
    }

    @Override
    public String[] getRefClocks() {
        return this.refClocks;
    }

    @Override
    public String getConstraintName() {
        return this.expressionName;
    }

    public void copyParamFrom(IDefinition def) {
        if (def instanceof Definition) {
            Definition d = (Definition)def;
            if (d.stringParams != null) {
                for (String k : d.stringParams.keySet()) {
                    this.set(k, d.stringParams.get(k));
                }
            }
            if (d.intParams != null) {
                for (String k : d.intParams.keySet()) {
                    this.set(k, d.intParams.get(k));
                }
            }
        } else {
            throw new RuntimeException("Do not know how to copy params");
        }
    }
}

