/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.wizard.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ResourceSelectionWizardPage
extends WizardPage
implements IWizardPage {
    private String extension;
    private boolean multipleSelection;
    private List<Object> liblist = new ArrayList<Object>();
    TableViewer tv = null;

    public ResourceSelectionWizardPage(String pageName, String title, String extension, boolean multipleSelect) {
        super(pageName);
        this.setTitle(title);
        if (multipleSelect) {
            this.setDescription("Select the resource(s) to import");
        } else {
            this.setDescription("Select a resource to import");
        }
        this.extension = extension;
        this.multipleSelection = multipleSelect;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)new FormLayout());
        Label containerLabel = new Label(composite, 16384);
        FormData fd_containerLabel = new FormData();
        fd_containerLabel.right = new FormAttachment(100, -5);
        fd_containerLabel.top = new FormAttachment(0, 5);
        fd_containerLabel.left = new FormAttachment(0, 5);
        containerLabel.setLayoutData((Object)fd_containerLabel);
        if (this.multipleSelection) {
            containerLabel.setText("Select Resource(s)");
        } else {
            containerLabel.setText("Select One Resource");
        }
        Table tb = this.multipleSelection ? new Table(composite, 42) : new Table(composite, 4);
        this.tv = new TableViewer(tb);
        tb.setHeaderVisible(true);
        FormData fd_t = new FormData();
        fd_t.top = new FormAttachment((Control)containerLabel, 6);
        fd_t.bottom = new FormAttachment(100, -18);
        fd_t.left = new FormAttachment(0, 5);
        fd_t.right = new FormAttachment(100, -5);
        tb.setLayoutData((Object)fd_t);
        TableViewerColumn tvc = new TableViewerColumn(this.tv, 0);
        tvc.getColumn().setText(" ");
        tvc.getColumn().setWidth(25);
        TableViewerColumn tvc2 = new TableViewerColumn(this.tv, 0, 1);
        tvc2.getColumn().setText(" Resource ");
        tvc2.getColumn().setWidth(350);
        this.tv.setContentProvider((IContentProvider)new ListContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.tv.setInput(this.liblist);
        TableItem[] tableItemArray = this.tv.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getData() instanceof String) {
                ti.setChecked(true);
            }
            ++n2;
        }
        this.setControl((Control)composite);
    }

    public void buildLst(List<String> input) {
        int n;
        int n2;
        IResource[] iResourceArray;
        this.liblist = new ArrayList<Object>();
        this.liblist.addAll(input);
        try {
            iResourceArray = ResourcesPlugin.getWorkspace().getRoot().members();
            n2 = iResourceArray.length;
            n = 0;
            while (n < n2) {
                IResource r = iResourceArray[n];
                if (r.isAccessible()) {
                    this.buildLst(this.liblist, r);
                }
                ++n;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (this.tv != null) {
            this.tv.setInput(this.liblist);
            iResourceArray = this.tv.getTable().getItems();
            n2 = iResourceArray.length;
            n = 0;
            while (n < n2) {
                IResource ti = iResourceArray[n];
                if (ti.getData() instanceof String) {
                    ti.setChecked(true);
                }
                ++n;
            }
        }
    }

    private void buildLst(List<Object> lst, IResource r) {
        if (r instanceof IContainer) {
            try {
                IResource[] iResourceArray = ((IContainer)r).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource _r = iResourceArray[n2];
                    this.buildLst(this.liblist, _r);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return;
        }
        if (r instanceof IFile && this.extension.equals(r.getFileExtension())) {
            this.liblist.add(r);
        }
    }

    public List<Object> getLiblist() {
        return this.liblist;
    }

    public TableViewer getTv() {
        return this.tv;
    }

    public List<Object> getSelection() {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.multipleSelection) {
            TableItem[] tableItemArray = this.tv.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                if (ti.getChecked()) {
                    lst.add(ti.getData());
                }
                ++n2;
            }
        } else {
            TableItem[] tableItemArray = this.tv.getTable().getSelection();
            int n = tableItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem ti = tableItemArray[n3];
                lst.add(ti.getData());
                ++n3;
            }
        }
        return lst;
    }

    public class ListContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object element) {
            if (element instanceof List) {
                return ((List)element).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (index == 1) {
                if (obj instanceof IFile) {
                    return ((IFile)obj).getFullPath().toOSString();
                }
                return obj.toString();
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

