/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view.constraint;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.figure.ConstraintsConnection;
import fr.inria.aoste.timesquare.vcd.view.constraint.AbsConstraint;
import fr.inria.aoste.timesquare.vcd.view.constraint.IConstraint;
import fr.inria.aoste.timesquare.vcd.view.figure.Draw1;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ConstraintSustains
extends AbsConstraint
implements IConstraint {
    private String nameSustains = null;
    private String nameStart = null;
    private String nameStop = null;
    private ArrayList<ExtendFigure> clockSustain = null;
    private ArrayList<ExtendFigure> clockStart = null;
    private ArrayList<ExtendFigure> clockStop = null;

    public ConstraintSustains() {
        this.testn = 2;
    }

    @Override
    public int draw(Draw1 currentFig, String currentclock) {
        int startID = -1;
        int stopID = -1;
        int sustainFirstID = -1;
        int sustainLastID = -1;
        int cas = 0;
        int currentX = currentFig.getBounds().x;
        this.nameSustains = this.cc.getClock();
        this.nameStart = this.cc.getReferenceClocks().get(0);
        this.nameStop = this.cc.getReferenceClocks().get(1);
        this.clockSustain = this.vcdFactory.getNameforfigures().get(this.nameSustains);
        this.clockStart = this.vcdFactory.getNameforfigures().get(this.nameStart);
        this.clockStop = this.vcdFactory.getNameforfigures().get(this.nameStop);
        if (currentclock.equals(this.nameSustains)) {
            cas = 1;
        }
        if (currentclock.equals(this.nameStart)) {
            cas = 2;
        }
        if (currentclock.equals(this.nameStop)) {
            cas = 3;
        }
        switch (cas) {
            case 1: {
                startID = this.icc.lastBeforeweak(this.nameStart, currentX);
                int startX = this.clockStart.get((int)startID).getBounds().x;
                sustainFirstID = this.icc.firstAfter(this.nameSustains, startX);
                stopID = this.icc.firstAfterStrict(this.nameStop, startX);
                if (stopID == -1) {
                    sustainLastID = this.clockSustain.size() - 1;
                    break;
                }
                int stopX = this.clockStop.get((int)stopID).getBounds().x;
                sustainLastID = this.icc.lastBefore(this.nameSustains, stopX);
                break;
            }
            case 2: {
                startID = this.clockStart.indexOf(currentFig);
                sustainFirstID = this.icc.firstAfter(this.nameSustains, currentX);
                stopID = this.icc.firstAfterStrict(this.nameStop, currentX);
                if (stopID == -1) {
                    sustainLastID = this.clockSustain.size() - 1;
                    break;
                }
                int stopX = this.clockStop.get((int)stopID).getBounds().x;
                sustainLastID = this.icc.lastBefore(this.nameSustains, stopX);
                break;
            }
            case 3: {
                stopID = this.clockStop.indexOf(currentFig);
                sustainLastID = this.icc.lastBefore(this.nameSustains, currentX);
                startID = this.icc.lastBefore(this.nameStart, currentX);
                int startX = this.clockStart.get((int)startID).getBounds().x;
                sustainFirstID = this.icc.firstAfter(this.nameSustains, startX);
                break;
            }
        }
        int ret = this.display(startID, stopID, sustainFirstID, sustainLastID);
        if (ret == -1) {
            return -1;
        }
        return 0;
    }

    private int display(int startID, int stopID, int sustainFirstID, int sustainLastID) {
        if (startID == -1 || sustainFirstID == -1 || sustainLastID == -1) {
            return -1;
        }
        IFigure startFig = this.clockStart.get(startID);
        IFigure sustainFirstFig = this.clockSustain.get(sustainFirstID);
        IFigure sustainLastFig = this.clockSustain.get(sustainLastID);
        Color colorSustain = this.mca.colorBlueSustain();
        Color colorArraw = this.mca.colorWhiteArrow();
        ArrayList<ConstraintsConnection> packet = this.icc.constructPacket(colorSustain, (Draw1)sustainFirstFig, (Draw1)sustainLastFig);
        ConstraintsConnection arrowStart = this.icc.constructDashConnection(colorArraw, (Draw1)startFig, (Draw1)packet.get(0).getSourceAnchor().getOwner(), false);
        arrowStart.setComment(this.cc);
        for (ConstraintsConnection c : packet) {
            c.setGlobal(this.isGlobal);
            c.setComment(this.cc);
            this.icc.addToList(this.list.getListConstraints(), c);
        }
        arrowStart.setGlobal(this.isGlobal);
        this.icc.addToList(this.list.getListConstraints(), arrowStart);
        if (stopID != -1) {
            IFigure stopFig = this.clockStop.get(startID);
            ConstraintsConnection arrowStop = this.icc.constructDashConnection(colorArraw, (Draw1)packet.get(2).getSourceAnchor().getOwner(), (Draw1)stopFig, false);
            arrowStop.setComment(this.cc);
            arrowStop.setGlobal(this.isGlobal);
            this.icc.addToList(this.list.getListConstraints(), arrowStop);
        }
        return 0;
    }

    @Override
    public int drawTableItemConstraints() {
        String nameClock;
        block6: {
            this.isGlobal = true;
            nameClock = this.cc.getReferenceClocks().get(0);
            if (this.haveAllClockVisible()) {
                for (IFigure iFigure : this.vcdFactory.getNameforfigures().get(nameClock)) {
                    this.draw((Draw1)iFigure, nameClock);
                }
                break block6;
            }
            return -1;
        }
        try {
            IVcdDiagram iVcdDiagram = this.vcdFactory.getVcddia();
            for (IFigure iFigure : this.list.getListConstraints()) {
                Dimension dim = iVcdDiagram.getCanvas().getContents().getPreferredSize();
                iVcdDiagram.getCanvas().getContents().add(iFigure);
                Rectangle bounds = iFigure.getBounds();
                iVcdDiagram.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                iVcdDiagram.getCanvas().getContents().setPreferredSize(dim);
            }
            this.isConstraintVisible = true;
            this.isGlobal = false;
            return this.vcdFactory.getNameforfigures().get(nameClock).size();
        }
        catch (Throwable t) {
            ErrorConsole.printError((Throwable)t);
            this.isGlobal = false;
            return -1;
        }
    }

    @Override
    public int drawOneTick(int ticknum, String clockId) {
        return 0;
    }
}

