/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model.visitor;

import fr.inria.aoste.timesquare.vcd.model.IDeclarationCommand;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.command.HierVar;
import fr.inria.aoste.timesquare.vcd.model.command.Var;
import fr.inria.aoste.timesquare.vcd.model.command.VarCommand;
import fr.inria.aoste.timesquare.vcd.model.keyword.ScopeType;
import fr.inria.aoste.timesquare.vcd.model.keyword.VarType;
import fr.inria.aoste.timesquare.vcd.model.visitor.IScopeVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class VarCollector
implements IScopeVisitor,
Iterable<IVar> {
    private ArrayList<IVar> _vars = new ArrayList();
    private LinkedList<String> _names = new LinkedList();
    private String _parent = null;

    public VarCollector(ArrayList<IDeclarationCommand> list) {
    }

    @Override
    public void visitScope(ScopeType type, String name) {
        if (this._parent != null) {
            this._names.add(this._parent);
        }
        this._parent = name;
    }

    @Override
    public void visitUpscope() {
        this._parent = this._names.isEmpty() ? null : this._names.removeLast();
    }

    @Override
    public void visitVar(VarCommand command, VarType type, String ref) {
        Object obj;
        IVar var = new Var(command, this._parent);
        if (!this._names.isEmpty()) {
            ListIterator<String> it = this._names.listIterator(this._names.size() - 1);
            while (it.hasPrevious()) {
                var.clear();
                var = null;
                var = new HierVar(var, it.previous());
            }
        }
        if ((obj = var.getData("hide")) instanceof Boolean && ((Boolean)obj).booleanValue()) {
            var.setVisibleByDefault(false);
        }
        if ((obj = var.getData("alias")) instanceof String) {
            var.getVarCommand().setData("alias", obj);
        }
        this._vars.add(var);
    }

    @Override
    public Iterator<IVar> iterator() {
        return this._vars.iterator();
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        for (IVar var : this) {
            strBuffer.append(String.valueOf(var.toString()) + "\n");
        }
        return strBuffer.toString();
    }
}

