/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.label;

import fr.inria.aoste.timesquare.vcd.label.ITimeLabelling;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import java.text.DecimalFormat;

public class TickTimeLabelling
implements ITimeLabelling {
    private VCDDefinitions _vcdDefinitions = null;
    private String _unit = "";
    private double _rate = 0.1;
    private DecimalFormat _decimalFormat = new DecimalFormat("#.####E0");

    public String getUnit() {
        return this._unit;
    }

    public void setUnit(String unit) {
        if (unit == null || unit.length() == 0) {
            this._unit = "";
            return;
        }
        this._unit = unit;
    }

    public double getRate() {
        return this._rate;
    }

    public void setRate(double rate) {
        if (rate != 0.0) {
            this._rate = rate;
        }
    }

    @Override
    public String getTimeMarker(double x) {
        if (this._unit.length() == 0) {
            return "Tick: " + Math.round(x * this._rate);
        }
        return "" + this._decimalFormat.format(x * this._rate) + " " + this._unit;
    }

    @Override
    public String getRulerTimeIndice(int x) {
        if (this._unit.length() == 0) {
            if (x % 10 == 0) {
                return Integer.toString(x / 10);
            }
            return "";
        }
        return this._decimalFormat.format((double)x * this._rate);
    }

    @Override
    public VCDDefinitions getVcdDefinitions() {
        return this._vcdDefinitions;
    }

    @Override
    public void setVcdDefinitions(VCDDefinitions vcdDefinitions) {
        this._vcdDefinitions = vcdDefinitions;
    }
}

