/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.exceptions.ResolveClockConstraintException;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPrecedes;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;

public class CreatorPrecedesInf
extends CreatorPrecedes {
    int deltasource = 0;
    int deltadest = 0;

    public CreatorPrecedesInf(CCSLConstraintRef cref, ModelElementReference source, ModelElementReference target) {
        super(cref, source, target, false);
    }

    @Override
    protected void resolve(EventOccurrence esource, EventOccurrence etarget) throws ResolveClockConstraintException {
        boolean bsource = this.clockTick(esource);
        boolean btarget = this.clockTick(etarget);
        if (bsource && btarget && esource.getCounter() - this.deltasource == etarget.getCounter() - this.deltadest) {
            return;
        }
        super.resolve(esource, etarget);
    }

    @Override
    protected void init() {
        this.deltasource = this.getEventOccurrenceOnStepTrace(this.getSource()).getCounter();
        this.deltadest = this.getEventOccurrenceOnStepTrace(this.getTarget()).getCounter();
        if (this.clockTick(this.getEventOccurrenceOnStepTrace(this.getSource()))) {
            --this.deltasource;
        }
        if (this.clockTick(this.getEventOccurrenceOnStepTrace(this.getTarget()))) {
            --this.deltadest;
        }
    }

    @Override
    public void finish() throws ResolveClockConstraintException {
        if (!this.queue.isEmpty()) {
            this.workTarget(this.getEventOccurrenceOnStepTrace(this.getTarget()));
        }
    }
}

