/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;

public class RuntimeUnion
extends AbstractRuntimeExpression {
    private RuntimeClock leftClock;
    private RuntimeClock rightClock;

    public RuntimeUnion(RuntimeClock implicitClock, RuntimeClock leftClock, RuntimeClock rightClock) {
        super(implicitClock);
        this.leftClock = leftClock;
        this.rightClock = rightClock;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (this.leftClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.leftClock)).semantic(helper);
        }
        if (this.rightClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.rightClock)).semantic(helper);
        }
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.isDead()) {
            helper.inhibitClock(this.getExpressionClock());
        } else {
            helper.semanticBDDAnd(helper.createEqual(this.getExpressionClock(), helper.createUnion(this.getLeftClock(), this.getRightClock())));
        }
        helper.registerClockUse(new RuntimeClock[]{this.getExpressionClock(), this.getLeftClock(), this.getRightClock()});
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        super.update(helper);
        if (this.leftClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.leftClock)).update(helper);
        }
        if (this.rightClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.rightClock)).update(helper);
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.leftClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.leftClock)).deathSemantic(helper);
        }
        if (this.rightClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.rightClock)).deathSemantic(helper);
        }
        helper.registerDeathConjunctionImplies(this.leftClock, this.rightClock, this.getExpressionClock());
    }

    public RuntimeClock getLeftClock() {
        return this.leftClock;
    }

    public RuntimeClock getRightClock() {
        return this.rightClock;
    }
}

