/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.library.xtext.ui.contentassist;

import com.google.common.base.Predicate;
import fr.inria.aoste.timesquare.ccslkernel.library.xtext.ui.contentassist.AbstractCCSLLibraryProposalProvider;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.xtext.util.BindingPredicate;
import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class CCSLLibraryProposalProvider
extends AbstractCCSLLibraryProposalProvider {
    public String generateName(String base, Resource r) {
        ArrayList<String> l = new ArrayList<String>();
        TreeIterator ieos = r.getAllContents();
        while (ieos.hasNext()) {
            EObject eo = (EObject)ieos.next();
            if (!(eo instanceof NamedElement)) continue;
            l.add(((NamedElement)eo).getName());
        }
        String name = base;
        int i = 0;
        do {
            name = String.valueOf(base) + i;
            ++i;
        } while (l.indexOf(name) != -1);
        return name;
    }

    @Override
    public void complete_Relation(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            ResourceSet rs = model.eResource().getResourceSet();
            String name = this.generateName("relation_", model.eResource());
            ArrayList<RelationDeclaration> l = new ArrayList<RelationDeclaration>();
            for (Resource r : rs.getResources()) {
                TreeIterator ieo = r.getAllContents();
                while (ieo.hasNext()) {
                    EObject eo = (EObject)ieo.next();
                    if (!(eo instanceof RelationDeclaration)) continue;
                    l.add((RelationDeclaration)eo);
                }
            }
            for (RelationDeclaration rd : l) {
                try {
                    String proposal = "Relation :" + rd.getName() + "    ";
                    String text = "Relation " + name + "[" + rd.getName() + "](  ";
                    boolean bool = false;
                    if (rd instanceof KernelRelationDeclaration) {
                        text = String.valueOf(text) + " " + ((KernelRelationDeclaration)rd).getLeftEntity().getName() + "-> . ,";
                        text = String.valueOf(text) + " " + ((KernelRelationDeclaration)rd).getRightEntity().getName() + "-> . ";
                        bool = true;
                    }
                    for (AbstractEntity b : rd.getParameters()) {
                        if (bool) {
                            text = String.valueOf(text) + ",";
                        }
                        text = String.valueOf(text) + b.getName() + "-> . ";
                        bool = true;
                    }
                    text = String.valueOf(text) + " )\n";
                    ICompletionProposal completionProposal = this.createCompletionProposal(text, proposal, null, context);
                    acceptor.accept(completionProposal);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    @Override
    public void complete_Expression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            ResourceSet rs = model.eResource().getResourceSet();
            String name = this.generateName("expression_", model.eResource());
            ArrayList<ExpressionDeclaration> l = new ArrayList<ExpressionDeclaration>();
            for (Resource r : rs.getResources()) {
                TreeIterator ieo = r.getAllContents();
                while (ieo.hasNext()) {
                    EObject eo = (EObject)ieo.next();
                    if (!(eo instanceof ExpressionDeclaration)) continue;
                    l.add((ExpressionDeclaration)eo);
                }
            }
            for (ExpressionDeclaration rd : l) {
                try {
                    String proposal = "Expression " + rd.getName();
                    String text = "Expression " + name + "=" + rd.getName() + "( ";
                    boolean bool = false;
                    for (EObject b : rd.eContents()) {
                        if (bool) {
                            text = String.valueOf(text) + ",";
                        }
                        if (b instanceof AbstractEntity) {
                            text = String.valueOf(text) + ((AbstractEntity)b).getName() + "-> . ";
                        }
                        bool = true;
                    }
                    text = String.valueOf(text) + " )\n";
                    ICompletionProposal completionProposal = this.createCompletionProposal(text, proposal, null, context);
                    acceptor.accept(completionProposal);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {}
    }

    @Override
    public void completeBinding_Abstract(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, (Predicate)new BindingPredicate(model, BindingPredicate.binding_Abstract));
    }

    @Override
    public void completeBinding_Bindable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, (Predicate)new BindingPredicate(model, BindingPredicate.binding_Bindable));
    }
}

