/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel;

import fr.inria.aoste.timesquare.ccslkernel.compiler.CompilerParameters;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.MemberFunction;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.MemberVariable;
import fr.inria.aoste.timesquare.ccslkernel.compiler.helpers.PluginProjectHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ClassDefinition {
    private String className;
    private String packageName;
    private String fileName;
    private IProject project;
    private String parentClassName;
    private List<String> interfaces = new ArrayList<String>();
    private Set<String> importedPackages = new HashSet<String>();
    private List<String> modifiers = new ArrayList<String>();
    private List<ClassDefinition> innerClasses = new ArrayList<ClassDefinition>();
    private List<MemberVariable> memberVariables = new ArrayList<MemberVariable>();
    private List<MemberFunction> memberFunctions = new ArrayList<MemberFunction>();

    public ClassDefinition(String className) {
        this.className = className;
        this.fileName = String.valueOf(className) + ".java";
    }

    public ClassDefinition(String className, String packageName) {
        this.className = className;
        this.packageName = packageName;
        this.fileName = String.valueOf(className) + ".java";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setParentClassName(String name) {
        this.parentClassName = name;
    }

    public void addInterface(String name) {
        this.interfaces.add(name);
    }

    public void addImportedPackage(String packageName) {
        if (packageName.compareTo("java.lang") != 0) {
            this.importedPackages.add(packageName);
        }
    }

    public void addModifier(String modifier) {
        this.modifiers.add(modifier);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void addInnerClass(ClassDefinition classDef) {
        this.innerClasses.add(classDef);
    }

    public void addMemberFunction(MemberFunction function) {
        this.memberFunctions.add(function);
    }

    public void addMemberVariable(MemberVariable variable) {
        this.memberVariables.add(variable);
    }

    public MemberFunction getMemberFunction(String functionName) {
        for (MemberFunction function : this.memberFunctions) {
            if (function.getName().compareTo(functionName) != 0) continue;
            return function;
        }
        return null;
    }

    public MemberVariable getMemberVariable(String variableName) {
        for (MemberVariable var : this.memberVariables) {
            if (var.getName().compareTo(variableName) != 0) continue;
            return var;
        }
        return null;
    }

    private void generateFileHeader(StringBuilder fileContent) {
        fileContent.append("package " + this.packageName + ";\n\n");
        for (String name : this.importedPackages) {
            if (name.startsWith("java.lang.")) continue;
            fileContent.append("import " + name + ";\n");
        }
        fileContent.append("\n");
    }

    private void generateClassDefinition(StringBuilder fileContent, int indentation) {
        this.addIndentation(indentation, fileContent);
        if (this.modifiers.isEmpty()) {
            fileContent.append("public class " + this.className);
        } else {
            for (String modifier : this.modifiers) {
                fileContent.append(String.valueOf(modifier) + " ");
            }
            fileContent.append("class " + this.className);
        }
        if (this.parentClassName != null && !this.parentClassName.isEmpty()) {
            fileContent.append(" extends " + this.parentClassName);
        }
        if (!this.interfaces.isEmpty()) {
            fileContent.append(" implements ");
            Iterator<String> iter = this.interfaces.iterator();
            while (iter.hasNext()) {
                fileContent.append(iter.next());
                if (!iter.hasNext()) continue;
                fileContent.append(", ");
            }
        }
        fileContent.append(" {\n\n");
        for (ClassDefinition innerClass : this.innerClasses) {
            innerClass.generateClassDefinition(fileContent, indentation + CompilerParameters.indentStep);
            fileContent.append("\n");
        }
        for (MemberVariable variable : this.memberVariables) {
            variable.generate(fileContent, indentation + CompilerParameters.indentStep);
            fileContent.append("\n");
        }
        if (!this.memberFunctions.isEmpty()) {
            fileContent.append("\n");
        }
        for (MemberFunction function : this.memberFunctions) {
            function.generate(fileContent, indentation + CompilerParameters.indentStep);
            fileContent.append("\n");
        }
        this.addIndentation(indentation, fileContent);
        fileContent.append("}\n");
    }

    public void generate(PluginProjectHelper pluginHelper) throws CoreException {
        String folderName = this.packageName.replace(".", File.separator);
        String filePath = String.valueOf(CompilerParameters.genSourceFolder) + File.separator + folderName + File.separator + this.fileName;
        pluginHelper.createPackage(this.project, this.packageName);
        StringBuilder fileContent = new StringBuilder();
        this.generateFileHeader(fileContent);
        this.generateClassDefinition(fileContent, 0);
        pluginHelper.createFile(this.project, filePath, fileContent.toString());
    }

    private void addIndentation(int indent, StringBuilder content) {
        int i = 0;
        while (i < indent) {
            content.append(' ');
            ++i;
        }
    }
}

