/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.visible;

import fr.inria.aoste.timesquare.backend.manager.controller.Controller;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.IBehaviorManagerDialog;
import fr.inria.aoste.timesquare.launcher.debug.model.output.ReportMessage;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.Configurator;

public abstract class BehaviorConfigurator<T extends BehaviorManager>
implements Configurator {
    protected ConfigurationHelper configurationHelper = null;
    protected T behaviorManager = null;
    private Controller controller = null;

    public BehaviorConfigurator(ConfigurationHelper _ch, T _behaviorManager) {
        this.configurationHelper = _ch;
        this.behaviorManager = _behaviorManager;
    }

    public final boolean isActivable(ReportMessage rm) {
        return this.controller.isActivable(rm, this.controller.getOutputOption().getCcslhelper());
    }

    public final void activate() throws Exception {
        ReportMessage rm = new ReportMessage();
        if (!this.isActivable(rm)) {
            throw new Exception(rm.getMessage());
        }
        ((BehaviorManager)this.behaviorManager).activate();
    }

    public final String validate() {
        return ((BehaviorManager)this.behaviorManager).validate();
    }

    protected final ConfigurationHelper getConfigurationHelper() {
        return this.configurationHelper;
    }

    public final T getBehaviorManager() {
        return this.behaviorManager;
    }

    public final void setController(Controller controller) {
        this.controller = controller;
    }

    public IBehaviorManagerDialog openDialog() {
        IBehaviorManagerDialog dialog = this.controller.createDialog((BehaviorManager)this.behaviorManager);
        if (dialog != null) {
            return dialog;
        }
        throw new RuntimeException("no dialog for " + ((BehaviorManager)this.behaviorManager).getPluginName());
    }
}

