/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.view;

import fr.inria.aoste.timesquare.backend.manager.controller.Controller;
import fr.inria.aoste.timesquare.backend.manager.datastructure.DataStructureManager;
import fr.inria.aoste.timesquare.backend.manager.datastructure.relation.RelationBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.launcher.extensionpoint.OutputSetup;
import fr.inria.aoste.timesquare.backend.manager.view.BehaviorView;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class RelationBehaviorView
implements BehaviorView {
    private Tree _tree;
    public String id;

    public RelationBehaviorView(String id) {
        this.id = id;
    }

    @Override
    public void createContent(Composite composite, OutputSetup oSetup) {
        this._tree = new Tree(composite, 65540);
        oSetup.register((Widget)this._tree, this.id);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.minimumHeight = 200;
        this._tree.setLayoutData((Object)layoutData);
        TreeColumn clockColumn = new TreeColumn(this._tree, 0);
        clockColumn.setText("Relation");
        clockColumn.setResizable(true);
        clockColumn.setMoveable(true);
        clockColumn.setWidth(300);
        TreeColumn behaviorColumn = new TreeColumn(this._tree, 0);
        behaviorColumn.setText("Behavior");
        behaviorColumn.setResizable(true);
        behaviorColumn.setMoveable(true);
        behaviorColumn.setWidth(200);
        this._tree.setHeaderVisible(true);
    }

    @Override
    public void displayModel(DataStructureManager ds) {
        if (ds == null || this._tree == null) {
            return;
        }
        List<RelationBehaviorEntity> tmp = ds.getRelationBehaviorEntity();
        TreeItem[] tab = this._tree.getItems();
        boolean find = false;
        for (RelationBehaviorEntity e : tmp) {
            TreeItem subItem;
            find = false;
            int i = 0;
            while (i < tab.length) {
                if (tab[i].getText().equals(e.getRelationActivationState().getDescription())) {
                    find = true;
                    subItem = new TreeItem(tab[i], 0);
                    subItem.setData((Object)e);
                    if (e.getBehavior().getDescription() == null) {
                        subItem.setText(1, "");
                    } else {
                        subItem.setText(1, e.getBehavior().getDescription());
                    }
                }
                ++i;
            }
            if (find) continue;
            TreeItem relation = new TreeItem(this._tree, 0);
            relation.setText(e.getRelationActivationState().getDescription());
            subItem = new TreeItem(relation, 0);
            subItem.setData((Object)e);
            if (e.getBehavior().getDescription() == null) {
                subItem.setText(1, "*");
            } else {
                subItem.setText(1, e.getBehavior().getDescription());
            }
            tab = this._tree.getItems();
        }
    }

    @Override
    public void deleteBehavior(Controller controller, SelectionEvent selectionEvent) {
        if (controller == null || this._tree == null) {
            return;
        }
        TreeItem[] tab = this._tree.getSelection();
        if (tab != null) {
            int i = 0;
            while (i < tab.length) {
                if ((RelationBehaviorEntity)tab[i].getData() != null) {
                    controller.deleteEntity((RelationBehaviorEntity)tab[i].getData());
                }
                ++i;
            }
        }
    }

    @Override
    public void clear() {
        if (this._tree != null) {
            TreeItem[] tab = this._tree.getItems();
            int i = 0;
            while (i < tab.length) {
                tab[i].dispose();
                ++i;
            }
        }
    }
}

