/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.datastructure;

import fr.inria.aoste.timesquare.backend.manager.datastructure.assertion.AssertBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.assertion.AssertBehaviorList;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockBehaviorList;
import fr.inria.aoste.timesquare.backend.manager.datastructure.relation.RelationBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.relation.RelationBehaviorList;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.OccurrenceRelation;
import fr.inria.aoste.trace.AssertionState;
import fr.inria.aoste.trace.EventOccurrence;
import java.util.Collections;
import java.util.List;

public class DataStructureManager {
    private ClockBehaviorList _clockBehaviorList = new ClockBehaviorList();
    private RelationBehaviorList _relationBehaviorList = new RelationBehaviorList();
    private AssertBehaviorList _assertBehaviorList = new AssertBehaviorList();

    public void addEntity(ClockBehaviorEntity entity) {
        this._clockBehaviorList.addEntity(entity);
    }

    public void addEntity(AssertBehaviorEntity entity) {
        this._assertBehaviorList.addEntity(entity);
    }

    public void addEntity(RelationBehaviorEntity entity) {
        this._relationBehaviorList.addEntity(entity);
    }

    public List<ClockBehaviorEntity> getClockBehaviorEntity() {
        return Collections.unmodifiableList(this._clockBehaviorList.getData());
    }

    public List<RelationBehaviorEntity> getRelationBehaviorEntity() {
        return Collections.unmodifiableList(this._relationBehaviorList.getData());
    }

    public List<AssertBehaviorEntity> getAssertBehaviorEntity() {
        return Collections.unmodifiableList(this._assertBehaviorList.getData());
    }

    public void clear() {
        this._clockBehaviorList.clear();
        this._relationBehaviorList.clear();
        this._assertBehaviorList.clear();
    }

    public void deleteAssertBehaviorEntity(AssertBehaviorEntity assertBehaviorEntity) {
        this._assertBehaviorList.deleteEntity(assertBehaviorEntity);
    }

    public void deleteClockBehaviorEntity(ClockBehaviorEntity clockBehaviorEntity) {
        this._clockBehaviorList.deleteEntity(clockBehaviorEntity);
    }

    public void deleteRelationBehaviorEntity(RelationBehaviorEntity relationBehaviorEntity) {
        this._relationBehaviorList.deleteEntity(relationBehaviorEntity);
    }

    public void deleteEntitiesByPluginName(String pluginName) {
        this._clockBehaviorList.deleteEntitiesByPluginName(pluginName);
        this._relationBehaviorList.deleteEntitiesByPluginName(pluginName);
        this._assertBehaviorList.deleteEntitiesByPluginName(pluginName);
    }

    public void executeNewBehaviors(ClockEntity clockEntity, EventOccurrence clockState) {
        this._clockBehaviorList.executeNewBehaviors(clockEntity, clockState);
    }

    public void executeNewBehaviors(ClockEntity clockEntity, AssertionState clockState) {
        this._assertBehaviorList.executeNewBehaviors(clockEntity, clockState);
    }

    public void executeBehaviors(ClockEntity clockEntity, EventOccurrence clockState) {
        this._clockBehaviorList.executeBehaviors(clockEntity, clockState);
    }

    public void executeBehaviors(OccurrenceRelation relation) {
        this._relationBehaviorList.executeBehaviors(relation);
    }

    public void checkConsistency(List<ClockEntity> clocks, List<ClockEntity> _assert) {
        this._clockBehaviorList.checkConsistency(clocks);
        this._assertBehaviorList.checkConsistency(_assert);
    }

    public boolean pluginPresent(String pluginName) {
        return this._clockBehaviorList.pluginPresent(pluginName) || this._relationBehaviorList.pluginPresent(pluginName) || this._assertBehaviorList.pluginPresent(pluginName);
    }
}

