/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph.actions;

import com.google.inject.Inject;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.xtext.ui.graph.RailroadView;

public class ExportToFileAction
extends Action {
    @Inject
    private RailroadView railroadView;
    public static final int PADDING = 20;

    public ExportToFileAction() {
        this.setText("Export to file");
        this.setDescription("Exports this diagram to an image file");
        this.setToolTipText("Exports this diagram to an image file");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT_DISABLED"));
    }

    public void run() {
        IFigure contents = this.railroadView.getContents();
        if (contents != null) {
            FileDialog fileDialog = new FileDialog(this.railroadView.getSite().getShell(), 8192);
            fileDialog.setFilterExtensions(new String[]{"*.png"});
            fileDialog.setText("Choose diagram file");
            String fileName = fileDialog.open();
            Dimension preferredSize = contents.getPreferredSize();
            Image image = new Image((Device)Display.getDefault(), preferredSize.width + 40, preferredSize.height + 40);
            GC gc = new GC((Drawable)image);
            SWTGraphics graphics = new SWTGraphics(gc);
            graphics.translate(20, 20);
            graphics.translate(contents.getBounds().getLocation().getNegated());
            contents.paint((Graphics)graphics);
            ImageData imageData = image.getImageData();
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imageData};
            imageLoader.save(fileName, 5);
        }
    }
}

