/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelMergeOperation;

public final class MergeAllOperation
extends SynchronizationOperation {
    private final IMergeContext context;
    private final String jobName;

    public MergeAllOperation(String jobName, ISynchronizePageConfiguration configuration, Object[] elements, IMergeContext context) {
        super(configuration, elements);
        this.jobName = jobName;
        this.context = context;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        new ModelMergeOperation(this.getPart(), ((SynchronizationContext)this.context).getScopeManager()){

            @Override
            public boolean isPreviewRequested() {
                return false;
            }

            @Override
            protected void initializeContext(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(null, 10);
                monitor.done();
            }

            @Override
            protected ISynchronizationContext getContext() {
                return MergeAllOperation.this.context;
            }

            @Override
            protected void executeMerge(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(null, 100);
                if (!this.hasChangesOfInterest()) {
                    this.handleNoChanges();
                } else if (this.isPreviewRequested()) {
                    this.handlePreviewRequest();
                } else {
                    IStatus status = ModelMergeOperation.validateMerge(this.getMergeContext(), Policy.subMonitorFor(monitor, 10));
                    if (!status.isOK() && !this.promptToContinue(status)) {
                        return;
                    }
                    status = this.performMerge(Policy.subMonitorFor(monitor, 90));
                    if (!status.isOK()) {
                        this.handleMergeFailure(status);
                    }
                }
                monitor.done();
            }

            private IMergeContext getMergeContext() {
                return (IMergeContext)this.getContext();
            }

            private boolean promptToContinue(final IStatus status) {
                final boolean[] result = new boolean[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog dialog = new ErrorDialog(this.getShell(), TeamUIMessages.ModelMergeOperation_0, TeamUIMessages.ModelMergeOperation_1, status, 7){

                            protected void createButtonsForButtonBar(Composite parent) {
                                this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
                                this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
                                this.createDetailsButton(parent);
                            }

                            protected void buttonPressed(int id) {
                                if (id == 2) {
                                    super.buttonPressed(0);
                                } else if (id == 3) {
                                    super.buttonPressed(1);
                                }
                                super.buttonPressed(id);
                            }
                        };
                        int code = dialog.open();
                        result[0] = code == 0;
                    }
                };
                this.getShell().getDisplay().syncExec(runnable);
                return result[0];
            }
        }.run(monitor);
    }

    @Override
    protected boolean canRunAsJob() {
        return true;
    }

    @Override
    protected String getJobName() {
        return this.jobName;
    }
}

