/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.mojo;

import java.util.Collections;
import java.util.List;

public class MojoParameter {
    private String name;
    private String type;
    private boolean required;
    private String description;
    private String expression;
    private String defaultValue;
    private List<MojoParameter> nested;
    private boolean multiple;
    private boolean map;

    public MojoParameter(String name, String type, List<MojoParameter> parameters) {
        this.name = name;
        this.type = type;
        this.nested = parameters;
    }

    public MojoParameter(String name, String type, MojoParameter parameter) {
        this(name, type, Collections.singletonList(parameter));
    }

    public MojoParameter(String name, String type) {
        this(name, type, Collections.emptyList());
    }

    public MojoParameter multiple() {
        this.multiple = true;
        return this;
    }

    public MojoParameter map() {
        this.map = true;
        return this;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isMap() {
        return this.map;
    }

    public List<MojoParameter> getNestedParameters() {
        return this.nested == null ? Collections.emptyList() : Collections.unmodifiableList(this.nested);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return String.valueOf(this.name) + "{" + this.type + "}";
    }

    public MojoParameter getNestedParameter(String name) {
        MojoParameter param;
        List<MojoParameter> params = this.getNestedParameters();
        if (params.size() == 1 && (param = params.get(0)).isMultiple()) {
            return param;
        }
        for (MojoParameter p : params) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public MojoParameter getContainer(String[] path) {
        if (path == null || path.length == 0) {
            return this;
        }
        MojoParameter param = this;
        int i = 0;
        while (param != null && i < path.length) {
            param = param.getNestedParameter(path[i]);
            ++i;
        }
        if (param == null) {
            return null;
        }
        return param;
    }
}

