/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.manifest;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.osgi.framework.BundleException;

class ManifestChangerSingleton {
    private ManifestChanger _connection;

    public ManifestChangerSingleton(ManifestChanger connection) {
        this._connection = connection;
    }

    private Manifest getManifest() throws IOException, CoreException {
        return this._connection.getManifest();
    }

    public void apply() throws BundleException, IOException, CoreException {
        String bundleSymbolicNameHeader = "Bundle-SymbolicName";
        Attributes mainAttrs = this.getManifest().getMainAttributes();
        String value = null;
        for (Object entryName : mainAttrs.keySet()) {
            String header;
            if (entryName instanceof String) {
                header = (String)entryName;
                value = mainAttrs.getValue(header);
            } else if (entryName instanceof Attributes.Name) {
                header = ((Attributes.Name)entryName).toString();
                value = mainAttrs.getValue((Attributes.Name)entryName);
            } else {
                throw new BundleException("Unknown Main Attribute Key type: " + entryName.getClass() + " (" + entryName + ")");
            }
            if ("Bundle-SymbolicName".equals(header)) break;
        }
        if (value != null && !value.endsWith(";singleton:=true")) {
            this.getManifest().getMainAttributes().putValue("Bundle-SymbolicName", String.valueOf(value) + ";singleton:=true");
        }
    }
}

