/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.selection;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.elk.core.util.selection.SelectionIterator;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KPort;

public class DefaultSelectionIterator
extends SelectionIterator {
    private static final long serialVersionUID = 2945508835051993888L;
    private boolean addPorts;
    private boolean followEdgeDirection;

    public DefaultSelectionIterator(KEdge edge, boolean addPorts, boolean followEdgeDirection) {
        super(edge);
        this.addPorts = addPorts;
        this.followEdgeDirection = followEdgeDirection;
    }

    protected Iterator<? extends KGraphElement> getChildren(Object object) {
        if (this.visited == null) {
            this.visited = Sets.newHashSet();
        }
        if (object instanceof KEdge) {
            KPort port;
            KEdge edge = (KEdge)object;
            KPort kPort = port = this.followEdgeDirection ? edge.getTargetPort() : edge.getSourcePort();
            if (port == null || this.visited.contains(port)) {
                return Iterators.emptyIterator();
            }
            this.visited.add(port);
            UnmodifiableIterator resultEdges = Iterators.filter((Iterator)port.getEdges().iterator(), (Predicate)new Predicate<KEdge>(){

                public boolean apply(KEdge input) {
                    return DefaultSelectionIterator.this.followEdgeDirection ? port == input.getSourcePort() : port == input.getTargetPort();
                }
            });
            if (this.addPorts) {
                UnmodifiableIterator portIterator = Iterators.singletonIterator((Object)port);
                return Iterators.concat((Iterator)portIterator, (Iterator)resultEdges);
            }
            return resultEdges;
        }
        return Iterators.emptyIterator();
    }
}

