/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.adapters;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KLayoutData;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.util.nodespacing.LabelSide;
import org.eclipse.elk.core.util.nodespacing.Spacing;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.KPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

public final class KGraphAdapters {
    public static final PortComparator DEFAULT_PORTLIST_SORTER = new PortComparator();

    private KGraphAdapters() {
        throw new IllegalStateException("Private constructor instantiation! Bad!");
    }

    public static KGraphAdapter adapt(KNode graph) {
        return new KGraphAdapter(graph);
    }

    public static KNodeAdapter adaptSingleNode(KNode node) {
        return new KNodeAdapter(node);
    }

    private static abstract class AbstractKGraphElementAdapter<T extends KGraphElement>
    implements GraphAdapters.GraphElementAdapter<T> {
        private static final IProperty<Float> OFFSET_PROXY = new Property(CoreOptions.PORT_BORDER_OFFSET, (Object)Float.valueOf(0.0f));
        protected T element;
        protected KShapeLayout layout;
        private int id;

        protected AbstractKGraphElementAdapter(T element) {
            this.element = element;
            try {
                this.layout = (KShapeLayout)element.getData(KShapeLayout.class);
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException("Graph adapters are only supported for shape-full types.");
            }
        }

        @Override
        public <P> P getProperty(IProperty<P> prop) {
            if (prop.equals(CoreOptions.PORT_BORDER_OFFSET)) {
                return (P)this.layout.getProperty(OFFSET_PROXY);
            }
            return (P)this.layout.getProperty(prop);
        }

        @Override
        public KVector getPosition() {
            return new KVector(this.layout.getXpos(), this.layout.getYpos());
        }

        @Override
        public KVector getSize() {
            return new KVector(this.layout.getWidth(), this.layout.getHeight());
        }

        @Override
        public void setSize(KVector size) {
            this.layout.setWidth((float)size.x);
            this.layout.setHeight((float)size.y);
        }

        @Override
        public void setPosition(KVector pos) {
            this.layout.setXpos((float)pos.x);
            this.layout.setYpos((float)pos.y);
        }

        public Spacing.Insets getInsets() {
            KInsets kinsets = this.layout.getInsets();
            Spacing.Insets insets = new Spacing.Insets(kinsets.getTop(), kinsets.getLeft(), kinsets.getBottom(), kinsets.getRight());
            return insets;
        }

        public void setInsets(Spacing.Insets insets) {
            this.layout.getInsets().setLeft((float)insets.left);
            this.layout.getInsets().setTop((float)insets.top);
            this.layout.getInsets().setRight((float)insets.right);
            this.layout.getInsets().setBottom((float)insets.bottom);
        }

        public Spacing.Margins getMargin() {
            Spacing.Margins margins = (Spacing.Margins)this.layout.getProperty(CoreOptions.MARGINS);
            if (margins == null) {
                margins = new Spacing.Margins();
            }
            return margins;
        }

        public void setMargin(Spacing.Margins margin) {
            Spacing.Margins newMargin = new Spacing.Margins(margin);
            this.layout.setProperty(CoreOptions.MARGINS, newMargin);
        }

        @Override
        public int getVolatileId() {
            return this.id;
        }

        @Override
        public void setVolatileId(int volatileId) {
            this.id = volatileId;
        }
    }

    private static final class KEdgeAdapter
    implements GraphAdapters.EdgeAdapter<KEdge> {
        private KEdge element;
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;

        private KEdgeAdapter(KEdge edge) {
            this.element = edge;
        }

        @Override
        public Iterable<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithExpectedSize((int)this.element.getLabels().size());
                for (KLabel l : this.element.getLabels()) {
                    this.labelAdapters.add(new KLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }
    }

    public static final class KGraphAdapter
    extends AbstractKGraphElementAdapter<KNode>
    implements GraphAdapters.GraphAdapter<KNode> {
        private List<GraphAdapters.NodeAdapter<?>> childNodes = null;

        private KGraphAdapter(KNode node) {
            super(node);
        }

        @Override
        public Iterable<GraphAdapters.NodeAdapter<?>> getNodes() {
            if (this.childNodes == null) {
                this.childNodes = Lists.newArrayListWithExpectedSize((int)((KNode)this.element).getChildren().size());
                for (KNode n : ((KNode)this.element).getChildren()) {
                    this.childNodes.add(new KNodeAdapter(n));
                }
            }
            return this.childNodes;
        }
    }

    private static final class KLabelAdapter
    extends AbstractKGraphElementAdapter<KLabel>
    implements GraphAdapters.LabelAdapter<KLabel> {
        private KLabelAdapter(KLabel label) {
            super(label);
        }

        @Override
        public LabelSide getSide() {
            return (LabelSide)((Object)this.layout.getProperty(LabelSide.LABEL_SIDE));
        }
    }

    public static final class KNodeAdapter
    extends AbstractKGraphElementAdapter<KNode>
    implements GraphAdapters.NodeAdapter<KNode> {
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;
        private List<GraphAdapters.PortAdapter<?>> portAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> incomingEdgeAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> outgoingEdgeAdapters = null;

        private KNodeAdapter(KNode node) {
            super(node);
        }

        @Override
        public List<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithExpectedSize((int)((KNode)this.element).getLabels().size());
                for (KLabel l : ((KNode)this.element).getLabels()) {
                    this.labelAdapters.add(new KLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }

        @Override
        public List<GraphAdapters.PortAdapter<?>> getPorts() {
            if (this.portAdapters == null) {
                this.portAdapters = Lists.newArrayListWithExpectedSize((int)((KNode)this.element).getPorts().size());
                for (KPort p : ((KNode)this.element).getPorts()) {
                    this.portAdapters.add(new KPortAdapter(p));
                }
            }
            return this.portAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getIncomingEdges() {
            if (this.incomingEdgeAdapters == null) {
                this.incomingEdgeAdapters = Lists.newArrayListWithExpectedSize((int)((KNode)this.element).getIncomingEdges().size());
                for (KEdge e : ((KNode)this.element).getIncomingEdges()) {
                    this.incomingEdgeAdapters.add(new KEdgeAdapter(e));
                }
            }
            return this.incomingEdgeAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getOutgoingEdges() {
            if (this.outgoingEdgeAdapters == null) {
                this.outgoingEdgeAdapters = Lists.newArrayListWithExpectedSize((int)((KNode)this.element).getOutgoingEdges().size());
                for (KEdge e : ((KNode)this.element).getOutgoingEdges()) {
                    this.outgoingEdgeAdapters.add(new KEdgeAdapter(e));
                }
            }
            return this.outgoingEdgeAdapters;
        }

        @Override
        public void sortPortList() {
            this.sortPortList(DEFAULT_PORTLIST_SORTER);
        }

        @Override
        public void sortPortList(Comparator<?> comparator) {
            KLayoutData layout = (KLayoutData)((KNode)this.element).getData(KLayoutData.class);
            if (((PortConstraints)((Object)layout.getProperty(CoreOptions.PORT_CONSTRAINTS))).isOrderFixed()) {
                ECollections.sort((EList)((KNode)this.element).getPorts(), comparator);
            }
        }

        @Override
        public boolean isCompoundNode() {
            return !((KNode)this.element).getChildren().isEmpty();
        }
    }

    private static final class KPortAdapter
    extends AbstractKGraphElementAdapter<KPort>
    implements GraphAdapters.PortAdapter<KPort> {
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> incomingEdgeAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> outgoingEdgeAdapters = null;

        private KPortAdapter(KPort port) {
            super(port);
        }

        @Override
        public PortSide getSide() {
            return (PortSide)((Object)this.layout.getProperty(CoreOptions.PORT_SIDE));
        }

        @Override
        public List<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithExpectedSize((int)((KPort)this.element).getLabels().size());
                for (KLabel l : ((KPort)this.element).getLabels()) {
                    this.labelAdapters.add(new KLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getIncomingEdges() {
            if (this.incomingEdgeAdapters == null) {
                this.incomingEdgeAdapters = Lists.newArrayListWithCapacity((int)((KPort)this.element).getEdges().size());
                for (KEdge e : ((KPort)this.element).getEdges()) {
                    if (!e.getTarget().equals(this.element)) continue;
                    this.incomingEdgeAdapters.add(new KEdgeAdapter(e));
                }
            }
            return this.incomingEdgeAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getOutgoingEdges() {
            if (this.outgoingEdgeAdapters == null) {
                this.outgoingEdgeAdapters = Lists.newArrayListWithCapacity((int)((KPort)this.element).getEdges().size());
                for (KEdge e : ((KPort)this.element).getEdges()) {
                    if (!e.getSource().equals(this.element)) continue;
                    this.outgoingEdgeAdapters.add(new KEdgeAdapter(e));
                }
            }
            return this.outgoingEdgeAdapters;
        }

        @Override
        public boolean hasCompoundConnections() {
            KNode node = ((KPort)this.element).getNode();
            for (KEdge edge : ((KPort)this.element).getEdges()) {
                if (!(edge.getSource() == node ? ElkUtil.isDescendant(edge.getTarget(), node) : ElkUtil.isDescendant(edge.getSource(), node))) continue;
                return true;
            }
            return false;
        }
    }

    public static class PortComparator
    implements Comparator<KPort> {
        @Override
        public int compare(KPort port1, KPort port2) {
            int indexDifference;
            KShapeLayout layout1 = (KShapeLayout)port1.getData(KShapeLayout.class);
            KShapeLayout layout2 = (KShapeLayout)port2.getData(KShapeLayout.class);
            int ordinalDifference = ((PortSide)((Object)layout1.getProperty(CoreOptions.PORT_SIDE))).ordinal() - ((PortSide)((Object)layout2.getProperty(CoreOptions.PORT_SIDE))).ordinal();
            if (ordinalDifference != 0) {
                return ordinalDifference;
            }
            Integer index1 = (Integer)layout1.getProperty(CoreOptions.PORT_INDEX);
            Integer index2 = (Integer)layout2.getProperty(CoreOptions.PORT_INDEX);
            if (index1 != null && index2 != null && (indexDifference = index1 - index2) != 0) {
                return indexDifference;
            }
            switch ((PortSide)((Object)layout1.getProperty(CoreOptions.PORT_SIDE))) {
                case NORTH: {
                    return Double.compare(layout1.getXpos(), layout2.getXpos());
                }
                case EAST: {
                    return Double.compare(layout1.getYpos(), layout2.getYpos());
                }
                case SOUTH: {
                    return Double.compare(layout2.getXpos(), layout1.getXpos());
                }
                case WEST: {
                    return Double.compare(layout2.getYpos(), layout1.getYpos());
                }
            }
            throw new IllegalStateException("Port side is undefined");
        }
    }
}

