/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import java.util.Iterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.BetweenLayerEdgeAllCrossingsCounter;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public class BetweenLayerStraightEdgeAllCrossingsCounter
extends BetweenLayerEdgeAllCrossingsCounter {
    public BetweenLayerStraightEdgeAllCrossingsCounter(LNode[][] nodeOrder) {
        super(nodeOrder);
    }

    @Override
    public int countCrossings(LNode[] leftLayer, LNode[] rightLayer) {
        int targetCount = 0;
        int edgeCount = 0;
        Layer leftLayerRef = leftLayer[0].getLayer();
        Layer rightLayerRef = rightLayer[0].getLayer();
        LNode[] lNodeArray = rightLayer;
        int n = rightLayer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            assert (node.getLayer() == rightLayerRef);
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                int northInputPorts = 0;
                block1: for (LPort port : node.getPorts()) {
                    if (port.getSide() != PortSide.NORTH) break;
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (lEdge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++northInputPorts;
                        continue block1;
                    }
                }
                int otherInputPorts = 0;
                Iterator<LPort> portIter = node.getPorts().listIterator(node.getPorts().size());
                while (portIter.hasPrevious()) {
                    LPort lPort = (LPort)((Object)portIter.previous());
                    int portEdges = 0;
                    for (LEdge edge : lPort.getIncomingEdges()) {
                        if (edge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++portEdges;
                    }
                    if (portEdges <= 0) continue;
                    if (lPort.getSide() == PortSide.NORTH) {
                        this.getPortPos()[lPort.id] = targetCount++;
                    } else {
                        this.getPortPos()[lPort.id] = targetCount + northInputPorts + otherInputPorts;
                        ++otherInputPorts;
                    }
                    edgeCount += portEdges;
                }
                targetCount += otherInputPorts;
            } else {
                int nodeEdges = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (lEdge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++nodeEdges;
                    }
                    this.getPortPos()[port.id] = targetCount;
                }
                if (nodeEdges > 0) {
                    ++targetCount;
                    edgeCount += nodeEdges;
                }
            }
            ++n2;
        }
        int[] southSequence = new int[edgeCount];
        int i = 0;
        LNode[] lNodeArray2 = leftLayer;
        int n3 = leftLayer.length;
        int n4 = 0;
        while (n4 < n3) {
            LPort target;
            LNode node = lNodeArray2[n4];
            assert (node.getLayer() == leftLayerRef);
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort port : node.getPorts()) {
                    int start = i;
                    for (LEdge edge : port.getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (target.getNode().getLayer() != rightLayerRef) continue;
                        assert (i < edgeCount);
                        BetweenLayerStraightEdgeAllCrossingsCounter.insert(southSequence, start, i++, this.getPortPos()[target.id]);
                    }
                }
            } else {
                int start = i;
                for (LPort lPort : node.getPorts()) {
                    for (LEdge edge : lPort.getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (target.getNode().getLayer() != rightLayerRef) continue;
                        assert (i < edgeCount);
                        BetweenLayerStraightEdgeAllCrossingsCounter.insert(southSequence, start, i++, this.getPortPos()[target.id]);
                    }
                }
            }
            ++n4;
        }
        int crossCount = this.buildAccumulatorTreeAndCountCrossings(targetCount, edgeCount, southSequence);
        return crossCount;
    }

    private int buildAccumulatorTreeAndCountCrossings(int targetCount, int edgeCount, int[] southSequence) {
        int firstIndex = 1;
        while (firstIndex < targetCount) {
            firstIndex *= 2;
        }
        int treeSize = 2 * firstIndex - 1;
        --firstIndex;
        int[] tree = new int[treeSize];
        int crossCount = 0;
        int k = 0;
        while (k < edgeCount) {
            int index;
            int n = index = southSequence[k] + firstIndex;
            tree[n] = tree[n] + 1;
            while (index > 0) {
                if (index % 2 > 0) {
                    crossCount += tree[index + 1];
                }
                int n2 = index = (index - 1) / 2;
                tree[n2] = tree[n2] + 1;
            }
            ++k;
        }
        return crossCount;
    }

    private static void insert(int[] array, int start, int end, int n) {
        int insx = BetweenLayerStraightEdgeAllCrossingsCounter.binarySearch(array, start, end, n);
        if (insx < 0) {
            insx = -insx - 1;
        }
        int j = end - 1;
        while (j >= insx) {
            array[j + 1] = array[j];
            --j;
        }
        array[insx] = n;
    }

    private static int binarySearch(int[] array, int start, int end, int n) {
        int currentStart = start;
        int currentEnd = end - 1;
        while (currentStart <= currentEnd) {
            int index = (currentStart + currentEnd) / 2;
            if (array[index] == n) {
                return index;
            }
            if (array[index] < n) {
                currentStart = index + 1;
                continue;
            }
            currentEnd = index - 1;
        }
        return -currentStart - 1;
    }
}

