/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class PortListSorter
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Port order processing", 1.0f);
        PortComparator portComparator = new PortComparator();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (!((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) continue;
                Collections.sort(node.getPorts(), portComparator);
            }
        }
        monitor.done();
    }

    public static class PortComparator
    implements Comparator<LPort> {
        @Override
        public int compare(LPort port1, LPort port2) {
            PortConstraints port1Constraint = (PortConstraints)port1.getNode().getProperty(LayeredOptions.PORT_CONSTRAINTS);
            int ordinalDifference = port1.getSide().ordinal() - port2.getSide().ordinal();
            if (ordinalDifference != 0 || port1Constraint == PortConstraints.FIXED_SIDE) {
                return ordinalDifference;
            }
            if (port1Constraint == PortConstraints.FIXED_ORDER) {
                int indexDifference;
                Integer index1 = (Integer)port1.getProperty(LayeredOptions.PORT_INDEX);
                Integer index2 = (Integer)port2.getProperty(LayeredOptions.PORT_INDEX);
                if (index1 != null && index2 != null && (indexDifference = index1 - index2) != 0) {
                    return indexDifference;
                }
            }
            switch (port1.getSide()) {
                case NORTH: {
                    return Double.compare(port1.getPosition().x, port2.getPosition().x);
                }
                case EAST: {
                    return Double.compare(port1.getPosition().y, port2.getPosition().y);
                }
                case SOUTH: {
                    return Double.compare(port2.getPosition().x, port1.getPosition().x);
                }
                case WEST: {
                    return Double.compare(port2.getPosition().y, port1.getPosition().y);
                }
            }
            throw new IllegalStateException("Port side is undefined");
        }
    }
}

