/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.model;

import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.graph.FParticle;
import org.eclipse.elk.alg.force.model.AbstractForceModel;
import org.eclipse.elk.alg.force.properties.ForceOptions;
import org.eclipse.elk.core.math.KVector;

public final class EadesModel
extends AbstractForceModel {
    private static final double ZERO_FACTOR = 100.0;
    private int maxIterations = (Integer)ForceOptions.ITERATIONS.getDefault();
    private double springLength = ((Float)ForceOptions.SPACING_NODE.getDefault()).floatValue();
    private double repulsionFactor = ((Float)ForceOptions.REPULSION.getDefault()).floatValue();

    @Override
    protected void initialize(FGraph graph) {
        super.initialize(graph);
        this.maxIterations = (Integer)graph.getProperty(ForceOptions.ITERATIONS);
        this.springLength = ((Float)graph.getProperty(ForceOptions.SPACING_NODE)).doubleValue();
        this.repulsionFactor = ((Float)graph.getProperty(ForceOptions.REPULSION)).doubleValue();
    }

    @Override
    protected boolean moreIterations(int count) {
        return count < this.maxIterations;
    }

    @Override
    protected KVector calcDisplacement(FParticle forcer, FParticle forcee) {
        EadesModel.avoidSamePosition(this.getRandom(), forcer, forcee);
        KVector displacement = forcee.getPosition().clone().sub(forcer.getPosition());
        double length = displacement.length();
        double d = Math.max(0.0, length - forcer.getRadius() - forcee.getRadius());
        int connection = this.getGraph().getConnection(forcer, forcee);
        double force = connection > 0 ? -EadesModel.attractive(d, this.springLength) * (double)connection : EadesModel.repulsive(d, this.repulsionFactor) * (double)((Integer)forcer.getProperty(ForceOptions.PRIORITY)).intValue();
        displacement.scale(force / length);
        return displacement;
    }

    private static double repulsive(double d, double r) {
        if (d > 0.0) {
            return r / (d * d);
        }
        return r * 100.0;
    }

    public static double attractive(double d, double s) {
        if (d > 0.0) {
            return Math.log(d / s);
        }
        return -100.0;
    }
}

