/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.indexer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.IClassFile;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.IParent;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementDelta;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModel;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.nd.IReader;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.indexer.ClassFileToIndexConverter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.indexer.IndexTester;
import org.aspectj.org.eclipse.jdt.internal.core.nd.indexer.IndexerEvent;
import org.aspectj.org.eclipse.jdt.internal.core.nd.indexer.Messages;
import org.aspectj.org.eclipse.jdt.internal.core.nd.indexer.Package;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.FileFingerprint;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdBinding;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdWorkspaceLocation;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.TypeRef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeDescriptor;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeFactory;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryType;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;

public final class Indexer {
    private Nd nd;
    private IWorkspaceRoot root;
    private static Indexer indexer;
    public static boolean DEBUG;
    public static boolean DEBUG_ALLOCATIONS;
    public static boolean DEBUG_TIMING;
    public static boolean DEBUG_INSERTIONS;
    public static boolean DEBUG_SELFTEST;
    private boolean enableAutomaticIndexing = true;
    private boolean indexerDirtiedWhileDisabled = false;
    private final Object automaticIndexingMutex = new Object();
    public static boolean EXPERIMENTAL_INDEX_OUTPUT_FOLDERS;
    private static final Object mutex;
    private static final long MS_TO_NS = 1000000L;
    private Object listenersMutex = new Object();
    private Set<Listener> listeners = Collections.newSetFromMap(new WeakHashMap());
    private JobGroup group = new JobGroup(Messages.Indexer_updating_index_job_name, 1, 1);
    private Job rescanJob = Job.create((String)Messages.Indexer_updating_index_job_name, monitor -> this.rescan(monitor));
    private Job rebuildIndexJob = Job.create((String)Messages.Indexer_updating_index_job_name, monitor -> this.rebuildIndex(monitor));

    static {
        mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Indexer getInstance() {
        Object object = mutex;
        synchronized (object) {
            if (indexer == null) {
                indexer = new Indexer(JavaIndex.getGlobalNd(), ResourcesPlugin.getWorkspace().getRoot());
            }
            return indexer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAutomaticIndexing(boolean enabled) {
        boolean runRescan = false;
        Object object = this.automaticIndexingMutex;
        synchronized (object) {
            if (this.enableAutomaticIndexing == enabled) {
                return;
            }
            this.enableAutomaticIndexing = enabled;
            if (enabled && this.indexerDirtiedWhileDisabled) {
                runRescan = true;
            }
        }
        if (runRescan) {
            this.rescanJob.schedule();
        }
        if (!enabled) {
            try {
                this.rescanJob.join(0L, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
        }
    }

    private static long getGarbageCleanupTimeout() {
        return Platform.getPreferencesService().getLong("org.aspectj.org.eclipse.jdt.core", "garbageCleanupTimeoutMs", 259200000L, null);
    }

    private static long getUsageTimestampUpdatePeriod() {
        return Indexer.getGarbageCleanupTimeout() / 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescan(IProgressMonitor monitor) throws CoreException {
        double averageResourceMappingMs;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Object object = this.automaticIndexingMutex;
        synchronized (object) {
            this.indexerDirtiedWhileDisabled = false;
        }
        long startTimeNs = System.nanoTime();
        long currentTimeMs = System.currentTimeMillis();
        if (DEBUG) {
            Package.logInfo("Indexer running rescan");
        }
        List<IJavaElement> unfilteredIndexables = this.getAllIndexableObjectsInWorkspace((IProgressMonitor)subMonitor.split(3));
        int totalIndexables = unfilteredIndexables.size();
        Map<IPath, List<IJavaElement>> allIndexables = this.removeDuplicatePaths(unfilteredIndexables);
        long startGarbageCollectionNs = System.nanoTime();
        int gcFiles = this.cleanGarbage(currentTimeMs, allIndexables.keySet(), (IProgressMonitor)subMonitor.split(4));
        long startFingerprintTestNs = System.nanoTime();
        Map<IPath, FileFingerprint.FingerprintTestResult> fingerprints = this.testFingerprints(allIndexables.keySet(), (IProgressMonitor)subMonitor.split(7));
        HashSet<IPath> indexablesWithChanges = new HashSet<IPath>(this.getIndexablesThatHaveChanged(allIndexables.keySet(), fingerprints));
        long startIndexingNs = System.nanoTime();
        int classesIndexed = 0;
        SubMonitor loopMonitor = subMonitor.split(80).setWorkRemaining(indexablesWithChanges.size());
        for (IPath next : indexablesWithChanges) {
            classesIndexed += this.rescanArchive(currentTimeMs, next, allIndexables.get(next), fingerprints.get(next).getNewFingerprint(), (IProgressMonitor)loopMonitor.split(1));
        }
        long endIndexingNs = System.nanoTime();
        HashMap<IPath, List<IJavaElement>> pathsToUpdate = new HashMap<IPath, List<IJavaElement>>();
        for (IPath next : allIndexables.keySet()) {
            if (indexablesWithChanges.contains(next)) continue;
            pathsToUpdate.put(next, allIndexables.get(next));
        }
        this.updateResourceMappings(pathsToUpdate, (IProgressMonitor)subMonitor.split(5));
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(4));
        try {
            this.nd.getDB().flush();
        }
        finally {
            this.nd.releaseWriteLock();
        }
        this.fireDelta(indexablesWithChanges, (IProgressMonitor)subMonitor.split(1));
        if (DEBUG) {
            Package.logInfo("Rescan finished");
        }
        long endResourceMappingNs = System.nanoTime();
        long fingerprintTimeMs = (startIndexingNs - startFingerprintTestNs) / 1000000L;
        long locateIndexablesTimeMs = (startGarbageCollectionNs - startTimeNs) / 1000000L;
        long garbageCollectionMs = (startFingerprintTestNs - startGarbageCollectionNs) / 1000000L;
        long indexingTimeMs = (endIndexingNs - startIndexingNs) / 1000000L;
        long resourceMappingTimeMs = (endResourceMappingNs - endIndexingNs) / 1000000L;
        double averageGcTimeMs = gcFiles == 0 ? 0.0 : (double)garbageCollectionMs / (double)gcFiles;
        double averageIndexTimeMs = classesIndexed == 0 ? 0.0 : (double)indexingTimeMs / (double)classesIndexed;
        double averageFingerprintTimeMs = allIndexables.size() == 0 ? 0.0 : (double)fingerprintTimeMs / (double)allIndexables.size();
        double d = averageResourceMappingMs = pathsToUpdate.size() == 0 ? 0.0 : (double)resourceMappingTimeMs / (double)pathsToUpdate.size();
        if (DEBUG_TIMING) {
            Package.logInfo("Indexing done.\n  Located " + totalIndexables + " indexables in " + locateIndexablesTimeMs + "ms\n" + "  Collected garbage from " + gcFiles + " files in " + garbageCollectionMs + "ms, average time = " + averageGcTimeMs + "ms\n" + "  Tested " + allIndexables.size() + " fingerprints in " + fingerprintTimeMs + "ms, average time = " + averageFingerprintTimeMs + "ms\n" + "  Indexed " + classesIndexed + " classes in " + indexingTimeMs + "ms, average time = " + averageIndexTimeMs + "ms\n" + "  Updated " + pathsToUpdate.size() + " paths in " + resourceMappingTimeMs + "ms, average time = " + averageResourceMappingMs + "ms\n");
        }
        if (DEBUG_ALLOCATIONS) {
            Throwable throwable = null;
            Object var45_36 = null;
            try (IReader readLock = this.nd.acquireReadLock();){
                this.nd.getDB().reportFreeBlocks();
                this.nd.getDB().getMemoryStats().printMemoryStats(this.nd.getTypeRegistry());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void fireDelta(Set<IPath> indexablesWithChanges, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IProject[] projects = this.root.getProjects();
        ArrayList<IProject> projectsToScan = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject next = iProjectArray[n2];
            if (next.isOpen()) {
                projectsToScan.add(next);
            }
            ++n2;
        }
        JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
        boolean hasChanges = false;
        JavaElementDelta delta = new JavaElementDelta(model);
        SubMonitor projectLoopMonitor = subMonitor.split(1).setWorkRemaining(projectsToScan.size());
        for (IProject project : projectsToScan) {
            projectLoopMonitor.split(1);
            try {
                IPackageFragmentRoot[] roots;
                if (!project.isOpen() || !project.isNatureEnabled("org.aspectj.org.eclipse.jdt.core.javanature")) continue;
                IJavaProject javaProject = JavaCore.create(project);
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
                int n3 = roots.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath location;
                    IPackageFragmentRoot next = iPackageFragmentRootArray[n4];
                    if (next.isArchive() && indexablesWithChanges.contains(location = JavaIndex.getLocationForElement(next))) {
                        hasChanges = true;
                        delta.changed(next, 32769);
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                Package.log(e);
            }
        }
        if (hasChanges) {
            this.fireChange(IndexerEvent.createChange(delta));
        }
    }

    private void updateResourceMappings(Map<IPath, List<IJavaElement>> pathsToUpdate, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)pathsToUpdate.keySet().size());
        JavaIndex index = JavaIndex.getIndex(this.nd);
        for (Map.Entry<IPath, List<IJavaElement>> entry : pathsToUpdate.entrySet()) {
            SubMonitor iterationMonitor = subMonitor.split(1).setWorkRemaining(10);
            this.nd.acquireWriteLock((IProgressMonitor)iterationMonitor.split(1));
            try {
                NdResourceFile resourceFile = index.getResourceFile(entry.getKey().toString().toCharArray());
                if (resourceFile == null) continue;
                this.attachWorkspaceFilesToResource(entry.getValue(), resourceFile);
            }
            finally {
                this.nd.releaseWriteLock();
            }
        }
    }

    private int cleanGarbage(long currentTimeMillis, Collection<IPath> allIndexables, IProgressMonitor monitor) {
        JavaIndex index = JavaIndex.getIndex(this.nd);
        int result = 0;
        HashSet<IPath> paths = new HashSet<IPath>();
        paths.addAll(allIndexables);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ArrayList<NdResourceFile> garbage = new ArrayList<NdResourceFile>();
        ArrayList<NdResourceFile> needsUpdate = new ArrayList<NdResourceFile>();
        long usageTimestampUpdatePeriod = Indexer.getUsageTimestampUpdatePeriod();
        long garbageCleanupTimeout = Indexer.getGarbageCleanupTimeout();
        Throwable throwable = null;
        Object var16_14 = null;
        try (IReader reader = this.nd.acquireReadLock();){
            List<NdResourceFile> resourceFiles = index.getAllResourceFiles();
            result = resourceFiles.size();
            SubMonitor testMonitor = subMonitor.split(1).setWorkRemaining(resourceFiles.size());
            for (NdResourceFile next : resourceFiles) {
                testMonitor.split(1);
                if (!next.isDoneIndexing()) {
                    garbage.add(next);
                    continue;
                }
                Path nextPath = new Path(next.getLocation().toString());
                long timeLastUsed = next.getTimeLastUsed();
                long timeSinceLastUsed = currentTimeMillis - timeLastUsed;
                if (paths.contains(nextPath)) {
                    if (timeSinceLastUsed <= usageTimestampUpdatePeriod) continue;
                    needsUpdate.add(next);
                    continue;
                }
                if (timeSinceLastUsed <= garbageCleanupTimeout) continue;
                garbage.add(next);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SubMonitor deleteMonitor = subMonitor.split(1).setWorkRemaining(garbage.size());
        for (NdResourceFile next : garbage) {
            this.deleteResource(next, (IProgressMonitor)deleteMonitor.split(1));
        }
        SubMonitor updateMonitor = subMonitor.split(1).setWorkRemaining(needsUpdate.size());
        for (NdResourceFile next : needsUpdate) {
            this.nd.acquireWriteLock((IProgressMonitor)updateMonitor.split(1));
            try {
                if (!next.isInIndex()) continue;
                next.setTimeLastUsed(currentTimeMillis);
            }
            finally {
                this.nd.releaseWriteLock();
            }
        }
        return result;
    }

    protected void deleteResource(NdResourceFile toDelete, IProgressMonitor monitor) {
        SubMonitor deletionMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        this.nd.acquireWriteLock((IProgressMonitor)deletionMonitor.split(1));
        try {
            if (toDelete.isInIndex()) {
                toDelete.markAsInvalid();
            }
        }
        finally {
            this.nd.releaseWriteLock();
        }
        while (true) {
            this.nd.acquireWriteLock((IProgressMonitor)deletionMonitor.split(1));
            try {
                if (!toDelete.isInIndex()) break;
                int numChildren = toDelete.getBindingCount();
                deletionMonitor.setWorkRemaining(numChildren + 1);
                if (numChildren == 0) break;
                NdBinding nextDeletion = toDelete.getBinding(numChildren - 1);
                if (DEBUG_INSERTIONS && nextDeletion instanceof NdType) {
                    NdType type = (NdType)nextDeletion;
                    Package.logInfo("Deleting " + type.getTypeId().getFieldDescriptor().getString() + " from " + new String(toDelete.getLocation().getString()) + " " + toDelete.address);
                }
                nextDeletion.delete();
                continue;
            }
            finally {
                this.nd.releaseWriteLock();
                continue;
            }
            break;
        }
        this.nd.acquireWriteLock((IProgressMonitor)deletionMonitor.split(1));
        try {
            if (toDelete.isInIndex()) {
                toDelete.delete();
            }
        }
        finally {
            this.nd.releaseWriteLock();
        }
    }

    private Map<IPath, List<IJavaElement>> removeDuplicatePaths(List<IJavaElement> allIndexables) {
        HashMap<IPath, List<IJavaElement>> paths = new HashMap<IPath, List<IJavaElement>>();
        HashSet<IPath> workspacePaths = new HashSet<IPath>();
        for (IJavaElement next : allIndexables) {
            IPath nextPath = JavaIndex.getLocationForElement(next);
            IPath workspacePath = this.getWorkspacePathForRoot(next);
            ArrayList<IJavaElement> value = (ArrayList<IJavaElement>)paths.get(nextPath);
            if (value == null) {
                value = new ArrayList<IJavaElement>();
                paths.put(nextPath, value);
            } else if (workspacePath != null) {
                if (workspacePaths.contains(workspacePath)) continue;
                if (!workspacePath.isEmpty()) {
                    Package.logInfo("Found duplicate workspace path for " + workspacePath.toString());
                }
                workspacePaths.add(workspacePath);
            }
            value.add(next);
        }
        return paths;
    }

    private IPath getWorkspacePathForRoot(IJavaElement next) {
        IResource resource = next.getResource();
        if (resource != null) {
            return resource.getFullPath();
        }
        return Path.EMPTY;
    }

    private Map<IPath, FileFingerprint.FingerprintTestResult> testFingerprints(Collection<IPath> allIndexables, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)allIndexables.size());
        HashMap<IPath, FileFingerprint.FingerprintTestResult> result = new HashMap<IPath, FileFingerprint.FingerprintTestResult>();
        for (IPath next : allIndexables) {
            result.put(next, this.testForChanges(next, (IProgressMonitor)subMonitor.split(1)));
        }
        return result;
    }

    private int rescanArchive(long currentTimeMillis, IPath thePath, List<IJavaElement> elementsMappingOntoLocation, FileFingerprint fingerprint, IProgressMonitor monitor) throws JavaModelException {
        NdResourceFile resourceFile;
        if (elementsMappingOntoLocation.isEmpty()) {
            return 0;
        }
        IJavaElement element = elementsMappingOntoLocation.get(0);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String pathString = thePath.toString();
        JavaIndex javaIndex = JavaIndex.getIndex(this.nd);
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(5));
        try {
            resourceFile = new NdResourceFile(this.nd);
            resourceFile.setTimeLastUsed(currentTimeMillis);
            resourceFile.setLocation(pathString);
            IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element.getAncestor(3);
            IPath rootPathString = JavaIndex.getLocationForElement(packageFragmentRoot);
            if (!rootPathString.equals((Object)thePath)) {
                resourceFile.setPackageFragmentRoot(rootPathString.toString().toCharArray());
            }
            this.attachWorkspaceFilesToResource(elementsMappingOntoLocation, resourceFile);
        }
        finally {
            this.nd.releaseWriteLock();
        }
        if (DEBUG) {
            Package.logInfo("rescanning " + thePath.toString() + ", " + fingerprint);
        }
        int result = 0;
        try {
            if (fingerprint.fileExists()) {
                result = this.addElement(resourceFile, element, (IProgressMonitor)subMonitor.split(50));
            }
        }
        catch (JavaModelException e) {
            if (DEBUG) {
                Package.log("the file " + pathString + " cannot be indexed due to a recoverable error", null);
            }
            this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(5));
            try {
                if (resourceFile.isInIndex()) {
                    resourceFile.delete();
                }
            }
            finally {
                this.nd.releaseWriteLock();
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (DEBUG) {
                Package.log("A RuntimeException occurred while indexing " + pathString, e);
            }
            throw e;
        }
        catch (FileNotFoundException e) {
            fingerprint = FileFingerprint.getEmpty();
        }
        if (DEBUG && !fingerprint.fileExists()) {
            Package.log("the file " + pathString + " was not indexed because it does not exist", null);
        }
        List<Object> allResourcesWithThisPath = Collections.emptyList();
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(1));
        try {
            if (resourceFile.isInIndex()) {
                resourceFile.setFingerprint(fingerprint);
                allResourcesWithThisPath = javaIndex.findResourcesWithPath(pathString);
            }
        }
        finally {
            this.nd.releaseWriteLock();
        }
        SubMonitor deletionMonitor = subMonitor.split(40).setWorkRemaining(allResourcesWithThisPath.size() - 1);
        for (NdResourceFile ndResourceFile : allResourcesWithThisPath) {
            if (ndResourceFile.equals(resourceFile)) continue;
            this.deleteResource(ndResourceFile, (IProgressMonitor)deletionMonitor.split(1));
        }
        return result;
    }

    private void attachWorkspaceFilesToResource(List<IJavaElement> elementsMappingOntoLocation, NdResourceFile resourceFile) {
        for (IJavaElement next : elementsMappingOntoLocation) {
            IResource nextResource = next.getResource();
            if (nextResource == null) continue;
            new NdWorkspaceLocation(this.nd, resourceFile, nextResource.getFullPath().toString().toCharArray());
        }
    }

    private int addElement(NdResourceFile resourceFile, IJavaElement element, IProgressMonitor monitor) throws JavaModelException, FileNotFoundException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (element instanceof JarPackageFragmentRoot) {
            JarPackageFragmentRoot jarRoot = (JarPackageFragmentRoot)element;
            IPath workspacePath = jarRoot.getPath();
            IPath location = JavaIndex.getLocationForElement(jarRoot);
            int classesIndexed = 0;
            try {
                Throwable throwable = null;
                Object var10_21 = null;
                try (ZipFile zipFile = new ZipFile(JavaModelManager.getLocalFile(jarRoot.getPath()));){
                    if (JavaModelManager.throwIoExceptionsInGetZipFile) {
                        if (DEBUG) {
                            Package.logInfo("Throwing simulated IOException for error handling test case");
                        }
                        throw new IOException();
                    }
                    subMonitor.setWorkRemaining(zipFile.size());
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        SubMonitor nextEntry = subMonitor.split(1).setWorkRemaining(2);
                        ZipEntry member = e.nextElement();
                        if (member.isDirectory()) continue;
                        nextEntry.split(1);
                        String fileName = member.getName();
                        boolean classFileName = Util.isClassFileName(fileName);
                        if (!classFileName) continue;
                        String binaryName = fileName.substring(0, fileName.length() - ".class".length());
                        char[] fieldDescriptor = JavaNames.binaryNameToFieldDescriptor(binaryName.toCharArray());
                        String indexPath = String.valueOf(jarRoot.getHandleIdentifier()) + '|' + binaryName;
                        BinaryTypeDescriptor descriptor = new BinaryTypeDescriptor(location.toString().toCharArray(), fieldDescriptor, workspacePath.toString().toCharArray(), indexPath.toCharArray());
                        try {
                            byte[] contents = Util.getZipEntryByteContent(member, zipFile);
                            ClassFileReader classFileReader = new ClassFileReader(contents, descriptor.indexPath, true);
                            if (!this.addClassToIndex(resourceFile, descriptor.fieldDescriptor, descriptor.indexPath, classFileReader, (IProgressMonitor)nextEntry.split(1))) continue;
                            ++classesIndexed;
                        }
                        catch (ClassFormatException | CoreException exception) {
                            Package.log("Unable to index " + descriptor.toString(), exception);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ZipException e) {
                Package.log("The zip file " + jarRoot.getPath() + " was corrupt", e);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException ioException) {
                throw new JavaModelException(ioException, 985);
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
            if (DEBUG && classesIndexed == 0) {
                Package.logInfo("The path " + element.getPath() + " contained no class files");
            }
            return classesIndexed;
        }
        if (element instanceof IClassFile) {
            IClassFile classFile = (IClassFile)element;
            SubMonitor iterationMonitor = subMonitor.split(1);
            BinaryTypeDescriptor descriptor = BinaryTypeFactory.createDescriptor(classFile);
            boolean indexed = false;
            try {
                ClassFileReader classFileReader = BinaryTypeFactory.rawReadTypeTestForExists(descriptor, true, false);
                if (classFileReader != null) {
                    indexed = this.addClassToIndex(resourceFile, descriptor.fieldDescriptor, descriptor.indexPath, classFileReader, (IProgressMonitor)iterationMonitor);
                }
            }
            catch (ClassFormatException | CoreException e) {
                Package.log("Unable to index " + classFile.toString(), e);
            }
            return indexed ? 1 : 0;
        }
        Package.logInfo("Unable to index elements of type " + element);
        return 0;
    }

    private boolean addClassToIndex(NdResourceFile resourceFile, char[] fieldDescriptor, char[] indexPath, ClassFileReader binaryType, IProgressMonitor monitor) throws ClassFormatException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ClassFileToIndexConverter converter = new ClassFileToIndexConverter(resourceFile);
        boolean indexed = false;
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(5));
        try {
            if (resourceFile.isInIndex()) {
                if (DEBUG_INSERTIONS) {
                    Package.logInfo("Inserting " + new String(fieldDescriptor) + " into " + resourceFile.getLocation().getString() + " " + resourceFile.address);
                }
                converter.addType(binaryType, fieldDescriptor, (IProgressMonitor)subMonitor.split(45));
                indexed = true;
            }
        }
        finally {
            this.nd.releaseWriteLock();
        }
        if (DEBUG_SELFTEST && indexed) {
            JavaIndex index = JavaIndex.getIndex(this.nd);
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                try (IReader readLock = this.nd.acquireReadLock();){
                    NdTypeId typeId = index.findType(fieldDescriptor);
                    NdType targetType = null;
                    if (typeId != null) {
                        List<NdType> implementations = typeId.getTypes();
                        for (NdType nextType : implementations) {
                            NdResourceFile nextResourceFile = nextType.getResourceFile();
                            if (!nextResourceFile.equals(resourceFile)) continue;
                            targetType = nextType;
                            break;
                        }
                    }
                    if (targetType != null) {
                        IndexBinaryType actualType = new IndexBinaryType(TypeRef.create(targetType), indexPath);
                        IndexTester.testType(binaryType, actualType);
                    } else {
                        Package.logInfo("Could not find class in index immediately after indexing it: " + new String(indexPath));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException e) {
                Package.log("Error during indexing: " + new String(indexPath), e);
            }
        }
        return indexed;
    }

    private List<IJavaElement> getAllIndexableObjectsInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ArrayList<IJavaElement> allIndexables = new ArrayList<IJavaElement>();
        IProject[] projects = this.root.getProjects();
        ArrayList<IProject> projectsToScan = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject next = iProjectArray[n2];
            if (next.isOpen()) {
                projectsToScan.add(next);
            }
            ++n2;
        }
        HashSet<IPath> scannedPaths = new HashSet<IPath>();
        HashSet<IResource> resourcesToScan = new HashSet<IResource>();
        SubMonitor projectLoopMonitor = subMonitor.split(1).setWorkRemaining(projectsToScan.size());
        for (IProject project : projectsToScan) {
            SubMonitor iterationMonitor = projectLoopMonitor.split(1);
            try {
                int n3;
                if (!project.isOpen() || !project.isNatureEnabled("org.aspectj.org.eclipse.jdt.core.javanature")) continue;
                IJavaProject javaProject = JavaCore.create(project);
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                if (EXPERIMENTAL_INDEX_OUTPUT_FOLDERS) {
                    IPath defaultOutputLocation = javaProject.getOutputLocation();
                    IClasspathEntry[] iClasspathEntryArray = entries;
                    n3 = entries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource;
                        IClasspathEntry next = iClasspathEntryArray[n4];
                        IPath nextOutputLocation = next.getOutputLocation();
                        if (nextOutputLocation == null) {
                            nextOutputLocation = defaultOutputLocation;
                        }
                        if ((resource = this.root.findMember(nextOutputLocation)) != null) {
                            resourcesToScan.add(resource);
                        }
                        ++n4;
                    }
                }
                IPackageFragmentRoot[] projectRoots = javaProject.getAllPackageFragmentRoots();
                SubMonitor rootLoopMonitor = iterationMonitor.setWorkRemaining(projectRoots.length);
                IPackageFragmentRoot[] iPackageFragmentRootArray = projectRoots;
                int n5 = projectRoots.length;
                n3 = 0;
                while (n3 < n5) {
                    IPath filesystemPath;
                    IPackageFragmentRoot nextRoot = iPackageFragmentRootArray[n3];
                    rootLoopMonitor.split(1);
                    if (nextRoot.exists() && !scannedPaths.contains(filesystemPath = JavaIndex.getLocationForElement(nextRoot))) {
                        scannedPaths.add(filesystemPath);
                        if (nextRoot.getKind() == 2) {
                            if (nextRoot.isArchive()) {
                                allIndexables.add(nextRoot);
                            } else {
                                this.collectAllClassFiles(allIndexables, nextRoot);
                            }
                        } else {
                            this.collectAllClassFiles(allIndexables, nextRoot);
                        }
                    }
                    ++n3;
                }
            }
            catch (CoreException e) {
                Package.log(e);
            }
        }
        this.collectAllClassFiles(allIndexables, resourcesToScan, (IProgressMonitor)subMonitor.split(1));
        return allIndexables;
    }

    private void collectAllClassFiles(List<? super IClassFile> result, Collection<? extends IResource> toScan, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        ArrayDeque<Object> resources = new ArrayDeque<Object>();
        resources.addAll(toScan);
        while (!resources.isEmpty()) {
            IJavaElement element;
            IFile file;
            String extension;
            subMonitor.setWorkRemaining(Math.max(resources.size(), 3000)).split(1);
            IResource next = (IResource)resources.removeFirst();
            if (next instanceof IContainer) {
                IContainer container = (IContainer)next;
                try {
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource nextChild = iResourceArray[n2];
                        resources.addLast(nextChild);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Package.log(e);
                }
                continue;
            }
            if (!(next instanceof IFile) || !Objects.equals(extension = (file = (IFile)next).getFileExtension(), "class") || !((element = JavaCore.create(file)) instanceof IClassFile)) continue;
            result.add((IClassFile)element);
        }
    }

    private void collectAllClassFiles(List<? super IClassFile> result, IParent nextRoot) throws CoreException {
        IJavaElement[] iJavaElementArray = nextRoot.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            try {
                int type = child.getElementType();
                if (child.exists() && type != 5) {
                    if (type == 6) {
                        result.add((IClassFile)child);
                    } else if (child instanceof IParent) {
                        IParent parent = (IParent)((Object)child);
                        this.collectAllClassFiles(result, parent);
                    }
                }
            }
            catch (CoreException e) {
                Package.log(e);
            }
            ++n2;
        }
    }

    private List<IPath> getIndexablesThatHaveChanged(Collection<IPath> indexables, Map<IPath, FileFingerprint.FingerprintTestResult> fingerprints) {
        ArrayList<IPath> indexablesWithChanges = new ArrayList<IPath>();
        for (IPath next : indexables) {
            FileFingerprint.FingerprintTestResult testResult = fingerprints.get(next);
            if (testResult.matches()) continue;
            indexablesWithChanges.add(next);
        }
        return indexablesWithChanges;
    }

    private FileFingerprint.FingerprintTestResult testForChanges(IPath thePath, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        JavaIndex javaIndex = JavaIndex.getIndex(this.nd);
        String pathString = thePath.toString();
        subMonitor.split(50);
        NdResourceFile resourceFile = null;
        FileFingerprint fingerprint = FileFingerprint.getEmpty();
        this.nd.acquireReadLock();
        try {
            resourceFile = javaIndex.getResourceFile(pathString.toCharArray());
            if (resourceFile != null) {
                fingerprint = resourceFile.getFingerprint();
            }
        }
        finally {
            this.nd.releaseReadLock();
        }
        FileFingerprint.FingerprintTestResult result = fingerprint.test(thePath, (IProgressMonitor)subMonitor.split(40));
        if (resourceFile != null && result.matches() && result.needsNewFingerprint()) {
            this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(10));
            try {
                if (resourceFile.isInIndex()) {
                    if (DEBUG) {
                        Package.logInfo("Writing updated fingerprint for " + thePath + ": " + result.getNewFingerprint());
                    }
                    resourceFile.setFingerprint(result.getNewFingerprint());
                }
            }
            finally {
                this.nd.releaseWriteLock();
            }
        }
        return result;
    }

    public Indexer(Nd toPopulate, IWorkspaceRoot workspaceRoot) {
        this.nd = toPopulate;
        this.root = workspaceRoot;
        this.rescanJob.setSystem(true);
        this.rescanJob.setJobGroup(this.group);
        this.rebuildIndexJob.setSystem(true);
        this.rebuildIndexJob.setJobGroup(this.group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAll() {
        if (DEBUG) {
            Package.logInfo("Scheduling rescanAll now");
        }
        Object object = this.automaticIndexingMutex;
        synchronized (object) {
            if (!this.enableAutomaticIndexing) {
                if (!this.indexerDirtiedWhileDisabled) {
                    this.indexerDirtiedWhileDisabled = true;
                }
                return;
            }
        }
        this.rescanJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener newListener) {
        Object object = this.listenersMutex;
        synchronized (object) {
            Set<Listener> oldListeners = this.listeners;
            this.listeners = Collections.newSetFromMap(new WeakHashMap());
            this.listeners.addAll(oldListeners);
            this.listeners.add(newListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener oldListener) {
        Object object = this.listenersMutex;
        synchronized (object) {
            if (!this.listeners.contains(oldListener)) {
                return;
            }
            Set<Listener> oldListeners = this.listeners;
            this.listeners = Collections.newSetFromMap(new WeakHashMap());
            this.listeners.addAll(oldListeners);
            this.listeners.remove(oldListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(IndexerEvent event) {
        Set<Listener> localListeners;
        Object object = this.listenersMutex;
        synchronized (object) {
            localListeners = this.listeners;
        }
        for (Listener next : localListeners) {
            next.consume(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIndex(IProgressMonitor monitor) {
        try {
            boolean shouldRescan = false;
            Object object = this.automaticIndexingMutex;
            synchronized (object) {
                if (!this.enableAutomaticIndexing && this.indexerDirtiedWhileDisabled) {
                    shouldRescan = true;
                }
            }
            if (shouldRescan) {
                this.rescanJob.schedule();
            }
            this.rescanJob.join(0L, monitor);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    public void waitForIndex(int waitingPolicy, IProgressMonitor monitor) {
        switch (waitingPolicy) {
            case 1: {
                break;
            }
            case 2: {
                if (this.rescanJob.getState() == 0) break;
                throw new OperationCanceledException();
            }
            case 3: {
                this.waitForIndex(monitor);
            }
        }
    }

    public void rebuildIndex(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(1));
        try {
            this.nd.clear((IProgressMonitor)subMonitor.split(2));
        }
        finally {
            this.nd.releaseWriteLock();
        }
        this.rescan((IProgressMonitor)subMonitor.split(98));
    }

    public void requestRebuildIndex() {
        this.rebuildIndexJob.schedule();
    }

    public static interface Listener {
        public void consume(IndexerEvent var1);
    }
}

