/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.messagingsystem.api.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.URL;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.Request;
import org.eclipse.gemoc.commons.messagingsystem.api.reference.Reference;

public class ClientMessagingSystem
extends MessagingSystem {
    Socket kkSocket;
    ObjectOutputStream out = null;
    BufferedReader in = null;

    public ClientMessagingSystem(int port, String address) {
        try {
            this.kkSocket = new Socket(address, port);
            this.out = new ObjectOutputStream(this.kkSocket.getOutputStream());
            InputStreamReader isr = new InputStreamReader(System.in);
            this.in = new BufferedReader(isr);
        }
        catch (Exception e) {
            System.out.println("exception caught: " + e);
        }
    }

    @Override
    public void clearLog() {
        Request req = new Request();
        req.calledMethod = Request.Method.clearLog;
        try {
            this.out.writeObject(req);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void log(MessagingSystem.Kind msgKind, String message, String messageGroup) {
        Request req = new Request();
        req.message = message;
        req.messageGroup = messageGroup;
        req.calledMethod = Request.Method.log;
        req.msgKind = msgKind;
        try {
            this.out.writeObject(req);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void log(MessagingSystem.Kind msgKind, String message, String messageGroup, Throwable senderTrace) {
    }

    @Override
    public void logProblem(MessagingSystem.Kind msgKind, String message, String messageGroup, Reference causeObject) {
    }

    @Override
    public void logProblem(MessagingSystem.Kind msgKind, String message, String messageGroup, Throwable senderTrace, Reference causeObject) {
    }

    @Override
    public void flushProblem(String messageGroup, URL uri) {
    }

    @Override
    public void flushAllProblems(URL uri) {
    }

    @Override
    public BufferedReader getReader() {
        return null;
    }

    @Override
    public String readLine() {
        String result = "";
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            this.error("Failed to read line", "", e);
            return result;
        }
    }

    @Override
    public String readLine(String prompt) {
        this.log(MessagingSystem.Kind.UserINFO, prompt, "");
        return this.readLine();
    }

    @Override
    public void initProgress(String progressGroup, String message, String messageGroup, int nbWorkUnit) {
        Request req = new Request();
        req.message = message;
        req.progressGroup = progressGroup;
        req.messageGroup = messageGroup;
        req.calledMethod = Request.Method.initProgress;
        req.nbUnit = nbWorkUnit;
        try {
            this.out.writeObject(req);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void progress(String progressGroup, String message, String messageGroup, int workedUnit) {
        Request req = new Request();
        req.message = message;
        req.progressGroup = progressGroup;
        req.messageGroup = messageGroup;
        req.calledMethod = Request.Method.progress;
        req.nbUnit = workedUnit;
        try {
            this.out.writeObject(req);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doneProgress(String progressGroup, String message, String messageGroup) {
        Request req = new Request();
        req.message = message;
        req.progressGroup = progressGroup;
        req.messageGroup = messageGroup;
        req.calledMethod = Request.Method.doneProgress;
        req.messageGroup = messageGroup;
        try {
            this.out.writeObject(req);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.out.flush();
        this.kkSocket.close();
        super.finalize();
    }
}

