/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class EcoreToolsViewpoints {
    private ViewpointRegistry registry;

    public EcoreToolsViewpoints(ViewpointRegistry registry) {
        this.registry = registry;
    }

    public Viewpoint design() {
        URI uri = URI.createURI((String)"viewpoint:/org.eclipse.emf.ecoretools.design/Design");
        return this.getViewpointOrNull(uri);
    }

    protected Viewpoint getViewpointOrNull(URI uri) {
        try {
            return this.registry.getViewpoint(uri);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Viewpoint archetype() {
        return this.getViewpointOrNull(URI.createURI((String)"viewpoint:/org.eclipse.emf.ecoretools.design/Archetype"));
    }

    public Viewpoint review() {
        return this.getViewpointOrNull(URI.createURI((String)"viewpoint:/org.eclipse.emf.ecoretools.design/Review"));
    }

    public Viewpoint generation() {
        return this.getViewpointOrNull(URI.createURI((String)"viewpoint:/org.eclipse.emf.ecoretools.design/Generation"));
    }

    public Set<Viewpoint> all() {
        LinkedHashSet ecoreToolsViewpoints = Sets.newLinkedHashSet();
        Viewpoint vp = this.design();
        if (vp != null) {
            ecoreToolsViewpoints.add(vp);
        }
        if ((vp = this.archetype()) != null) {
            ecoreToolsViewpoints.add(vp);
        }
        if ((vp = this.review()) != null) {
            ecoreToolsViewpoints.add(vp);
        }
        if ((vp = this.generation()) != null) {
            ecoreToolsViewpoints.add(vp);
        }
        return ecoreToolsViewpoints;
    }

    public static EcoreToolsViewpoints fromViewpointRegistry() {
        return new EcoreToolsViewpoints(ViewpointRegistry.getInstance());
    }
}

