/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.gemoc.validation

import org.eclipse.gemoc.dsl.Dsl
import org.eclipse.gemoc.dsl.DslPackage
import org.eclipse.gemoc.dsl.Entry
import org.eclipse.xtext.validation.Check
import org.eclipse.core.runtime.IConfigurationElement
import java.util.ArrayList
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Message
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Severity
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.LanguageComponentHelper
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.ILanguageComponentValidator

/**
 * This class contains custom validation rules. 
 *
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
class DslValidator extends AbstractDslValidator {
	
	public static val MISSING_NAME = 'missingName'
	public static val MISSING_KEY = 'missingKey'
	public static val DUPLICATEKEY = 'duplicateKey'
	
	public val LanguageComponentHelper languageHelper = new LanguageComponentHelper();

	@Check
	def checkDSLHasName(Dsl dsl) {
		if (dsl.name.isEmpty) {
			error('Missing an entry "name"', 
					DslPackage.Literals.DSL__NAME,
					MISSING_NAME)
		}
	}
	
	@Check
	def checkDuplicateKeys(Entry entry) {
		val dsl = entry.eContainer as Dsl
		if (!dsl.entries.filter[e | e.key == entry.key].forall[e | e === entry]) {
			error('Duplicate key "'+entry.key+'"', 
					DslPackage.Literals.ENTRY__KEY,
					DUPLICATEKEY)
		}
	}
		
	// Performs checks provided by the required metaprogramming approach's validator for each entry in the dsl file
	@Check
	def checkForEntry(Entry entry) {
		
		var dsl = entry.eContainer
		
		if(dsl instanceof Dsl){
			for(IConfigurationElement key : getKeys(dsl)) {
				val ILanguageComponentValidator rule = key.createExecutableExtension("validationRule") as ILanguageComponentValidator
				var message = rule.validate(entry)
			
				switch message.getSeverity() {
				
					case Severity.ERROR :	error(message.getContent(),
														DslPackage.Literals.ENTRY__VALUE
														)
					case Severity.WARNING :	warning(message.getContent(),
														DslPackage.Literals.ENTRY__VALUE
													)
					case Severity.INFO :	info(message.getContent(),
														DslPackage.Literals.ENTRY__VALUE
													)
					case Severity.DEFAULT : message = new Message()
				
					default : print("Unknown severity")
				}
			}
		}
		
		

	}
	
	@Check
	def checkForApproachEntry(Dsl dsl) {
		if(dsl.getEntries().filter[e | e.key == "metaprog"].isEmpty) {
			warning("Missing \"metaprog\" entry to define the metaprogramming approach used", DslPackage.Literals.DSL__NAME)
		}
	}
	
	@Check
	def checkApproach(Entry entry) {
		
		var ArrayList<String> approachesList = new ArrayList<String>()
		
		if("metaprog".matches(entry.key)){
				
				var exts = getExtensions()
				
				for(IConfigurationElement elem : exts){
					approachesList.add(elem.getAttribute("name"))
				}
				
				if(!approachesList.contains(entry.getValue())){
				error("Unknown metaprogramming approach", DslPackage.Literals.ENTRY__VALUE)
				}
		}
	}
	
	
	@Check
	def checkMissingKeys(Dsl dsl){
		
		var ArrayList<String> dslKeys = new ArrayList<String>()
		for(Entry entry : dsl.getEntries){
			dslKeys.add(entry.getKey)
		}
		var keys = getKeys(dsl)
		
		for(IConfigurationElement elem : keys){
			var name = elem.getAttribute("name")
			if((!dslKeys.contains(name)) && ("false".matches(elem.getAttribute("optional")))){
				error("Missing entry " + name + " in the dsl file.", DslPackage.Literals.DSL__NAME, MISSING_KEY)
			}
			
		}
	}
	
	def getExtensions(){
		return org.eclipse.core.runtime.Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.gemoc_language_workbench.metaprog")
	}
	
	def getApproach(Dsl dsl){
		for (Entry entry : dsl.getEntries()){
			if("metaprog".matches(entry.getKey)){
				return entry.getValue
			}
		}
	}
	
	def getKeys(Dsl dsl){
		return languageHelper.getFullApproachKeys(getApproach(dsl))
	}
	
}
