/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EvaluationEnvironmentWithHiddenOpposites;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OppositePropertyCallExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.delegate.InvocationBehavior;
import org.eclipse.ocl.ecore.delegate.SettingBehavior;
import org.eclipse.ocl.ecore.utilities.VisitorExtension;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationVisitorImpl
extends org.eclipse.ocl.EvaluationVisitorImpl<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>
implements VisitorExtension<Object> {
    public EvaluationVisitorImpl(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> evalEnv, Map<? extends EClass, ? extends Set<? extends EObject>> extentMap) {
        super(env, evalEnv, extentMap);
    }

    @Override
    public Object visitOppositePropertyCallExp(OppositePropertyCallExp pc) {
        EReference property = pc.getReferredOppositeProperty();
        org.eclipse.ocl.expressions.OCLExpression source = pc.getSource();
        Object context = source.accept((Visitor)this.getVisitor());
        if (this.isUndefined(context)) {
            return this.getInvalid();
        }
        Object result = ((EvaluationEnvironmentWithHiddenOpposites)this.getEvaluationEnvironment()).navigateOppositeProperty(property, context);
        if (pc.getType() instanceof CollectionType && !(result instanceof Collection)) {
            CollectionKind kind = ((CollectionType)pc.getType()).getKind();
            Collection collection = CollectionUtil.createNewCollection((CollectionKind)kind);
            if (result != null) {
                collection.add(result);
            }
            result = collection;
        }
        return result;
    }

    protected org.eclipse.ocl.expressions.OCLExpression<EClassifier> getOperationBody(EOperation operation) {
        OCLExpression result = InvocationBehavior.INSTANCE.getCachedOCLExpression(operation);
        if (result == InvocationBehavior.NO_OCL_DEFINITION) {
            result = null;
        } else if (result == null) {
            if (InvocationBehavior.INSTANCE.hasCompileableOperationBody(operation)) {
                OCL ocl = OCL.newInstance((EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.getEnvironment().getFactory());
                result = InvocationBehavior.INSTANCE.getOperationBody(ocl, operation);
                ocl.dispose();
            }
            if (result == null) {
                result = super.getOperationBody((Object)operation);
            }
        }
        return result;
    }

    protected org.eclipse.ocl.expressions.OCLExpression<EClassifier> getPropertyBody(EStructuralFeature property) {
        OCLExpression result = SettingBehavior.INSTANCE.getCachedOCLExpression(property);
        if (result == SettingBehavior.NO_OCL_DEFINITION) {
            result = null;
        } else if (result == null) {
            if (SettingBehavior.INSTANCE.hasCompileableFeatureBody(property)) {
                OCL ocl = OCL.newInstance((EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.getEnvironment().getFactory());
                result = SettingBehavior.INSTANCE.getFeatureBody(ocl, property);
                ocl.dispose();
            }
            if (result == null) {
                result = super.getPropertyBody((Object)property);
            }
        }
        return result;
    }
}

