/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.internal;

import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.AttributeNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.CodeLocation;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Context;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.DiagnosticsFactory;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.IDiagnosticFormatter;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.InternalError;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.MethodNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.MissingReturnStatement;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.NotIterable;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Operator;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ProhibitedAssignmentToSelf;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.TypeMismatch;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.TypeNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.UnsupportedOperator;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.VariableAlreadyDefined;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.VariableNotFound;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.core.interpreter.ServiceNotFoundException;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Scopes;
import org.eclipse.emf.ecoretools.ale.core.io.IOResources;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class MessageToDiagnosticAdapter {
    private final IAleEnvironment environment;
    private final IBehaviors behaviors;
    private final IDiagnosticFormatter formatter;

    MessageToDiagnosticAdapter(IAleEnvironment environment, IDiagnosticFormatter formatter) {
        this.environment = environment;
        this.behaviors = environment.getBehaviors();
        this.formatter = formatter;
    }

    public BasicDiagnostic newDiagnostic(Object data, String message) {
        return new BasicDiagnostic(4, "org.eclipse.emf.ecoretools.ale.core", 0, message, new Object[]{data});
    }

    BasicDiagnostic alreadyBound(ForEach source, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(source));
        this.getFile(source).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        Object duplicate = this.getPreviousDeclarationOf(source.getVariable(), source);
        CodeLocation duplicateLocation = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        duplicateLocation.setLine(this.getLine(duplicate));
        duplicateLocation.setSource(this.getFile(duplicate).orElse(""));
        VariableAlreadyDefined unexpected = DiagnosticsFactory.eINSTANCE.createVariableAlreadyDefined();
        unexpected.setName(source.getVariable());
        unexpected.setSource(source);
        unexpected.setContext(context);
        unexpected.setLocation(location);
        unexpected.setWholeCode(this.getCode(source));
        unexpected.setIncriminatedCode(source.getVariable());
        unexpected.setDuplicateLocation(duplicateLocation);
        return this.newDiagnostic(source, this.formatter.adapt(unexpected));
    }

    BasicDiagnostic alreadyBound(VariableDeclaration source, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(source));
        this.getFile(source).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        Object duplicate = this.getPreviousDeclarationOf(source.getName(), source);
        CodeLocation duplicateLocation = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        duplicateLocation.setLine(this.getLine(duplicate));
        duplicateLocation.setSource(this.getFile(duplicate).orElse(""));
        VariableAlreadyDefined unexpected = DiagnosticsFactory.eINSTANCE.createVariableAlreadyDefined();
        unexpected.setName(source.getName());
        unexpected.setSource(source);
        unexpected.setContext(context);
        unexpected.setLocation(location);
        unexpected.setWholeCode(this.getCode(source));
        unexpected.setIncriminatedCode(source.getName());
        unexpected.setDuplicateLocation(duplicateLocation);
        return this.newDiagnostic(source, this.formatter.adapt(unexpected));
    }

    BasicDiagnostic assignmentToSelf(VariableAssignment assignment, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(assignment));
        this.getFile(assignment).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        ProhibitedAssignmentToSelf unexpected = DiagnosticsFactory.eINSTANCE.createProhibitedAssignmentToSelf();
        unexpected.setSource(assignment);
        unexpected.setContext(context);
        unexpected.setLocation(location);
        unexpected.setWholeCode(this.getCode(assignment));
        unexpected.setIncriminatedCode(assignment.getName());
        return this.newDiagnostic(assignment, this.formatter.adapt(unexpected));
    }

    BasicDiagnostic attributeNotFound(String name, EObject source, EClass owner, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(source));
        this.behaviors.findParsedFileDefining(source).map(ParsedFile::getSourceFile).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        AttributeNotFound notfound = DiagnosticsFactory.eINSTANCE.createAttributeNotFound();
        notfound.setName(name);
        notfound.setSource(source);
        notfound.setContext(context);
        notfound.setLocation(location);
        notfound.setWholeCode(this.getCode(source));
        notfound.setIncriminatedCode(name);
        notfound.setOwner(owner);
        return this.newDiagnostic(source, this.formatter.adapt(notfound));
    }

    BasicDiagnostic internalError(Object data, Throwable cause) {
        InternalError internal = DiagnosticsFactory.eINSTANCE.createInternalError();
        internal.setMessage(cause.getMessage());
        internal.setCause(cause);
        return this.newDiagnostic(data, this.formatter.adapt(internal));
    }

    BasicDiagnostic methodNotFound(Expression expression, ServiceNotFoundException notFound, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(expression));
        this.getFile(expression).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        MethodNotFound error = DiagnosticsFactory.eINSTANCE.createMethodNotFound();
        error.setSource((EObject)expression);
        error.setContext(context);
        error.setLocation(location);
        error.setWholeCode(this.getCode(expression));
        error.setIncriminatedCode(error.getWholeCode().substring(error.getWholeCode().indexOf(46) + 1));
        error.setName(notFound.getServiceName());
        error.getArguments().addAll(notFound.getArguments());
        error.getArgumentTypes().addAll(notFound.getArgumentTypes());
        return this.newDiagnostic(expression, this.formatter.adapt(error));
    }

    BasicDiagnostic missingReturnStatement(Method method, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(method));
        this.getFile(method).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        MissingReturnStatement missing = DiagnosticsFactory.eINSTANCE.createMissingReturnStatement();
        missing.setSource(method);
        missing.setMethod(method);
        missing.setContext(context);
        missing.setLocation(location);
        missing.setWholeCode(this.getCode(method));
        missing.setIncriminatedCode(this.getCode(method));
        return this.newDiagnostic(method, this.formatter.adapt(missing));
    }

    BasicDiagnostic notIterable(ForEach foreach, Set<IType> valueTypes, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(foreach));
        this.getFile(foreach).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        NotIterable unsupported = DiagnosticsFactory.eINSTANCE.createNotIterable();
        unsupported.setSource(foreach);
        unsupported.setContext(context);
        unsupported.setLocation(location);
        unsupported.setWholeCode("for (" + foreach.getVariable() + " in " + this.getCode(foreach.getCollectionExpression()) + ") {");
        unsupported.setIncriminatedCode(this.getCode(foreach.getCollectionExpression()));
        unsupported.getActualTypes().addAll(valueTypes);
        return this.newDiagnostic(foreach, this.formatter.adapt(unsupported));
    }

    BasicDiagnostic typeMismatch(EObject source, Object incriminatedElement, Set<IType> expectedTypes, Set<IType> actualTypes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(source));
        this.behaviors.findParsedFileDefining(source).map(ParsedFile::getSourceFile).ifPresent(location::setSource);
        TypeMismatch mismatch = DiagnosticsFactory.eINSTANCE.createTypeMismatch();
        mismatch.setSource(source);
        mismatch.setLocation(location);
        mismatch.setWholeCode(this.getCode(source));
        mismatch.setIncriminatedCode(this.getCode(incriminatedElement));
        mismatch.getExpectedTypes().addAll(expectedTypes);
        mismatch.getActualTypes().addAll(actualTypes);
        return this.newDiagnostic(source, this.formatter.adapt(mismatch));
    }

    BasicDiagnostic typeMismatch(If source, Object incriminatedElement, Set<IType> expectedTypes, Set<IType> actualTypes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(source));
        this.getFile(source).ifPresent(location::setSource);
        TypeMismatch mismatch = DiagnosticsFactory.eINSTANCE.createTypeMismatch();
        mismatch.setSource(source);
        mismatch.setLocation(location);
        mismatch.setWholeCode("if (" + this.getCode(incriminatedElement) + ") {");
        mismatch.setIncriminatedCode(this.getCode(incriminatedElement));
        mismatch.getExpectedTypes().addAll(expectedTypes);
        mismatch.getActualTypes().addAll(actualTypes);
        return this.newDiagnostic(source, this.formatter.adapt(mismatch));
    }

    BasicDiagnostic typeMismatch(While source, Object incriminatedElement, Set<IType> expectedTypes, Set<IType> actualTypes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(source));
        this.getFile(source).ifPresent(location::setSource);
        TypeMismatch mismatch = DiagnosticsFactory.eINSTANCE.createTypeMismatch();
        mismatch.setSource(source);
        mismatch.setLocation(location);
        mismatch.setWholeCode("while (" + this.getCode(incriminatedElement) + ") {");
        mismatch.setIncriminatedCode(this.getCode(incriminatedElement));
        mismatch.getExpectedTypes().addAll(expectedTypes);
        mismatch.getActualTypes().addAll(actualTypes);
        return this.newDiagnostic(source, this.formatter.adapt(mismatch));
    }

    BasicDiagnostic unresolvedType(EObject source, Object cause, String name, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(source));
        this.getFile(source).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        TypeNotFound notFound = DiagnosticsFactory.eINSTANCE.createTypeNotFound();
        notFound.setSource(source);
        notFound.setContext(context);
        notFound.setLocation(location);
        notFound.setWholeCode(this.getCode(source));
        notFound.setIncriminatedCode(this.getCode(cause));
        return this.newDiagnostic(source, this.formatter.adapt(notFound));
    }

    BasicDiagnostic unsupportedOperator(EObject expression, Object lhs, Object target, Operator operator, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(expression));
        this.getFile(expression).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        UnsupportedOperator unsupported = DiagnosticsFactory.eINSTANCE.createUnsupportedOperator();
        unsupported.setSource(expression);
        unsupported.setContext(context);
        unsupported.setLocation(location);
        unsupported.setWholeCode(this.getCode(expression));
        unsupported.setIncriminatedCode(this.getCode(lhs));
        unsupported.setOperator(operator);
        unsupported.setTarget(target);
        return this.newDiagnostic(expression, this.formatter.adapt(unsupported));
    }

    BasicDiagnostic variableNotFound(String name, EObject source, Scopes scopes) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.getLine(source));
        this.behaviors.findParsedFileDefining(source).map(ParsedFile::getSourceFile).ifPresent(location::setSource);
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        context.setScopes(scopes);
        VariableNotFound notfound = name.equals("result") ? DiagnosticsFactory.eINSTANCE.createAssignmentToResultInVoidOperation() : DiagnosticsFactory.eINSTANCE.createVariableNotFound();
        notfound.setName(name);
        notfound.setSource(source);
        notfound.setContext(context);
        notfound.setLocation(location);
        notfound.setWholeCode(this.getCode(source));
        notfound.setIncriminatedCode(name);
        return this.newDiagnostic(source, this.formatter.adapt(notfound));
    }

    private Object getPreviousDeclarationOf(String name, Statement declaration) {
        Method method = (Method)declaration.eContainer().eContainer();
        for (EParameter parameter : method.getOperationRef().getEParameters()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        for (Statement statement : method.getBody().getStatements()) {
            VariableDeclaration candidate;
            if (!(statement instanceof VariableDeclaration) || !(candidate = (VariableDeclaration)statement).getName().equals(name)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("cannot find duplicate declaration of " + declaration + " in " + method);
    }

    private int getLine(Object astElement) {
        return this.behaviors.findParsedFileDefining(astElement).map(file -> file.getLines(astElement).get(0)).orElse(0);
    }

    private Optional<String> getFile(Object astElement) {
        return this.environment.getBehaviors().findParsedFileDefining(astElement).map(ParsedFile::getSourceFile).map(File::new).map(IOResources::toIFile).map(file -> file.getFullPath().makeRelative().toString());
    }

    private String getCode(Object astElement) {
        if (astElement instanceof String) {
            return (String)astElement;
        }
        return this.behaviors.findParsedFileDefining(astElement).map(file -> file.getText(astElement).orElse("<code not found>")).orElse("<source file not found>");
    }
}

