/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedTransferQueue;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.BehavioralInterface;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.Event;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.executionframework.event.manager.CallNotification;
import org.eclipse.gemoc.executionframework.event.manager.CompositeCallRequest;
import org.eclipse.gemoc.executionframework.event.manager.ICallRequest;
import org.eclipse.gemoc.executionframework.event.manager.IEventEmitter;
import org.eclipse.gemoc.executionframework.event.manager.IEventManager;
import org.eclipse.gemoc.executionframework.event.manager.IEventManagerListener;
import org.eclipse.gemoc.executionframework.event.manager.IImplementationRelationship;
import org.eclipse.gemoc.executionframework.event.manager.IMetalanguageRuleExecutor;
import org.eclipse.gemoc.executionframework.event.manager.ISubtypingRelationship;
import org.eclipse.gemoc.executionframework.event.manager.RelationshipManager;
import org.eclipse.gemoc.executionframework.event.manager.ReturnNotification;
import org.eclipse.gemoc.executionframework.event.manager.SimpleCallRequest;
import org.eclipse.gemoc.executionframework.event.manager.StopRequest;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrence;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrenceType;
import org.eclipse.gemoc.executionframework.event.model.event.StopEventOccurrence;
import org.eclipse.gemoc.executionframework.value.model.value.ManyReferenceValue;
import org.eclipse.gemoc.executionframework.value.model.value.SingleObjectValue;
import org.eclipse.gemoc.executionframework.value.model.value.SingleReferenceValue;
import org.eclipse.gemoc.executionframework.value.model.value.Value;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;

public class GenericEventManager
implements IEventManager {
    private final LinkedTransferQueue<ICallRequest> callRequestQueue = new LinkedTransferQueue();
    private final LinkedTransferQueue<EventOccurrence> eventOccurrenceQueue = new LinkedTransferQueue();
    private boolean canManageEvents = true;
    private boolean waitForCallRequests = false;
    private IExecutionEngine<?> engine;
    private boolean initialized = false;
    private final RelationshipManager relationshipManager;
    private final Map<String, IMetalanguageRuleExecutor> metalanguageIntegrations = new HashMap<String, IMetalanguageRuleExecutor>();
    private Map<BehavioralInterface, List<IEventManagerListener>> listeners = new HashMap<BehavioralInterface, List<IEventManagerListener>>();
    private final Set<BehavioralInterface> allBehavioralInterfaces = new HashSet<BehavioralInterface>();

    public GenericEventManager() {
        this.relationshipManager = new RelationshipManager(this);
    }

    @Override
    public RelationshipManager getRelationshipManager() {
        return this.relationshipManager;
    }

    public void engineAboutToStart(IExecutionEngine<?> engine) {
        this.configure(engine);
    }

    private void configure(IExecutionEngine<?> engine) {
        Dsl dsl = DslHelper.load((String)engine.getExecutionContext().getLanguageDefinitionExtension().getName());
        Entry implementationRelationshipEntry = dsl.getEntry("implementation_relationships");
        if (implementationRelationshipEntry != null) {
            Entry subtypingRelationshipEntry = dsl.getEntry("subtyping_relationships");
            List<IImplementationRelationship> implementationRelationships = Arrays.stream(implementationRelationshipEntry.getValue().split(",")).map(s -> this.getImplementationRelationship(s.trim())).filter(r -> r != null).collect(Collectors.toList());
            List<ISubtypingRelationship> subtypingRelationships = subtypingRelationshipEntry != null ? Arrays.stream(subtypingRelationshipEntry.getValue().split(",")).map(s -> this.getSubtypingRelationship(s.trim())).filter(r -> r != null).collect(Collectors.toList()) : Collections.emptyList();
            implementationRelationships.forEach(r -> this.relationshipManager.registerImplementationRelationship((IImplementationRelationship)r));
            subtypingRelationships.forEach(r -> this.relationshipManager.registerSubtypingRelationship((ISubtypingRelationship)r));
        }
    }

    private IImplementationRelationship getImplementationRelationship(String relationshipId) {
        IConfigurationElement[] implementationRelationships = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.executionframework.event.implementationrelationship");
        return Arrays.stream(implementationRelationships).filter(r -> r.getAttribute("id").equals(relationshipId)).findFirst().map(c -> {
            try {
                return (IImplementationRelationship)c.createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }).orElse(null);
    }

    private ISubtypingRelationship getSubtypingRelationship(String relationshipId) {
        IConfigurationElement[] subtypingRelationships = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.executionframework.event.subtypingrelationship");
        return Arrays.stream(subtypingRelationships).filter(r -> r.getAttribute("id").equals(relationshipId)).findFirst().map(c -> {
            try {
                return (ISubtypingRelationship)c.createExecutableExtension("Class");
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }).orElse(null);
    }

    public void engineInitialized(IExecutionEngine<?> executionEngine) {
        this.engine = executionEngine;
        this.relationshipManager.setExecutedResource(this.engine.getExecutionContext().getResourceModel());
        IConfigurationElement[] eventEmitters = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.executionframework.event.event_emitter");
        Arrays.stream(eventEmitters).forEach(e -> {
            try {
                ((IEventEmitter)e.createExecutableExtension("class")).setEventManager(this, this.engine.getExecutionContext().getResourceModel());
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        });
        this.initialized = true;
        EventOccurrence eventOccurrence = this.eventOccurrenceQueue.poll();
        while (eventOccurrence != null) {
            this.processEventOccurrence(eventOccurrence);
            eventOccurrence = this.eventOccurrenceQueue.poll();
        }
    }

    @Override
    public void processEventOccurrence(EventOccurrence eventOccurrence) {
        if (eventOccurrence instanceof StopEventOccurrence) {
            this.processCallRequest(new StopRequest());
        } else if (this.initialized) {
            this.convertEventToExecutedResource(eventOccurrence, this.engine.getExecutionContext().getResourceModel());
            this.relationshipManager.notifyEventOccurrence(eventOccurrence);
        } else {
            this.eventOccurrenceQueue.add(eventOccurrence);
        }
    }

    @Override
    public void addListener(IEventManagerListener listener) {
        listener.getBehavioralInterfaces().forEach(bi -> {
            List interfaceListeners = this.listeners.computeIfAbsent((BehavioralInterface)bi, itf -> new ArrayList());
            interfaceListeners.add(listener);
        });
    }

    @Override
    public void removeListener(IEventManagerListener listener) {
        listener.getBehavioralInterfaces().forEach(bi -> {
            List<IEventManagerListener> interfaceListeners = this.listeners.get(bi);
            if (interfaceListeners != null) {
                interfaceListeners.add(listener);
            }
        });
    }

    @Override
    public void processCallRequests() {
        if (this.canManageEvents) {
            ICallRequest callRequest = null;
            if (this.waitForCallRequests) {
                try {
                    this.engine.setEngineStatus(EngineStatus.RunStatus.WaitingForEvent);
                    callRequest = this.callRequestQueue.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.engine.setEngineStatus(EngineStatus.RunStatus.Running);
                this.waitForCallRequests = false;
            } else {
                callRequest = this.callRequestQueue.poll();
            }
            while (callRequest != null) {
                boolean runToCompletion = callRequest.isRunToCompletion();
                if (runToCompletion) {
                    this.canManageEvents = false;
                    this.handleCallRequest(callRequest);
                    this.canManageEvents = true;
                } else {
                    this.handleCallRequest(callRequest);
                }
                callRequest = this.callRequestQueue.poll();
            }
        }
    }

    @Override
    public void waitForCallRequests() {
        this.waitForCallRequests = true;
    }

    public void aboutToExecuteStep(IExecutionEngine<?> engine, Step<?> stepToExecute) {
        if (this.initialized) {
            MSEOccurrence mseOccurrence = stepToExecute.getMseoccurrence();
            String behavioralUnit = String.valueOf(mseOccurrence.getMse().getCaller().eClass().getInstanceClassName()) + "." + mseOccurrence.getMse().getAction().getName();
            Map<String, Object> argsMap = this.getArguments(mseOccurrence);
            CallNotification callNotification = new CallNotification(behavioralUnit, argsMap);
            this.relationshipManager.notifyCall(callNotification);
            this.processCallRequests();
        }
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> stepExecuted) {
        if (this.initialized) {
            MSEOccurrence mseOccurrence = stepExecuted.getMseoccurrence();
            String behavioralUnit = String.valueOf(mseOccurrence.getMse().getCaller().eClass().getInstanceClassName()) + "." + mseOccurrence.getMse().getAction().getName();
            Map<String, Object> argsMap = this.getArguments(mseOccurrence);
            ReturnNotification returnNotification = new ReturnNotification(behavioralUnit, argsMap, mseOccurrence.getResult());
            this.relationshipManager.notifyCall(returnNotification);
            this.processCallRequests();
        }
    }

    private Map<String, Object> getArguments(MSEOccurrence mseOccurrence) {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        MSE mse = mseOccurrence.getMse();
        argsMap.put("_self", mse.getCaller());
        EList parameters = mse.getAction().getEParameters();
        EList arguments = mseOccurrence.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            String key = ((EParameter)parameters.get(i)).getName();
            Object value = arguments.get(i);
            argsMap.put(key, value);
            ++i;
        }
        return argsMap;
    }

    @Override
    public Set<BehavioralInterface> getBehavioralInterfaces() {
        if (this.allBehavioralInterfaces.isEmpty()) {
            this.relationshipManager.getEvents().forEach(e -> {
                boolean bl = this.allBehavioralInterfaces.add((BehavioralInterface)e.eContainer());
            });
        }
        return this.allBehavioralInterfaces;
    }

    @Override
    public Set<Event> getEvents() {
        return this.relationshipManager.getEvents();
    }

    private void handleCallRequest(ICallRequest callRequest) {
        if (callRequest instanceof StopRequest) {
            this.engine.stop();
        } else if (callRequest instanceof CompositeCallRequest) {
            ((CompositeCallRequest)callRequest).getCallRequests().forEach(cr -> this.handleCallRequest((ICallRequest)cr));
        } else if (callRequest instanceof SimpleCallRequest) {
            SimpleCallRequest simpleCallRequest = (SimpleCallRequest)callRequest;
            IMetalanguageRuleExecutor ruleExecutor = this.metalanguageIntegrations.computeIfAbsent(simpleCallRequest.getMetalanguage(), m -> this.findMetalanguageRuleExecutor((String)m));
            if (ruleExecutor != null) {
                ruleExecutor.handleCallRequest(simpleCallRequest);
            } else {
                throw new IllegalArgumentException("No metalanguage rule executor was found for metalanguage " + simpleCallRequest.getMetalanguage());
            }
        }
    }

    private IMetalanguageRuleExecutor findMetalanguageRuleExecutor(String metalanguage) {
        return Arrays.stream(Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.executionframework.event.metalanguage_rule_executor")).filter(c -> c.getAttribute("metaprog").equals(metalanguage)).findFirst().map(c -> {
            IMetalanguageRuleExecutor result = null;
            try {
                result = (IMetalanguageRuleExecutor)c.createExecutableExtension("class");
                result.setExecutionEngine(this.engine);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return result;
        }).orElse(null);
    }

    private void convertReferences(EObject object, Resource executedResource, String executedResourceURI) {
        EList references = object.eClass().getEAllReferences();
        references.forEach(r -> {
            if (r.isMany()) {
                HashMap<EObject, EObject> toChange = new HashMap<EObject, EObject>();
                ((List)object.eGet((EStructuralFeature)r)).stream().forEach(o -> {
                    EObject refered = (EObject)o;
                    if (refered != null) {
                        String referedResourceURI;
                        EcoreUtil.resolveAll((EObject)refered);
                        Resource referedResource = refered.eResource();
                        if (referedResource != null && (referedResourceURI = referedResource.getURI().toString()).equals(executedResourceURI) && referedResource != executedResource) {
                            String uriFragment = referedResource.getURIFragment(refered);
                            EObject effectiveRefered = executedResource.getEObject(uriFragment);
                            toChange.put(refered, effectiveRefered);
                        }
                    }
                });
                toChange.forEach((o, n) -> {
                    List l = (List)object.eGet((EStructuralFeature)r);
                    l.add(l.indexOf(o), n);
                    l.remove(o);
                });
            } else {
                EObject refered = (EObject)object.eGet((EStructuralFeature)r);
                if (refered != null) {
                    String referedResourceURI;
                    EcoreUtil.resolveAll((EObject)refered);
                    Resource referedResource = refered.eResource();
                    if (referedResource != null && (referedResourceURI = referedResource.getURI().toString()).equals(executedResourceURI) && referedResource != executedResource) {
                        String uriFragment = referedResource.getURIFragment(refered);
                        EObject effectiveRefered = executedResource.getEObject(uriFragment);
                        object.eSet((EStructuralFeature)r, (Object)effectiveRefered);
                    }
                }
            }
        });
    }

    private void convertReferencesToExecutedResource(EObject root, Resource executedResource, String executedResourceURI) {
        this.convertReferences(root, executedResource, executedResourceURI);
        root.eAllContents().forEachRemaining(c -> this.convertReferences((EObject)c, executedResource, executedResourceURI));
    }

    private void convertEventToExecutedResource(EventOccurrence eventOccurrence, Resource executedResource) {
        String executedResourceURI = executedResource.getURI().toString();
        EcoreUtil.resolveAll((EObject)eventOccurrence);
        eventOccurrence.getArgs().forEach(a -> {
            Value value = a.getValue();
            if (value instanceof SingleReferenceValue) {
                SingleReferenceValue v = (SingleReferenceValue)value;
                EObject parameter = v.getReferenceValue();
                Resource parameterResource = parameter.eResource();
                String uriFragment = parameterResource.getURIFragment(parameter);
                EObject effectiveParameter = executedResource.getEObject(uriFragment);
                v.setReferenceValue(effectiveParameter);
            } else if (value instanceof SingleObjectValue) {
                SingleObjectValue v = (SingleObjectValue)value;
                EObject parameter = v.getObjectValue();
                this.convertReferencesToExecutedResource(parameter, executedResource, executedResourceURI);
            } else if (value instanceof ManyReferenceValue) {
                ManyReferenceValue v = (ManyReferenceValue)value;
                EList parameters = v.getReferenceValues();
                List effectiveParameters = parameters.stream().map(p -> {
                    Resource parameterResource = p.eResource();
                    String uriFragment = parameterResource.getURIFragment(p);
                    return executedResource.getEObject(uriFragment);
                }).collect(Collectors.toList());
                parameters.clear();
                parameters.addAll(effectiveParameters);
            }
        });
    }

    @Override
    public void emitEventOccurrence(EventOccurrence eventOccurrence) {
        Event event = eventOccurrence.getEvent();
        if (eventOccurrence.getType() == EventOccurrenceType.EXPOSED) {
            BehavioralInterface behavioralInterface = (BehavioralInterface)event.eContainer();
            this.listeners.getOrDefault(behavioralInterface, Collections.emptyList()).forEach(l -> l.eventReceived(eventOccurrence));
        }
    }

    @Override
    public void processCallRequest(ICallRequest callRequest) {
        this.callRequestQueue.put(callRequest);
    }
}

